/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.ui.AccountKitActivity;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.ActivityEmailHandler;
import com.facebook.accountkit.ui.ActivityHandler;
import com.facebook.accountkit.ui.LoginFlowManager;
import com.facebook.accountkit.ui.LoginType;

class EmailLoginFlowManager
extends LoginFlowManager {
    private String email;
    public static final Parcelable.Creator<EmailLoginFlowManager> CREATOR = new Parcelable.Creator<EmailLoginFlowManager>(){

        public EmailLoginFlowManager createFromParcel(Parcel source) {
            return new EmailLoginFlowManager(source);
        }

        public EmailLoginFlowManager[] newArray(int size) {
            return new EmailLoginFlowManager[size];
        }
    };

    public EmailLoginFlowManager(AccountKitConfiguration configuration) {
        super(LoginType.EMAIL);
        this.activityHandler = new ActivityEmailHandler(configuration);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void logInWithEmail(AccountKitActivity.ResponseType responseType, @Nullable String initialAuthState) {
        if (!this.isValid() || this.email == null) {
            return;
        }
        AccountKitController.logInWithEmail(this.email, responseType.getValue(), initialAuthState);
    }

    protected EmailLoginFlowManager(Parcel parcel) {
        super(parcel);
        this.activityHandler = (ActivityHandler)parcel.readParcelable(ActivityEmailHandler.class.getClassLoader());
        this.email = parcel.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.activityHandler, flags);
        dest.writeString(this.email);
    }
}

