/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.design.widget.TextInputLayout;
import android.support.v4.content.LocalBroadcastManager;
import android.text.Editable;
import android.text.Html;
import android.text.Spanned;
import android.text.TextWatcher;
import android.util.Log;
import android.util.Patterns;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.R;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.ButtonContentController;
import com.facebook.accountkit.ui.ButtonType;
import com.facebook.accountkit.ui.Buttons;
import com.facebook.accountkit.ui.ContentControllerBase;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.LoginFlowBroadcastReceiver;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.SkinManager;
import com.facebook.accountkit.ui.StaticContentFragmentFactory;
import com.facebook.accountkit.ui.TextContentFragment;
import com.facebook.accountkit.ui.TitleFragmentFactory;
import com.facebook.accountkit.ui.UIManager;
import com.facebook.accountkit.ui.ViewStateFragment;
import com.facebook.accountkit.ui.ViewUtility;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.credentials.Credential;
import com.google.android.gms.auth.api.credentials.HintRequest;
import com.google.android.gms.common.api.GoogleApiClient;
import java.io.Serializable;
import java.util.List;

final class EmailLoginContentController
extends ContentControllerBase
implements ButtonContentController {
    private static final ButtonType DEFAULT_BUTTON_TYPE = ButtonType.NEXT;
    private static final LoginFlowState LOGIN_FLOW_STATE = LoginFlowState.EMAIL_INPUT;
    private static final int RESOLVE_HINT_REQUEST_CODE = 152;
    private BottomFragment bottomFragment;
    private ButtonType buttonType = DEFAULT_BUTTON_TYPE;
    private StaticContentFragmentFactory.StaticContentFragment centerFragment;
    private TitleFragmentFactory.TitleFragment footerFragment;
    private TitleFragmentFactory.TitleFragment headerFragment;
    private TextFragment textFragment;
    @Nullable
    private TopFragment topFragment;
    private OnCompleteListener onCompleteListener;

    EmailLoginContentController(AccountKitConfiguration configuration) {
        super(configuration);
        AccountKitController.initializeLogin();
    }

    @Override
    public ContentFragment getBottomFragment() {
        if (this.bottomFragment == null) {
            this.setBottomFragment(new BottomFragment());
        }
        return this.bottomFragment;
    }

    @Override
    public void setBottomFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof BottomFragment)) {
            return;
        }
        this.bottomFragment = (BottomFragment)fragment;
        this.bottomFragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)this.configuration.getUIManager());
        this.bottomFragment.setOnCompleteListener(this.getOnCompleteListener());
        this.updateNextButton();
    }

    @Override
    public ButtonType getButtonType() {
        return this.buttonType;
    }

    @Override
    public void setButtonType(ButtonType buttonType) {
        this.buttonType = buttonType;
        this.updateNextButton();
    }

    @Override
    public ContentFragment getCenterFragment() {
        if (this.centerFragment == null) {
            this.setCenterFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState(), R.layout.com_accountkit_fragment_email_login_center));
        }
        return this.centerFragment;
    }

    @Override
    public void setCenterFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.centerFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    @Override
    @Nullable
    public View getFocusView() {
        if (this.topFragment == null) {
            return null;
        }
        return this.topFragment.emailView;
    }

    @Override
    public TitleFragmentFactory.TitleFragment getFooterFragment() {
        if (this.footerFragment == null) {
            this.setFooterFragment(TitleFragmentFactory.create(this.configuration.getUIManager()));
        }
        return this.footerFragment;
    }

    @Override
    public void setFooterFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        this.footerFragment = fragment;
    }

    @Override
    public TitleFragmentFactory.TitleFragment getHeaderFragment() {
        if (this.headerFragment == null) {
            this.headerFragment = TitleFragmentFactory.create(this.configuration.getUIManager(), R.string.com_accountkit_email_login_title, new String[0]);
        }
        return this.headerFragment;
    }

    @Override
    public void setHeaderFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        this.headerFragment = fragment;
    }

    @Override
    public LoginFlowState getLoginFlowState() {
        return LOGIN_FLOW_STATE;
    }

    @Override
    public ContentFragment getTextFragment() {
        if (this.textFragment == null) {
            this.setTextFragment(new TextFragment());
        }
        return this.textFragment;
    }

    @Override
    public void setTextFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof TextFragment)) {
            return;
        }
        this.textFragment = (TextFragment)fragment;
        this.textFragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)this.configuration.getUIManager());
        this.textFragment.setNextButtonTextProvider(new TextContentFragment.NextButtonTextProvider(){

            @Override
            public String getNextButtonText() {
                if (EmailLoginContentController.this.bottomFragment == null) {
                    return null;
                }
                return EmailLoginContentController.this.textFragment.getResources().getText(EmailLoginContentController.this.bottomFragment.getNextButtonTextId()).toString();
            }
        });
    }

    @Override
    @Nullable
    public ContentFragment getTopFragment() {
        if (this.topFragment == null) {
            this.setTopFragment(new TopFragment());
        }
        return this.topFragment;
    }

    @Override
    public void setTopFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof TopFragment)) {
            return;
        }
        this.topFragment = (TopFragment)fragment;
        this.topFragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)this.configuration.getUIManager());
        this.topFragment.setOnEmailChangedListener(new TopFragment.OnEmailChangedListener(){

            @Override
            public void onEmailChanged() {
                EmailLoginContentController.this.updateNextButton();
            }
        });
        this.topFragment.setOnCompleteListener(this.getOnCompleteListener());
        if (this.configuration != null && this.configuration.getInitialEmail() != null) {
            this.topFragment.setAppSuppliedEmail(this.configuration.getInitialEmail());
        }
        this.updateNextButton();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    void setRetry() {
        if (this.headerFragment != null) {
            this.headerFragment.setTitleResourceId(R.string.com_accountkit_email_login_retry_title, new String[0]);
        }
        if (this.bottomFragment != null) {
            this.bottomFragment.setRetry(true);
        }
        if (this.textFragment != null) {
            this.textFragment.updateText();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Credential credential;
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 152 && resultCode == -1 && (credential = (Credential)data.getParcelableExtra("com.google.android.gms.credentials.Credential")) != null && this.topFragment != null) {
            this.topFragment.setRequestedHintEmail(credential.getId());
        }
    }

    @Override
    public void onResume(Activity activity) {
        super.onResume(activity);
        ViewUtility.showKeyboard(this.getFocusView());
    }

    private void updateNextButton() {
        if (this.topFragment == null || this.bottomFragment == null) {
            return;
        }
        this.bottomFragment.setNextButtonEnabled(!Utility.isNullOrEmpty(this.topFragment.getEmail()));
        this.bottomFragment.setNextButtonType(this.getButtonType());
    }

    @Override
    protected void logImpression() {
        if (this.bottomFragment == null) {
            return;
        }
        AccountKitController.Logger.logUIEmailLoginShown(this.bottomFragment.getRetry());
    }

    private OnCompleteListener getOnCompleteListener() {
        if (this.onCompleteListener == null) {
            this.onCompleteListener = new OnCompleteListener(){

                @Override
                public void onNext(Context context, String buttonName) {
                    if (EmailLoginContentController.this.topFragment == null) {
                        return;
                    }
                    String email = EmailLoginContentController.this.topFragment.getEmail();
                    if (email == null) {
                        return;
                    }
                    if (!Patterns.EMAIL_ADDRESS.matcher(email = email.trim()).matches()) {
                        if (EmailLoginContentController.this.headerFragment != null) {
                            EmailLoginContentController.this.headerFragment.setTitleResourceId(R.string.com_accountkit_email_invalid, new String[0]);
                        }
                        if (EmailLoginContentController.this.topFragment.emailViewLayout != null) {
                            EmailLoginContentController.this.topFragment.emailViewLayout.setError(context.getText(R.string.com_accountkit_email_invalid));
                        }
                        return;
                    }
                    if (EmailLoginContentController.this.topFragment.emailViewLayout != null) {
                        EmailLoginContentController.this.topFragment.emailViewLayout.setError(null);
                    }
                    Intent intent = new Intent(LoginFlowBroadcastReceiver.ACTION_UPDATE).putExtra(LoginFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)LoginFlowBroadcastReceiver.Event.EMAIL_LOGIN_COMPLETE)).putExtra(LoginFlowBroadcastReceiver.EXTRA_EMAIL, email);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                }
            };
        }
        return this.onCompleteListener;
    }

    static EmailSourceAppSupplied getEmailAppSuppliedSource(String appSuppliedEmail, String submittedEmail) {
        if (!Utility.isNullOrEmpty(appSuppliedEmail)) {
            if (appSuppliedEmail.equals(submittedEmail)) {
                return EmailSourceAppSupplied.APP_SUPPLIED_EMAIL_USED;
            }
            return EmailSourceAppSupplied.APP_SUPPLIED_EMAIL_CHANGED;
        }
        return EmailSourceAppSupplied.NO_APP_SUPPLIED_EMAIL;
    }

    static EmailSourceSelected getEmailSourceSelected(String selectedEmail, String submittedEmail, List<String> availableEmails) {
        if (!Utility.isNullOrEmpty(selectedEmail)) {
            if (selectedEmail.equals(submittedEmail)) {
                return EmailSourceSelected.SELECTED_USED;
            }
            return EmailSourceSelected.SELECTED_CHANGED;
        }
        if (availableEmails != null && !availableEmails.isEmpty()) {
            return EmailSourceSelected.SELECTED_NOT_USED;
        }
        return EmailSourceSelected.NO_SELECTABLE_EMAILS;
    }

    static /* synthetic */ ButtonType access$000() {
        return DEFAULT_BUTTON_TYPE;
    }

    public static final class TopFragment
    extends ContentFragment {
        private static final String APP_SUPPLIED_EMAIL_KEY = "appSuppliedEmail";
        private static final String SELECTED_EMAIL_KEY = "selectedEmail";
        private AutoCompleteTextView emailView;
        private TextInputLayout emailViewLayout;
        private OnEmailChangedListener onEmailChangedListener;
        private OnCompleteListener onCompleteListener;

        @Override
        LoginFlowState getLoginFlowState() {
            return LOGIN_FLOW_STATE;
        }

        @Override
        boolean isKeyboardFragment() {
            return false;
        }

        @Override
        protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            return inflater.inflate(R.layout.com_accountkit_fragment_email_login_top, container, false);
        }

        public void onStart() {
            super.onStart();
            this.fillEmail();
        }

        @Override
        protected void onViewReadyWithState(View view, Bundle viewState) {
            super.onViewReadyWithState(view, viewState);
            this.emailView = (AutoCompleteTextView)view.findViewById(R.id.com_accountkit_email);
            this.emailViewLayout = (TextInputLayout)view.findViewById(R.id.com_accountkit_email_layout);
            if (this.emailView != null) {
                this.emailView.addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                    }

                    public void onTextChanged(CharSequence s, int start, int before, int count) {
                    }

                    public void afterTextChanged(Editable s) {
                        if (TopFragment.this.onEmailChangedListener != null) {
                            TopFragment.this.onEmailChangedListener.onEmailChanged();
                        }
                    }
                });
                this.emailView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                        if (actionId == 5 && !Utility.isNullOrEmpty(TopFragment.this.getEmail())) {
                            if (TopFragment.this.onCompleteListener != null) {
                                TopFragment.this.onCompleteListener.onNext(v.getContext(), Buttons.EMAIL_LOGIN_NEXT_KEYBOARD.name());
                            }
                            return true;
                        }
                        return false;
                    }
                });
                this.emailView.setInputType(33);
            }
        }

        private void fillEmail() {
            GoogleApiClient googleApiClient;
            String appSuppliedEmail;
            Activity activity = this.getActivity();
            List<String> deviceEmails = Utility.getDeviceEmailsIfAvailable(activity.getApplicationContext());
            if (deviceEmails != null) {
                this.emailView.setAdapter((ListAdapter)new ArrayAdapter((Context)activity, 17367050, deviceEmails));
                this.emailView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View arg1, int pos, long id2) {
                        TopFragment.this.setSelectedEmail(TopFragment.this.emailView.getText().toString());
                    }
                });
            }
            if (!Utility.isNullOrEmpty(appSuppliedEmail = this.getAppSuppliedEmail())) {
                this.emailView.setText((CharSequence)appSuppliedEmail);
                this.emailView.setSelection(appSuppliedEmail.length());
            } else if (Utility.hasGooglePlayServices((Context)this.getActivity()) && (googleApiClient = this.getGoogleApiClient()) != null && this.getCurrentState() == LOGIN_FLOW_STATE && Utility.isNullOrEmpty(this.getEmail())) {
                HintRequest hintRequest = new HintRequest.Builder().setEmailAddressIdentifierSupported(true).build();
                PendingIntent intent = Auth.CredentialsApi.getHintPickerIntent(googleApiClient, hintRequest);
                try {
                    this.getActivity().startIntentSenderForResult(intent.getIntentSender(), 152, null, 0, 0, 0);
                }
                catch (IntentSender.SendIntentException e) {
                    Log.w((String)TAG, (String)"Failed to send intent", (Throwable)e);
                }
            }
        }

        public void setRequestedHintEmail(String email) {
            this.emailView.setText((CharSequence)email);
            this.emailView.setSelection(email.length());
        }

        public String getAppSuppliedEmail() {
            return this.getViewState().getString(APP_SUPPLIED_EMAIL_KEY);
        }

        public void setAppSuppliedEmail(String appSuppliedEmail) {
            this.getViewState().putString(APP_SUPPLIED_EMAIL_KEY, appSuppliedEmail);
        }

        @Nullable
        public String getEmail() {
            if (this.emailView == null) {
                return null;
            }
            return this.emailView.getText().toString();
        }

        public void setOnCompleteListener(@Nullable OnCompleteListener onCompleteListener) {
            this.onCompleteListener = onCompleteListener;
        }

        public void setOnEmailChangedListener(@Nullable OnEmailChangedListener onEmailChangedListener) {
            this.onEmailChangedListener = onEmailChangedListener;
        }

        public String getSelectedEmail() {
            return this.getViewState().getString(SELECTED_EMAIL_KEY);
        }

        public void setSelectedEmail(String selectedEmail) {
            this.getViewState().putString(SELECTED_EMAIL_KEY, selectedEmail);
        }

        public static interface OnEmailChangedListener {
            public void onEmailChanged();
        }
    }

    public static final class TextFragment
    extends TextContentFragment {
        private static final String ACCOUNT_KIT_URL = "https://www.accountkit.com/faq";

        @Override
        LoginFlowState getLoginFlowState() {
            return LOGIN_FLOW_STATE;
        }

        @Override
        boolean isKeyboardFragment() {
            return false;
        }

        @Override
        protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            return inflater.inflate(R.layout.com_accountkit_fragment_email_login_text, container, false);
        }

        @Override
        protected Spanned getText(String nextButtonText) {
            return Html.fromHtml((String)this.getString(R.string.com_accountkit_email_login_text, new Object[]{nextButtonText, AccountKit.getApplicationName(), ACCOUNT_KIT_URL}));
        }
    }

    public static final class BottomFragment
    extends ContentFragment {
        private static final String RETRY_KEY = "retry";
        private Button nextButton;
        private boolean nextButtonEnabled;
        private ButtonType nextButtonType = EmailLoginContentController.access$000();
        private OnCompleteListener onCompleteListener;

        @Override
        LoginFlowState getLoginFlowState() {
            return LOGIN_FLOW_STATE;
        }

        @Override
        boolean isKeyboardFragment() {
            return true;
        }

        @Override
        protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            View view = inflater.inflate(R.layout.com_accountkit_fragment_email_login_bottom, container, false);
            UIManager uiManager = this.getUIManager();
            if (uiManager instanceof SkinManager && ((SkinManager)uiManager).getSkin() == SkinManager.Skin.CONTEMPORARY) {
                View btn = view.findViewById(R.id.com_accountkit_next_button);
                ((ViewGroup)view).removeView(btn);
                view = btn;
                view.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
            }
            return view;
        }

        @Override
        protected void onViewReadyWithState(View view, Bundle viewState) {
            super.onViewReadyWithState(view, viewState);
            this.nextButton = (Button)view.findViewById(R.id.com_accountkit_next_button);
            if (this.nextButton != null) {
                this.nextButton.setEnabled(this.nextButtonEnabled);
                this.nextButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (BottomFragment.this.onCompleteListener != null) {
                            BottomFragment.this.onCompleteListener.onNext(v.getContext(), Buttons.EMAIL_LOGIN_NEXT.name());
                        }
                    }
                });
            }
            this.updateButtonText();
        }

        public void setNextButtonEnabled(boolean enabled) {
            this.nextButtonEnabled = enabled;
            if (this.nextButton != null) {
                this.nextButton.setEnabled(enabled);
            }
        }

        public void setNextButtonType(ButtonType buttonType) {
            this.nextButtonType = buttonType;
            this.updateButtonText();
        }

        @StringRes
        public int getNextButtonTextId() {
            if (this.getRetry()) {
                return R.string.com_accountkit_resend_email_text;
            }
            return this.nextButtonType.getValue();
        }

        public void setOnCompleteListener(@Nullable OnCompleteListener onCompleteListener) {
            this.onCompleteListener = onCompleteListener;
        }

        public boolean getRetry() {
            return this.getViewState().getBoolean(RETRY_KEY, false);
        }

        public void setRetry(boolean retry) {
            this.getViewState().putBoolean(RETRY_KEY, retry);
            this.updateButtonText();
        }

        private void updateButtonText() {
            if (this.nextButton != null) {
                this.nextButton.setText(this.getNextButtonTextId());
            }
        }
    }

    public static interface OnCompleteListener {
        public void onNext(Context var1, String var2);
    }

    static enum EmailSourceSelected {
        NO_SELECTABLE_EMAILS,
        SELECTED_CHANGED,
        SELECTED_NOT_USED,
        SELECTED_USED;

    }

    static enum EmailSourceAppSupplied {
        NO_APP_SUPPLIED_EMAIL,
        APP_SUPPLIED_EMAIL_CHANGED,
        APP_SUPPLIED_EMAIL_USED;

    }
}

