/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import com.facebook.accountkit.AccessToken;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.EmailLoginModel;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.InternalAccountKitError;
import com.facebook.accountkit.internal.LoginStatus;
import com.facebook.accountkit.ui.AccountKitActivity;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.EmailLoginFlowManager;
import java.io.Serializable;
import java.util.Date;

final class DemoEmailLoginFlowManager
extends EmailLoginFlowManager {
    private static final int MOCK_EMAIL_DELAY_MS = 6000;
    private static final int MOCK_NETWORK_DELAY_MS = 2000;
    private boolean isValid = true;
    private DemoEmailLoginModel loginModel;
    public static final Parcelable.Creator<DemoEmailLoginFlowManager> CREATOR = new Parcelable.Creator<DemoEmailLoginFlowManager>(){

        public DemoEmailLoginFlowManager createFromParcel(Parcel source) {
            return new DemoEmailLoginFlowManager(source);
        }

        public DemoEmailLoginFlowManager[] newArray(int size) {
            return new DemoEmailLoginFlowManager[size];
        }
    };

    public DemoEmailLoginFlowManager(AccountKitConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void cancel() {
        this.isValid = false;
        this.broadcastLoginState(LoginStatus.CANCELLED, null);
    }

    @Override
    public AccessToken getAccessToken() {
        if (!this.isValid) {
            return null;
        }
        return new AccessToken("TEST_ACCESS_TOKEN", "TEST_ACCOUNT_ID", AccountKit.getApplicationId(), 300000L, new Date());
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void logInWithEmail(AccountKitActivity.ResponseType responseType, String initialAuthState) {
        if (!this.isValid) {
            return;
        }
        final String email = this.getEmail();
        String confirmationCode = responseType == AccountKitActivity.ResponseType.CODE ? "DEMOCODE" : null;
        AccessToken accessToken = responseType == AccountKitActivity.ResponseType.TOKEN ? this.getAccessToken() : null;
        this.loginModel = new DemoEmailLoginModel(email, initialAuthState, confirmationCode, accessToken);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (email.endsWith("@example.com")) {
                    DemoEmailLoginFlowManager.this.broadcastLoginState(LoginStatus.PENDING, null);
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            DemoEmailLoginFlowManager.this.broadcastLoginState(LoginStatus.SUCCESS, null);
                        }
                    }, 6000L);
                } else {
                    InternalAccountKitError internalError = new InternalAccountKitError(15003, null, "[Demo] use *@example.com");
                    AccountKitError error = new AccountKitError(AccountKitError.Type.ARGUMENT_ERROR, internalError);
                    DemoEmailLoginFlowManager.this.broadcastLoginState(LoginStatus.ERROR, error);
                }
            }
        }, 2000L);
    }

    private void broadcastLoginState(LoginStatus status, AccountKitError error) {
        LocalBroadcastManager.getInstance((Context)AccountKitController.getApplicationContext()).sendBroadcast(new Intent("com.facebook.accountkit.sdk.ACTION_EMAIL_LOGIN_STATE_CHANGED").putExtra("com.facebook.accountkit.sdk.EXTRA_LOGIN_MODEL", (Parcelable)this.loginModel).putExtra("com.facebook.accountkit.sdk.EXTRA_LOGIN_STATUS", (Serializable)((Object)status)).putExtra("com.facebook.accountkit.sdk.EXTRA_LOGIN_ERROR", (Parcelable)error));
    }

    protected DemoEmailLoginFlowManager(Parcel parcel) {
        super(parcel);
    }

    private static class DemoEmailLoginModel
    implements EmailLoginModel {
        private final AccessToken accessToken;
        private final String authState;
        private final String confirmationCode;
        private final String email;
        public static final Parcelable.Creator<DemoEmailLoginModel> CREATOR = new Parcelable.Creator<DemoEmailLoginModel>(){

            public DemoEmailLoginModel createFromParcel(Parcel source) {
                return new DemoEmailLoginModel(source);
            }

            public DemoEmailLoginModel[] newArray(int size) {
                return new DemoEmailLoginModel[size];
            }
        };

        public DemoEmailLoginModel(String email, String authState, String confirmationCode, AccessToken accessToken) {
            this.email = email;
            this.authState = authState;
            this.confirmationCode = confirmationCode;
            this.accessToken = accessToken;
        }

        @Override
        public String getEmail() {
            return this.email;
        }

        @Override
        public String getFinalAuthState() {
            return this.authState;
        }

        @Override
        @Nullable
        public String getPrivacyPolicy() {
            return null;
        }

        @Override
        @Nullable
        public String getTermsOfService() {
            return null;
        }

        @Override
        public String getCode() {
            return null;
        }

        @Override
        public AccessToken getAccessToken() {
            return this.accessToken;
        }

        DemoEmailLoginModel(Parcel parcel) {
            this.accessToken = (AccessToken)parcel.readParcelable(AccessToken.class.getClassLoader());
            this.authState = parcel.readString();
            this.confirmationCode = parcel.readString();
            this.email = parcel.readString();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.accessToken, flags);
            dest.writeString(this.authState);
            dest.writeString(this.confirmationCode);
            dest.writeString(this.email);
        }
    }
}

