/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.R;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.BaseUIManager;
import com.facebook.accountkit.ui.ButtonContentController;
import com.facebook.accountkit.ui.ButtonType;
import com.facebook.accountkit.ui.Buttons;
import com.facebook.accountkit.ui.ContentControllerBase;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.NotifyingEditText;
import com.facebook.accountkit.ui.PrivacyPolicyFragment;
import com.facebook.accountkit.ui.StaticContentFragmentFactory;
import com.facebook.accountkit.ui.TitleFragmentFactory;
import com.facebook.accountkit.ui.UIManager;
import com.facebook.accountkit.ui.ViewUtility;

abstract class ConfirmationCodeContentController
extends ContentControllerBase
implements ButtonContentController {
    private static final LoginFlowState LOGIN_FLOW_STATE = LoginFlowState.CODE_INPUT;
    private static final ButtonType DEFAULT_BUTTON_TYPE = ButtonType.CONTINUE;
    private static final String NUMERIC_REGEX = "[0-9]+";
    private static final String ERROR_RESTART_KEY = "is_error_restart";
    private ButtonType buttonType = DEFAULT_BUTTON_TYPE;
    private StaticContentFragmentFactory.StaticContentFragment centerFragment;
    TitleFragmentFactory.TitleFragment footerFragment;
    @Nullable
    TitleFragment headerFragment;
    @Nullable
    TopFragment topFragment;
    @Nullable
    PrivacyPolicyFragment bottomFragment;
    private StaticContentFragmentFactory.StaticContentFragment textFragment;

    ConfirmationCodeContentController(AccountKitConfiguration configuration) {
        super(configuration);
    }

    @Override
    public ContentFragment getBottomFragment() {
        if (this.bottomFragment == null) {
            this.setBottomFragment(PrivacyPolicyFragment.create(this.configuration.getUIManager(), LOGIN_FLOW_STATE, this.getButtonType()));
        }
        return this.bottomFragment;
    }

    @Override
    public ButtonType getButtonType() {
        return this.buttonType;
    }

    @Override
    public void setButtonType(ButtonType buttonType) {
        this.buttonType = buttonType;
        this.updateNextButton();
    }

    @Override
    public ContentFragment getCenterFragment() {
        if (this.centerFragment == null) {
            this.setCenterFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState(), R.layout.com_accountkit_fragment_confirmation_code_center));
        }
        return this.centerFragment;
    }

    @Override
    public void setCenterFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.centerFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    @Override
    @Nullable
    public View getFocusView() {
        if (this.topFragment == null) {
            return null;
        }
        return this.topFragment.getFocusView();
    }

    @Override
    public TitleFragmentFactory.TitleFragment getFooterFragment() {
        if (this.footerFragment == null) {
            this.setFooterFragment(TitleFragmentFactory.create(this.configuration.getUIManager()));
        }
        return this.footerFragment;
    }

    @Override
    public void setFooterFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        this.footerFragment = fragment;
    }

    @Override
    public LoginFlowState getLoginFlowState() {
        return LoginFlowState.CODE_INPUT;
    }

    @Override
    public ContentFragment getTextFragment() {
        if (this.textFragment == null) {
            this.setTextFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState()));
        }
        return this.textFragment;
    }

    @Override
    public void setTextFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.textFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    @Override
    public ContentFragment getTopFragment() {
        if (this.topFragment == null) {
            this.setTopFragment(new TopFragment());
        }
        return this.topFragment;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    void setPhoneNumber(@Nullable PhoneNumber phoneNumber) {
        if (this.headerFragment != null) {
            this.headerFragment.setPhoneNumber(phoneNumber);
        }
    }

    void setDetectedConfirmationCode(@Nullable String detectedConfirmationCode) {
        if (this.topFragment == null) {
            return;
        }
        this.topFragment.setDetectedConfirmationCode(detectedConfirmationCode);
    }

    void updateNextButton() {
        if (this.topFragment == null || this.bottomFragment == null) {
            return;
        }
        this.bottomFragment.setNextButtonEnabled(this.topFragment.isConfirmationCodeValid());
        this.bottomFragment.setNextButtonType(this.getButtonType());
    }

    void setRetry(boolean retry) {
        if (this.headerFragment != null) {
            this.headerFragment.setRetry(retry);
        }
        if (this.bottomFragment != null) {
            this.bottomFragment.setRetry(retry);
        }
        if (retry && this.topFragment != null) {
            this.topFragment.onRetry();
        }
    }

    @Override
    protected void logImpression() {
        if (this.topFragment == null || this.bottomFragment == null) {
            return;
        }
        AccountKitController.Logger.logUIConfirmationCodeShown(this.bottomFragment.getRetry());
    }

    private static char[] getConfirmationCodeToPaste(Context context) {
        String pasteText = ConfirmationCodeContentController.getCurrentPasteText(context);
        if (pasteText != null && pasteText.length() == 6 && pasteText.matches(NUMERIC_REGEX)) {
            return pasteText.toCharArray();
        }
        return null;
    }

    private static String getCurrentPasteText(Context context) {
        ClipData.Item item;
        if (context == null) {
            return null;
        }
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        if (clipboard.hasPrimaryClip() && (item = clipboard.getPrimaryClip().getItemAt(0)).getText() != null) {
            return item.getText().toString();
        }
        return null;
    }

    public static final class TopFragment
    extends ContentFragment {
        private static final String DETECTED_CONFIRMATION_CODE_KEY = "detectedConfirmationCode";
        private static final String TEXT_UPDATED_KEY = "textUpdated";
        @Nullable
        private EditText[] confirmationCodeViews;
        private OnConfirmationCodeChangedListener onConfirmationCodeChangedListener;
        private PrivacyPolicyFragment.OnCompleteListener onCompleteListener;

        @Override
        LoginFlowState getLoginFlowState() {
            return LOGIN_FLOW_STATE;
        }

        @Override
        boolean isKeyboardFragment() {
            return true;
        }

        @Override
        protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            return inflater.inflate(R.layout.com_accountkit_fragment_confirmation_code_top, container, false);
        }

        @Nullable
        public View getFocusView() {
            if (this.confirmationCodeViews == null) {
                return null;
            }
            for (EditText confirmationCodeView : this.confirmationCodeViews) {
                if (confirmationCodeView.getText().length() != 0) continue;
                return confirmationCodeView;
            }
            return null;
        }

        private void clearCodeWhenRestart() {
            if (this.confirmationCodeViews == null) {
                return;
            }
            boolean isErrorRestart = this.getViewState().getBoolean(ConfirmationCodeContentController.ERROR_RESTART_KEY, false);
            if (isErrorRestart) {
                for (EditText confirmationCodeView : this.confirmationCodeViews) {
                    confirmationCodeView.setText((CharSequence)"");
                }
                this.getViewState().putBoolean(ConfirmationCodeContentController.ERROR_RESTART_KEY, false);
            }
        }

        public void onResume() {
            super.onResume();
            this.clearCodeWhenRestart();
            ViewUtility.showKeyboard(this.getFocusView());
        }

        @Override
        protected void onViewReadyWithState(View view, Bundle viewState) {
            super.onViewReadyWithState(view, viewState);
            UIManager uiManager = this.getUIManager();
            if (uiManager instanceof BaseUIManager) {
                EditText[] state = ((BaseUIManager)uiManager).getFlowState();
                if (state == LoginFlowState.ERROR) {
                    this.confirmationCodeViews = null;
                    this.getViewState().putBoolean(ConfirmationCodeContentController.ERROR_RESTART_KEY, true);
                    return;
                }
                if (state == LoginFlowState.VERIFIED) {
                    return;
                }
            }
            for (EditText confirmationCodeView : this.confirmationCodeViews = new EditText[]{(EditText)view.findViewById(R.id.com_accountkit_confirmation_code_1), (EditText)view.findViewById(R.id.com_accountkit_confirmation_code_2), (EditText)view.findViewById(R.id.com_accountkit_confirmation_code_3), (EditText)view.findViewById(R.id.com_accountkit_confirmation_code_4), (EditText)view.findViewById(R.id.com_accountkit_confirmation_code_5), (EditText)view.findViewById(R.id.com_accountkit_confirmation_code_6)}) {
                if (confirmationCodeView.getText().length() == 0) continue;
                confirmationCodeView.clearFocus();
            }
            TextView.OnEditorActionListener onEditorActionListener = new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                    if (actionId == 5 && TopFragment.this.isConfirmationCodeValid() && TopFragment.this.onCompleteListener != null) {
                        TopFragment.this.onCompleteListener.onNext(v.getContext(), Buttons.ENTER_CONFIRMATION_CODE_KEYBOARD.name());
                    }
                    return true;
                }
            };
            View.OnKeyListener onKeyListener = new View.OnKeyListener(){

                public boolean onKey(View v, int keyCode, KeyEvent event) {
                    EditText confirmationCodeView = (EditText)v;
                    if (keyCode >= 7 && keyCode <= 16 && event.getAction() == 0) {
                        String text = Character.toString((char)event.getUnicodeChar());
                        confirmationCodeView.setText((CharSequence)text);
                        return true;
                    }
                    if (keyCode == 67 && event.getAction() == 0) {
                        if (confirmationCodeView.getText().length() == 0) {
                            EditText previous = TopFragment.this.focusOnPrevious((View)confirmationCodeView);
                            if (previous != null) {
                                previous.setText((CharSequence)"");
                            }
                        } else {
                            confirmationCodeView.setText((CharSequence)"");
                        }
                        return true;
                    }
                    return false;
                }
            };
            for (final EditText confirmationCodeView : this.confirmationCodeViews) {
                confirmationCodeView.setRawInputType(18);
                confirmationCodeView.setOnEditorActionListener(onEditorActionListener);
                confirmationCodeView.setOnKeyListener(onKeyListener);
                if (confirmationCodeView instanceof NotifyingEditText) {
                    NotifyingEditText notifyingEditText = (NotifyingEditText)confirmationCodeView;
                    notifyingEditText.setOnSoftKeyListener(onKeyListener);
                    notifyingEditText.setPasteListener(new NotifyingEditText.PasteListener(){

                        @Override
                        public void onTextPaste() {
                            char[] code = ConfirmationCodeContentController.getConfirmationCodeToPaste((Context)TopFragment.this.getActivity());
                            if (code != null && TopFragment.this.confirmationCodeViews != null) {
                                for (int i = 0; i < code.length; ++i) {
                                    TopFragment.this.confirmationCodeViews[i].setText((CharSequence)String.valueOf(code[i]));
                                }
                            }
                        }
                    });
                }
                confirmationCodeView.addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                    }

                    public void onTextChanged(CharSequence s, int start, int before, int count) {
                    }

                    public void afterTextChanged(Editable s) {
                        if (!TopFragment.this.getTextUpdated()) {
                            TopFragment.this.setTextUpdated(true);
                        }
                        if (s.length() == 1) {
                            TopFragment.this.focusOnNext((View)confirmationCodeView);
                        }
                        if (TopFragment.this.onConfirmationCodeChangedListener != null) {
                            TopFragment.this.onConfirmationCodeChangedListener.onConfirmationCodeChanged();
                        }
                    }
                });
            }
            this.updateDetectedConfirmationCode();
            ViewUtility.showKeyboard(this.getFocusView());
        }

        @Nullable
        public String getConfirmationCode() {
            if (this.confirmationCodeViews == null) {
                return null;
            }
            StringBuilder confirmationCode = new StringBuilder();
            for (EditText confirmationCodeView : this.confirmationCodeViews) {
                confirmationCode.append((CharSequence)confirmationCodeView.getText());
            }
            return confirmationCode.toString();
        }

        @Nullable
        public String getDetectedConfirmationCode() {
            return this.getViewState().getString(DETECTED_CONFIRMATION_CODE_KEY);
        }

        public void setDetectedConfirmationCode(@Nullable String detectedConfirmationCode) {
            this.getViewState().putString(DETECTED_CONFIRMATION_CODE_KEY, detectedConfirmationCode);
            this.updateDetectedConfirmationCode();
        }

        public void setOnCompleteListener(@Nullable PrivacyPolicyFragment.OnCompleteListener onCompleteListener) {
            this.onCompleteListener = onCompleteListener;
        }

        public void setOnConfirmationCodeChangedListener(@Nullable OnConfirmationCodeChangedListener onConfirmationCodeChangedListener) {
            this.onConfirmationCodeChangedListener = onConfirmationCodeChangedListener;
        }

        public void onRetry() {
            if (this.confirmationCodeViews == null) {
                return;
            }
            for (EditText confirmationCodeView : this.confirmationCodeViews) {
                confirmationCodeView.setText((CharSequence)"");
            }
            if (this.confirmationCodeViews.length > 0) {
                this.confirmationCodeViews[0].requestFocus();
            }
        }

        private boolean getTextUpdated() {
            return this.getViewState().getBoolean(TEXT_UPDATED_KEY, false);
        }

        private void setTextUpdated(boolean textUpdated) {
            this.getViewState().putBoolean(TEXT_UPDATED_KEY, textUpdated);
        }

        private int getConfirmationCodeViewIndex(View view) {
            if (this.confirmationCodeViews == null) {
                return -1;
            }
            if (view != null) {
                int length = this.confirmationCodeViews.length;
                for (int i = 0; i < length; ++i) {
                    if (this.confirmationCodeViews[i] != view) continue;
                    return i;
                }
            }
            return -1;
        }

        private EditText focusOnNext(View currentView) {
            if (this.confirmationCodeViews == null) {
                return null;
            }
            int confirmationCodeIndex = this.getConfirmationCodeViewIndex(currentView);
            if (confirmationCodeIndex < this.confirmationCodeViews.length - 1) {
                EditText nextView = this.confirmationCodeViews[confirmationCodeIndex + 1];
                nextView.requestFocus();
                return nextView;
            }
            this.confirmationCodeViews[this.confirmationCodeViews.length - 1].setSelection(1);
            return null;
        }

        private EditText focusOnPrevious(View currentView) {
            if (this.confirmationCodeViews == null) {
                return null;
            }
            int confirmationCodeIndex = this.getConfirmationCodeViewIndex(currentView);
            if (confirmationCodeIndex > 0) {
                EditText previousView = this.confirmationCodeViews[confirmationCodeIndex - 1];
                previousView.requestFocus();
                return previousView;
            }
            return null;
        }

        public boolean isConfirmationCodeValid() {
            if (this.confirmationCodeViews == null) {
                return false;
            }
            for (EditText confirmationCodeView : this.confirmationCodeViews) {
                if (confirmationCodeView.getText().length() == 1) continue;
                return false;
            }
            return true;
        }

        private void updateDetectedConfirmationCode() {
            if (this.confirmationCodeViews == null) {
                return;
            }
            String detectedConfirmationCode = this.getDetectedConfirmationCode();
            if (Utility.isNullOrEmpty(detectedConfirmationCode)) {
                return;
            }
            int length = detectedConfirmationCode.length();
            if (length != this.confirmationCodeViews.length) {
                return;
            }
            for (EditText confirmationCodeView : this.confirmationCodeViews) {
                if (confirmationCodeView.getText().length() == 0) continue;
                return;
            }
            for (int i = 0; i < length; ++i) {
                this.confirmationCodeViews[i].setText((CharSequence)Character.toString(detectedConfirmationCode.charAt(i)));
            }
            this.confirmationCodeViews[this.confirmationCodeViews.length - 1].setSelection(1);
        }

        static interface OnConfirmationCodeChangedListener {
            public void onConfirmationCodeChanged();
        }
    }

    public static abstract class TitleFragment
    extends TitleFragmentFactory.TitleFragment {
        @Nullable
        OnCompleteListener onCompleteListener;
        @Nullable
        PhoneNumber phoneNumber;
        boolean retry = false;

        @Override
        public View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            return inflater.inflate(R.layout.com_accountkit_fragment_title, container, false);
        }

        void setPhoneNumber(PhoneNumber phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.setPhoneNumberView();
        }

        void setRetry(boolean retry) {
            this.retry = retry;
            this.setPhoneNumberView();
        }

        void setRetryWithoutViewUpdate(boolean retry) {
            this.retry = retry;
        }

        void setOnCompleteListener(@Nullable OnCompleteListener onCompleteListener) {
            this.onCompleteListener = onCompleteListener;
        }

        @Override
        protected void onViewReadyWithState(View view, Bundle viewState) {
            super.onViewReadyWithState(view, viewState);
            this.setPhoneNumberView();
        }

        public void onResume() {
            super.onResume();
            this.setPhoneNumberView();
        }

        abstract void setPhoneNumberView();

        public static interface OnCompleteListener {
            public void onEdit(Context var1);
        }
    }
}

