/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.text.Html;
import android.view.View;
import android.widget.TextView;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.LoginModel;
import com.facebook.accountkit.R;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.ButtonContentController;
import com.facebook.accountkit.ui.ButtonType;
import com.facebook.accountkit.ui.ContentControllerBase;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.LoginFlowBroadcastReceiver;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.PrivacyPolicyFragment;
import com.facebook.accountkit.ui.StaticContentFragmentFactory;
import com.facebook.accountkit.ui.TitleFragmentFactory;
import com.facebook.accountkit.ui.UIManager;
import com.facebook.accountkit.ui.ViewStateFragment;
import java.io.Serializable;

final class ConfirmAccountVerifiedContentController
extends ContentControllerBase
implements ButtonContentController {
    private static final ButtonType DEFAULT_BUTTON_TYPE = ButtonType.CONTINUE;
    private static final LoginFlowState LOGIN_FLOW_STATE = LoginFlowState.CONFIRM_ACCOUNT_VERIFIED;
    private PrivacyPolicyFragment bottomFragment;
    private ButtonType buttonType = DEFAULT_BUTTON_TYPE;
    private ContentFragment centerFragment;
    TitleFragmentFactory.TitleFragment footerFragment;
    TitleFragmentFactory.TitleFragment headerFragment;
    private ContentFragment textFragment;
    private ContentFragment topFragment;
    private PrivacyPolicyFragment.OnCompleteListener onCompleteListener;

    ConfirmAccountVerifiedContentController(AccountKitConfiguration configuration) {
        super(configuration);
    }

    @Override
    public ContentFragment getBottomFragment() {
        if (this.bottomFragment == null) {
            this.setBottomFragment(BottomFragment.create(this.configuration.getUIManager(), LOGIN_FLOW_STATE, DEFAULT_BUTTON_TYPE));
        }
        return this.bottomFragment;
    }

    @Override
    public void setBottomFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof BottomFragment)) {
            return;
        }
        this.bottomFragment = (BottomFragment)fragment;
        this.bottomFragment.setOnCompleteListener(this.getOnCompleteListener());
        this.bottomFragment.setRetryVisible(false);
        this.updateNextButton();
    }

    @Override
    public ButtonType getButtonType() {
        return this.buttonType;
    }

    @Override
    public void setButtonType(ButtonType buttonType) {
        this.buttonType = buttonType;
        this.updateNextButton();
    }

    @Override
    public ContentFragment getCenterFragment() {
        if (this.centerFragment == null) {
            this.setCenterFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState()));
        }
        return this.centerFragment;
    }

    @Override
    public void setCenterFragment(@Nullable ContentFragment fragment) {
        this.centerFragment = fragment;
    }

    @Override
    @Nullable
    public View getFocusView() {
        return null;
    }

    @Override
    public TitleFragmentFactory.TitleFragment getFooterFragment() {
        if (this.footerFragment == null) {
            this.setFooterFragment(TitleFragmentFactory.create(this.configuration.getUIManager()));
        }
        return this.footerFragment;
    }

    @Override
    public void setFooterFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        this.footerFragment = fragment;
    }

    @Override
    public TitleFragmentFactory.TitleFragment getHeaderFragment() {
        if (this.headerFragment == null) {
            this.setHeaderFragment(TitleFragmentFactory.create(this.configuration.getUIManager(), R.string.com_accountkit_account_verified, new String[0]));
        }
        return this.headerFragment;
    }

    @Override
    public void setHeaderFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        this.headerFragment = fragment;
    }

    @Override
    public LoginFlowState getLoginFlowState() {
        return LOGIN_FLOW_STATE;
    }

    @Override
    public ContentFragment getTextFragment() {
        if (this.textFragment == null) {
            this.setTextFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState()));
        }
        return this.textFragment;
    }

    @Override
    public void setTextFragment(@Nullable ContentFragment fragment) {
        this.textFragment = fragment;
    }

    @Override
    public ContentFragment getTopFragment() {
        if (this.topFragment == null) {
            this.setTopFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState()));
        }
        return this.topFragment;
    }

    @Override
    public void setTopFragment(@Nullable ContentFragment fragment) {
        this.topFragment = fragment;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    private void updateNextButton() {
        if (this.topFragment == null || this.bottomFragment == null) {
            return;
        }
        this.bottomFragment.setNextButtonType(this.getButtonType());
    }

    @Override
    protected void logImpression() {
        if (this.bottomFragment == null) {
            return;
        }
        AccountKitController.Logger.logUIConfirmAccountVerified(true, this.configuration.getLoginType());
    }

    private PrivacyPolicyFragment.OnCompleteListener getOnCompleteListener() {
        if (this.onCompleteListener == null) {
            this.onCompleteListener = new PrivacyPolicyFragment.OnCompleteListener(){

                @Override
                public void onNext(Context context, String buttonName) {
                    if (ConfirmAccountVerifiedContentController.this.topFragment == null || ConfirmAccountVerifiedContentController.this.bottomFragment == null) {
                        return;
                    }
                    Intent intent = new Intent(LoginFlowBroadcastReceiver.ACTION_UPDATE).putExtra(LoginFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)LoginFlowBroadcastReceiver.Event.CONFIRM_SEAMLESS_LOGIN));
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                }

                @Override
                public void onRetry(Context context) {
                }
            };
        }
        return this.onCompleteListener;
    }

    public static class BottomFragment
    extends PrivacyPolicyFragment {
        private static final String ACCOUNT_KIT_URL = "https://www.accountkit.com/faq";

        public static BottomFragment create(@NonNull UIManager uiManager, @NonNull LoginFlowState loginFlowState, @NonNull ButtonType nextButtonType) {
            BottomFragment fragment = new BottomFragment();
            fragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)uiManager);
            fragment.setLoginFlowState(loginFlowState);
            fragment.setNextButtonType(nextButtonType);
            return fragment;
        }

        @Override
        protected void updateTermsText(TextView termsTextView, CharSequence nextButtonText) {
            if (termsTextView == null) {
                return;
            }
            if (this.getActivity() == null) {
                return;
            }
            LoginModel loginModel = AccountKit.getCurrentLogInModel();
            if (loginModel != null && !Utility.isNullOrEmpty(loginModel.getPrivacyPolicy())) {
                if (!Utility.isNullOrEmpty(loginModel.getTermsOfService())) {
                    termsTextView.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.com_accountkit_confirmation_code_agreement_app_privacy_policy_and_terms_instant_verification, new Object[]{nextButtonText, "https://m.facebook.com/terms", "https://m.facebook.com/about/privacy/", "https://m.facebook.com/policies/cookies/", loginModel.getPrivacyPolicy(), loginModel.getTermsOfService(), AccountKit.getApplicationName(), ACCOUNT_KIT_URL})));
                } else {
                    termsTextView.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.com_accountkit_confirmation_code_agreement_app_privacy_policy_instant_verification, new Object[]{nextButtonText, "https://m.facebook.com/terms", "https://m.facebook.com/about/privacy/", "https://m.facebook.com/policies/cookies/", loginModel.getPrivacyPolicy(), AccountKit.getApplicationName(), ACCOUNT_KIT_URL})));
                }
            } else {
                termsTextView.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.com_accountkit_confirmation_code_agreement_instant_verification, new Object[]{nextButtonText, "https://m.facebook.com/terms", "https://m.facebook.com/about/privacy/", "https://m.facebook.com/policies/cookies/", ACCOUNT_KIT_URL})));
            }
        }
    }
}

