/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.facebook.accountkit.AccessToken;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.AccountKitException;
import com.facebook.accountkit.EmailLoginModel;
import com.facebook.accountkit.EmailLoginTracker;
import com.facebook.accountkit.LoginResult;
import com.facebook.accountkit.ui.AccountKitActivity;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.ActivityHandler;
import com.facebook.accountkit.ui.ContentController;
import com.facebook.accountkit.ui.EmailLoginContentController;
import com.facebook.accountkit.ui.EmailLoginFlowManager;
import com.facebook.accountkit.ui.EmailVerifyContentController;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.SendingCodeContentController;
import com.facebook.accountkit.ui.SentCodeContentController;
import com.facebook.accountkit.ui.StateStackManager;
import com.facebook.accountkit.ui.VerifyingCodeContentController;

final class ActivityEmailHandler
extends ActivityHandler {
    public static final Parcelable.Creator<ActivityEmailHandler> CREATOR = new Parcelable.Creator<ActivityEmailHandler>(){

        public ActivityEmailHandler createFromParcel(Parcel source) {
            return new ActivityEmailHandler(source);
        }

        public ActivityEmailHandler[] newArray(int size) {
            return new ActivityEmailHandler[size];
        }
    };

    public ActivityEmailHandler(@NonNull AccountKitConfiguration configuration) {
        super(configuration);
    }

    @Override
    public EmailLoginTracker getLoginTracker(final AccountKitActivity activity) {
        if (this.getEmailTracker() == null) {
            this.tracker = new EmailLoginTracker(){

                @Override
                protected void onStarted(EmailLoginModel loginModel) {
                    if (!(activity.getContentController() instanceof SendingCodeContentController)) {
                        return;
                    }
                    activity.pushState(LoginFlowState.SENT_CODE, null);
                }

                @Override
                protected void onAccountVerified(EmailLoginModel loginModel) {
                    ContentController contentController = activity.getContentController();
                    if (!(contentController instanceof SendingCodeContentController)) {
                        return;
                    }
                    activity.pushState(LoginFlowState.ACCOUNT_VERIFIED, null);
                }

                @Override
                protected void onSuccess(EmailLoginModel loginModel) {
                    ContentController contentController = activity.getContentController();
                    if (!(contentController instanceof EmailVerifyContentController) && !(contentController instanceof VerifyingCodeContentController)) {
                        return;
                    }
                    activity.pushState(LoginFlowState.VERIFIED, null);
                    activity.setFinalAuthState(loginModel.getFinalAuthState());
                    activity.setAccessToken(loginModel.getAccessToken());
                    activity.setAuthorizationCode(loginModel.getCode());
                    activity.setLoginResult(LoginResult.SUCCESS);
                    AccessToken accessToken = loginModel.getAccessToken();
                    if (accessToken != null) {
                        activity.setTokenRefreshIntervalInSeconds(accessToken.getTokenRefreshIntervalSeconds());
                    }
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            this.finishActivity();
                        }
                    }, 2000L);
                }

                @Override
                protected void onError(AccountKitException exception) {
                    activity.pushError(exception.getError());
                }

                @Override
                protected void onCancel(EmailLoginModel loginModel) {
                    activity.setNewLoginFlowManagerAndHandler(null);
                }

                private void finishActivity() {
                    activity.sendResult();
                }
            };
        }
        return this.getEmailTracker();
    }

    public void onEmailLoginComplete(AccountKitActivity activity, EmailLoginFlowManager emailManager, String email) {
        activity.pushState(LoginFlowState.SENDING_CODE, null);
        emailManager.setEmail(email);
        emailManager.logInWithEmail(this.configuration.getResponseType(), this.configuration.getInitialAuthState());
    }

    public void onEmailVerifyRetry(final AccountKitActivity activity) {
        AccountKit.cancelLogin();
        activity.popBackStack(LoginFlowState.EMAIL_INPUT, new StateStackManager.OnPopListener(){

            @Override
            public void onContentPopped() {
                ActivityEmailHandler.this.emailVerifySetRetry(activity);
            }
        });
    }

    private void emailVerifySetRetry(AccountKitActivity activity) {
        ContentController contentController = activity.getContentController();
        if (!(contentController instanceof EmailLoginContentController)) {
            return;
        }
        ((EmailLoginContentController)contentController).setRetry();
    }

    @Override
    public void onSentCodeComplete(AccountKitActivity activity) {
        if (!(activity.getContentController() instanceof SentCodeContentController)) {
            return;
        }
        activity.pushState(LoginFlowState.EMAIL_VERIFY, null);
    }

    @Override
    public void onAccountVerifiedComplete(AccountKitActivity accountKitActivity) {
        accountKitActivity.pushState(LoginFlowState.CONFIRM_ACCOUNT_VERIFIED, null);
    }

    protected ActivityEmailHandler(Parcel parcel) {
        super(parcel);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
    }

    private EmailLoginTracker getEmailTracker() {
        return (EmailLoginTracker)this.tracker;
    }
}

