/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.View;
import com.facebook.accountkit.AccessToken;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.AccountKitException;
import com.facebook.accountkit.AccountKitLoginResult;
import com.facebook.accountkit.LoginResult;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.Tracker;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.InternalAccountKitError;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.ui.AccountKitActivityBase;
import com.facebook.accountkit.ui.AccountKitLoginResultImpl;
import com.facebook.accountkit.ui.AccountVerifiedContentController;
import com.facebook.accountkit.ui.ActivityEmailHandler;
import com.facebook.accountkit.ui.ActivityErrorHandler;
import com.facebook.accountkit.ui.ActivityPhoneHandler;
import com.facebook.accountkit.ui.ConfirmAccountVerifiedContentController;
import com.facebook.accountkit.ui.ContentController;
import com.facebook.accountkit.ui.EmailLoginContentController;
import com.facebook.accountkit.ui.EmailLoginFlowManager;
import com.facebook.accountkit.ui.EmailVerifyContentController;
import com.facebook.accountkit.ui.LoginConfirmationCodeContentController;
import com.facebook.accountkit.ui.LoginErrorContentController;
import com.facebook.accountkit.ui.LoginFlowBroadcastReceiver;
import com.facebook.accountkit.ui.LoginFlowManager;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.LoginType;
import com.facebook.accountkit.ui.NotificationChannel;
import com.facebook.accountkit.ui.PhoneLoginContentController;
import com.facebook.accountkit.ui.PhoneLoginFlowManager;
import com.facebook.accountkit.ui.ResendContentController;
import com.facebook.accountkit.ui.SendingCodeContentController;
import com.facebook.accountkit.ui.SentCodeContentController;
import com.facebook.accountkit.ui.StateStackManager;
import com.facebook.accountkit.ui.VerifiedCodeContentController;
import com.facebook.accountkit.ui.VerifyingCodeContentController;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.common.api.GoogleApiClient;

public final class AccountKitActivity
extends AccountKitActivityBase {
    private static final String TAG = AccountKitActivity.class.getSimpleName();
    private GoogleApiClient mCredentialsApiClient;
    private static final String LOGIN_FLOW_MANAGER_KEY = TAG + ".loginFlowManager";
    private static final String PENDING_LOGIN_FLOW_STATE_KEY = TAG + ".pendingLoginFlowState";
    private static final String TRACKING_SMS_KEY = TAG + ".trackingSms";
    private static final IntentFilter LOGIN_FLOW_BROADCAST_RECEIVER_FILTER = LoginFlowBroadcastReceiver.getIntentFilter();
    private AccessToken accessToken;
    private String authorizationCode;
    private Tracker loginTracker;
    private AccountKitError error;
    private String finalAuthState;
    private boolean isActive;
    @Nullable
    private LoginFlowManager loginFlowManager;
    private LoginResult result = LoginResult.CANCELLED;
    private StateStackManager stateStackManager;
    private long tokenRefreshIntervalInSeconds;
    private final Bundle viewState = new Bundle();
    private final BroadcastReceiver loginFlowBroadcastReceiver = new LoginFlowBroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (!LoginFlowBroadcastReceiver.ACTION_UPDATE.contentEquals(action)) {
                return;
            }
            LoginFlowBroadcastReceiver.Event event = (LoginFlowBroadcastReceiver.Event)((Object)intent.getSerializableExtra(EXTRA_EVENT));
            ContentController contentController = AccountKitActivity.this.stateStackManager.getContentController();
            switch (event) {
                case SENT_CODE_COMPLETE: {
                    AccountKitActivity.this.loginFlowManager.getActivityHandler().onSentCodeComplete(AccountKitActivity.this);
                    break;
                }
                case ACCOUNT_VERIFIED_COMPLETE: {
                    AccountKitActivity.this.loginFlowManager.getActivityHandler().onAccountVerifiedComplete(AccountKitActivity.this);
                    break;
                }
                case CONFIRM_SEAMLESS_LOGIN: {
                    AccountKitActivity.this.loginFlowManager.getActivityHandler().onConfirmSeamlessLogin(AccountKitActivity.this, AccountKitActivity.this.loginFlowManager);
                    break;
                }
                case EMAIL_LOGIN_COMPLETE: {
                    if (!(contentController instanceof EmailLoginContentController)) break;
                    String email = intent.getStringExtra(EXTRA_EMAIL);
                    EmailLoginFlowManager manager = (EmailLoginFlowManager)AccountKitActivity.this.loginFlowManager;
                    ((ActivityEmailHandler)manager.getActivityHandler()).onEmailLoginComplete(AccountKitActivity.this, manager, email);
                    break;
                }
                case EMAIL_VERIFY_RETRY: {
                    if (!(contentController instanceof EmailVerifyContentController)) break;
                    ((ActivityEmailHandler)AccountKitActivity.this.loginFlowManager.getActivityHandler()).onEmailVerifyRetry(AccountKitActivity.this);
                    break;
                }
                case ERROR_RESTART: {
                    if (!(contentController instanceof LoginErrorContentController)) break;
                    LoginFlowState returnState = LoginFlowState.values()[intent.getIntExtra(EXTRA_RETURN_LOGIN_FLOW_STATE, 0)];
                    ActivityErrorHandler.onErrorRestart(AccountKitActivity.this, returnState);
                    break;
                }
                case PHONE_LOGIN_COMPLETE: {
                    if (!(contentController instanceof PhoneLoginContentController)) break;
                    PhoneNumber phoneNumber = (PhoneNumber)intent.getParcelableExtra(EXTRA_PHONE_NUMBER);
                    PhoneLoginFlowManager manager = (PhoneLoginFlowManager)AccountKitActivity.this.loginFlowManager;
                    NotificationChannel notificationChannel = (NotificationChannel)((Object)intent.getSerializableExtra(EXTRA_NOTIFICATION_CHANNEL));
                    ((ActivityPhoneHandler)manager.getActivityHandler()).onPhoneLoginComplete(AccountKitActivity.this, manager, phoneNumber, notificationChannel);
                    break;
                }
                case PHONE_CONFIRMATION_CODE_COMPLETE: {
                    if (!(contentController instanceof LoginConfirmationCodeContentController)) break;
                    String confirmationCode = intent.getStringExtra(EXTRA_CONFIRMATION_CODE);
                    PhoneLoginFlowManager manager = (PhoneLoginFlowManager)AccountKitActivity.this.loginFlowManager;
                    ((ActivityPhoneHandler)manager.getActivityHandler()).onConfirmationCodeComplete(AccountKitActivity.this, manager, confirmationCode);
                    break;
                }
                case PHONE_CONFIRMATION_CODE_RETRY: {
                    if (!(contentController instanceof LoginConfirmationCodeContentController)) break;
                    ((ActivityPhoneHandler)AccountKitActivity.this.loginFlowManager.getActivityHandler()).onConfirmationCodeRetry(AccountKitActivity.this);
                    break;
                }
                case PHONE_RESEND: {
                    if (!(contentController instanceof ResendContentController) && !(contentController instanceof LoginConfirmationCodeContentController)) break;
                    ((ActivityPhoneHandler)AccountKitActivity.this.loginFlowManager.getActivityHandler()).onResend(AccountKitActivity.this);
                    break;
                }
                case PHONE_RESEND_FACEBOOK_NOTIFICATION: {
                    if (!(contentController instanceof ResendContentController)) break;
                    PhoneLoginFlowManager manager = (PhoneLoginFlowManager)AccountKitActivity.this.loginFlowManager;
                    ((ActivityPhoneHandler)manager.getActivityHandler()).onResendFacebookNotification(AccountKitActivity.this, manager);
                    break;
                }
                case PHONE_RESEND_SWITCH: {
                    if (!(contentController instanceof ResendContentController)) break;
                    PhoneNumber phoneNumber = (PhoneNumber)intent.getParcelableExtra(EXTRA_PHONE_NUMBER);
                    PhoneLoginFlowManager manager = (PhoneLoginFlowManager)AccountKitActivity.this.loginFlowManager;
                    NotificationChannel notificationChannel = (NotificationChannel)((Object)intent.getSerializableExtra(EXTRA_NOTIFICATION_CHANNEL));
                    ((ActivityPhoneHandler)manager.getActivityHandler()).onResendSwitchLoginMethod(AccountKitActivity.this, manager, phoneNumber, notificationChannel);
                }
            }
        }
    };

    public GoogleApiClient getGoogleApiClient() {
        return this.mCredentialsApiClient;
    }

    @Nullable
    public LoginFlowState getCurrentState() {
        if (this.loginFlowManager != null) {
            return this.loginFlowManager.getFlowState();
        }
        return null;
    }

    private static boolean urlIsRedirectUrl(@NonNull String url) {
        return url.startsWith(Utility.getRedirectURL());
    }

    ContentController getContentController() {
        return this.stateStackManager.getContentController();
    }

    public void onBackPressed() {
        if (this.stateStackManager.getContentController() == null) {
            super.onBackPressed();
        } else {
            this.backPressed();
        }
    }

    public void onBackPressed(View view) {
        this.onBackPressed();
    }

    public void onCancelPressed(View view) {
        this.sendCancelResult();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        String url = intent.getDataString();
        if (url != null && !AccountKitActivity.urlIsRedirectUrl(url)) {
            this.sendResult();
            return;
        }
        if (this.configuration == null || this.configuration.getLoginType() == null) {
            this.error = new AccountKitError(AccountKitError.Type.INITIALIZATION_ERROR, InternalAccountKitError.INVALID_INTENT_EXTRAS_LOGIN_TYPE);
            this.sendResult();
            return;
        }
        if (this.configuration.getResponseType() == null) {
            this.error = new AccountKitError(AccountKitError.Type.INITIALIZATION_ERROR, InternalAccountKitError.INVALID_INTENT_EXTRAS_RESPONSE_TYPE);
            this.sendResult();
            return;
        }
        this.stateStackManager = new StateStackManager(this, this.configuration);
        AccountKit.onActivityCreate((Activity)this, savedInstanceState);
        this.onViewReadyWithState(this.viewState, savedInstanceState != null);
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.loginFlowBroadcastReceiver, LOGIN_FLOW_BROADCAST_RECEIVER_FILTER);
        this.mCredentialsApiClient = new GoogleApiClient.Builder((Context)this).addApi(Auth.CREDENTIALS_API).build();
    }

    protected void onStart() {
        super.onStart();
        this.mCredentialsApiClient.connect();
    }

    protected void onStop() {
        super.onStop();
        this.mCredentialsApiClient.disconnect();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ContentController contentController = this.getContentController();
        if (contentController != null) {
            contentController.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onPause() {
        super.onPause();
        ContentController contentController = this.getContentController();
        if (contentController != null) {
            contentController.onPause((Activity)this);
        }
        this.isActive = false;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        AccountKit.onActivitySaveInstanceState((Activity)this, outState);
        if (this.loginFlowManager.getLoginType() == LoginType.PHONE) {
            ActivityPhoneHandler phoneHandler = (ActivityPhoneHandler)this.loginFlowManager.getActivityHandler();
            this.viewState.putBoolean(TRACKING_SMS_KEY, phoneHandler.isSmsTracking());
            phoneHandler.pauseSmsTracker();
            this.viewState.putParcelable(LOGIN_FLOW_MANAGER_KEY, (Parcelable)this.loginFlowManager);
        }
        if (this.loginTracker != null) {
            this.loginTracker.pauseTracking();
        }
        super.onSaveInstanceState(outState);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        String url = intent.getDataString();
        if (url == null) {
            return;
        }
        if (!AccountKitActivity.urlIsRedirectUrl(url)) {
            this.sendResult();
            return;
        }
        if (this.getContentController() instanceof EmailVerifyContentController) {
            this.pushState(LoginFlowState.VERIFYING_CODE, null);
        }
    }

    private void onViewReadyWithState(Bundle viewState, boolean restored) {
        this.setNewLoginFlowManagerAndHandler((LoginFlowManager)viewState.getParcelable(LOGIN_FLOW_MANAGER_KEY));
        if (restored) {
            this.stateStackManager.updateContentController(this);
        } else {
            if (this.configuration == null) {
                return;
            }
            switch (this.configuration.getLoginType()) {
                case PHONE: {
                    this.pushState(LoginFlowState.PHONE_NUMBER_INPUT, null);
                    break;
                }
                case EMAIL: {
                    this.pushState(LoginFlowState.EMAIL_INPUT, null);
                    break;
                }
                default: {
                    this.error = new AccountKitError(AccountKitError.Type.INITIALIZATION_ERROR, InternalAccountKitError.INVALID_LOGIN_TYPE);
                    this.sendResult();
                }
            }
        }
    }

    protected void onResume() {
        String pending;
        super.onResume();
        ContentController contentController = this.getContentController();
        if (contentController != null) {
            contentController.onResume((Activity)this);
        }
        this.isActive = true;
        if (this.configuration == null) {
            return;
        }
        switch (this.configuration.getLoginType()) {
            case PHONE: 
            case EMAIL: {
                this.loginTracker = this.loginFlowManager.getActivityHandler().getLoginTracker(this);
                this.loginTracker.startTracking();
            }
        }
        if (this.loginFlowManager.getLoginType() == LoginType.PHONE && (this.loginFlowManager.getFlowState() == LoginFlowState.SENDING_CODE || this.viewState.getBoolean(TRACKING_SMS_KEY, false))) {
            ((ActivityPhoneHandler)this.loginFlowManager.getActivityHandler()).startSmsTrackerIfPossible(this);
        }
        if (!Utility.isNullOrEmpty(pending = this.viewState.getString(PENDING_LOGIN_FLOW_STATE_KEY))) {
            this.viewState.putString(PENDING_LOGIN_FLOW_STATE_KEY, null);
            LoginFlowState loginFlowState = LoginFlowState.valueOf(pending);
            this.pushState(loginFlowState, null);
        }
    }

    @Override
    protected void onDestroy() {
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.loginFlowBroadcastReceiver);
        super.onDestroy();
        if (this.loginTracker != null) {
            this.loginTracker.stopTracking();
            this.loginTracker = null;
        }
        if (this.loginFlowManager != null && this.loginFlowManager.getLoginType() == LoginType.PHONE) {
            ((ActivityPhoneHandler)this.loginFlowManager.getActivityHandler()).stopSmsTracker();
        }
        AccountKit.onActivityDestroy((Activity)this);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                this.backPressed();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    void sendCancelResult() {
        this.sendResult(0, new AccountKitLoginResultImpl(null, null, null, 0L, null, true));
    }

    @Override
    void sendResult() {
        int resultCode = this.result == LoginResult.SUCCESS ? -1 : 0;
        this.sendResult(resultCode, new AccountKitLoginResultImpl(this.accessToken, this.authorizationCode, this.finalAuthState, this.tokenRefreshIntervalInSeconds, this.error, false));
    }

    private void sendResult(int resultCode, AccountKitLoginResult loginResult) {
        if (this.getCallingActivity() == null) {
            PackageManager pm = this.getPackageManager();
            Intent intent = pm.getLaunchIntentForPackage(this.getPackageName());
            this.startActivity(intent);
            this.finish();
            return;
        }
        Intent data = new Intent();
        data.putExtra("account_kit_log_in_result", (Parcelable)loginResult);
        this.setResult(resultCode, data);
        this.finish();
    }

    void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    void setFinalAuthState(String finalAuthState) {
        this.finalAuthState = finalAuthState;
    }

    void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    void setTokenRefreshIntervalInSeconds(long tokenRefreshIntervalInSeconds) {
        this.tokenRefreshIntervalInSeconds = tokenRefreshIntervalInSeconds;
    }

    void setLoginResult(LoginResult result) {
        this.result = result;
    }

    private void backPressed() {
        ContentController contentController = this.stateStackManager.getContentController();
        if (contentController == null) {
            return;
        }
        if (contentController instanceof LoginConfirmationCodeContentController) {
            ((LoginConfirmationCodeContentController)contentController).setRetry(false);
        }
        this.onContentControllerDismissed(contentController);
        LoginFlowState fromState = contentController.getLoginFlowState();
        LoginFlowState toState = LoginFlowState.getBackState(fromState);
        switch (fromState) {
            case NONE: 
            case PHONE_NUMBER_INPUT: 
            case EMAIL_INPUT: {
                this.sendCancelResult();
                break;
            }
            case SENDING_CODE: 
            case SENT_CODE: 
            case CODE_INPUT: 
            case ACCOUNT_VERIFIED: 
            case CONFIRM_ACCOUNT_VERIFIED: 
            case CONFIRM_INSTANT_VERIFICATION_LOGIN: 
            case EMAIL_VERIFY: 
            case VERIFYING_CODE: 
            case RESEND: {
                this.resetFlowTo(fromState, toState);
                break;
            }
            case ERROR: {
                LoginFlowState returnState = ((LoginErrorContentController)contentController).getReturnState();
                this.resetFlowTo(fromState, returnState);
                break;
            }
            case VERIFIED: {
                this.sendResult();
                break;
            }
            default: {
                this.resetFlowTo(fromState, LoginFlowState.NONE);
            }
        }
    }

    private void resetFlowTo(LoginFlowState fromState, LoginFlowState toState) {
        this.loginFlowManager.setFlowState(toState);
        StateStackManager.OnPopListener onPopListener = new StateStackManager.OnPopListener(){

            @Override
            public void onContentPopped() {
                AccountKitActivity.this.getContentController().onResume((Activity)AccountKitActivity.this);
            }
        };
        if (fromState != LoginFlowState.RESEND) {
            this.setNewLoginFlowManagerAndHandler(null);
        }
        this.popBackStack(toState, onPopListener);
    }

    void setNewLoginFlowManagerAndHandler(LoginFlowManager restoredLoginFlowManager) {
        LoginFlowState existingState;
        LoginFlowState loginFlowState = existingState = this.loginFlowManager == null ? LoginFlowState.NONE : this.loginFlowManager.getFlowState();
        if (restoredLoginFlowManager == null && this.loginFlowManager != null) {
            this.loginFlowManager.cancel();
        }
        switch (this.configuration.getLoginType()) {
            case EMAIL: {
                this.loginFlowManager = new EmailLoginFlowManager(this.configuration);
                this.loginFlowManager.setFlowState(existingState);
                break;
            }
            case PHONE: {
                this.loginFlowManager = new PhoneLoginFlowManager(this.configuration);
                this.loginFlowManager.setFlowState(existingState);
            }
        }
    }

    void popBackStack(@NonNull LoginFlowState loginFlowState, @Nullable StateStackManager.OnPopListener onPopListener) {
        if (!this.isActive) {
            return;
        }
        this.stateStackManager.popBackStack(loginFlowState, onPopListener);
    }

    void multiPopBackStack(@Nullable StateStackManager.OnPopListener onPopListener) {
        if (!this.isActive) {
            return;
        }
        this.stateStackManager.multiPopBackStack(onPopListener);
    }

    void pushError(@Nullable AccountKitError error) {
        String userFacingError = error == null ? null : error.getUserFacingMessage();
        this.error = error;
        LoginFlowState returnState = LoginFlowState.getBackState(this.loginFlowManager.getFlowState());
        this.loginFlowManager.setFlowState(LoginFlowState.ERROR);
        this.stateStackManager.pushError(this, this.loginFlowManager, returnState, error, this.stateStackManager.getErrorOnPushListener(userFacingError));
    }

    void pushState(LoginFlowState loginFlowState, @Nullable StateStackManager.OnPushListener onPushListener) {
        if (this.isActive) {
            this.loginFlowManager.setFlowState(loginFlowState);
            if (onPushListener == null) {
                switch (loginFlowState) {
                    case CODE_INPUT: {
                        onPushListener = ((ActivityPhoneHandler)this.loginFlowManager.getActivityHandler()).getConfirmationCodePushListener(this);
                        break;
                    }
                    case ERROR: {
                        this.pushError(null);
                        return;
                    }
                }
            }
            this.stateStackManager.pushState(this, this.loginFlowManager, onPushListener);
        } else {
            this.viewState.putString(PENDING_LOGIN_FLOW_STATE_KEY, loginFlowState.name());
        }
        if (!loginFlowState.equals((Object)LoginFlowState.ERROR)) {
            this.error = null;
        }
    }

    void onContentControllerDismissed(ContentController contentController) {
        if (contentController != null) {
            contentController.onPause((Activity)this);
            this.logContentControllerDismissed(contentController);
        }
    }

    private void logContentControllerDismissed(ContentController contentController) {
        if (this.configuration == null) {
            return;
        }
        if (contentController instanceof PhoneLoginContentController) {
            AccountKitController.Logger.logUIPhoneLogin();
        } else if (contentController instanceof SendingCodeContentController) {
            AccountKitController.Logger.logUISendingCode(false, this.configuration.getLoginType());
        } else if (contentController instanceof SentCodeContentController) {
            AccountKitController.Logger.logUISentCode(false, this.configuration.getLoginType());
        } else if (contentController instanceof LoginConfirmationCodeContentController) {
            AccountKitController.Logger.logUIConfirmationCode();
        } else if (contentController instanceof VerifyingCodeContentController) {
            AccountKitController.Logger.logUIVerifyingCode(false, this.configuration.getLoginType());
        } else if (contentController instanceof VerifiedCodeContentController) {
            AccountKitController.Logger.logUIVerifiedCode(false, this.configuration.getLoginType());
        } else if (contentController instanceof LoginErrorContentController) {
            AccountKitController.Logger.logUIError(false, this.configuration.getLoginType());
        } else if (contentController instanceof EmailLoginContentController) {
            AccountKitController.Logger.logUIEmailLogin();
        } else if (contentController instanceof EmailVerifyContentController) {
            AccountKitController.Logger.logUIEmailVerify(false);
        } else if (contentController instanceof ResendContentController) {
            AccountKitController.Logger.logUIResend(false);
        } else if (contentController instanceof ConfirmAccountVerifiedContentController) {
            AccountKitController.Logger.logUIConfirmAccountVerified(false, this.configuration.getLoginType());
        } else if (contentController instanceof AccountVerifiedContentController) {
            AccountKitController.Logger.logUIAccountVerified(false, this.configuration.getLoginType());
        } else {
            throw new AccountKitException(AccountKitError.Type.INTERNAL_ERROR, InternalAccountKitError.UNEXPECTED_FRAGMENT, contentController.getClass().getName());
        }
    }

    public static enum ResponseType {
        CODE("code"),
        TOKEN("token");

        private final String value;

        private ResponseType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @Deprecated
    public static enum TitleType {
        APP_NAME,
        LOGIN;

    }
}

