/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.facebook.accountkit.PhoneLoginModel;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.internal.LoginModelImpl;
import com.facebook.accountkit.internal.LoginStatus;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.internal.Validate;
import com.facebook.accountkit.ui.NotificationChannel;
import java.util.HashMap;

public final class PhoneLoginModelImpl
extends LoginModelImpl
implements PhoneLoginModel {
    private String confirmationCode;
    private long resendTime;
    private PhoneNumber phoneNumber;
    @NonNull
    private final NotificationChannel notificationChannel;
    private boolean testSmsWithInfobip;
    public static final Parcelable.Creator<PhoneLoginModelImpl> CREATOR = new Parcelable.Creator<PhoneLoginModelImpl>(){

        public PhoneLoginModelImpl createFromParcel(Parcel source) {
            return new PhoneLoginModelImpl(source);
        }

        public PhoneLoginModelImpl[] newArray(int size) {
            return new PhoneLoginModelImpl[size];
        }
    };

    PhoneLoginModelImpl(PhoneNumber phoneNumber, @NonNull NotificationChannel notificationChannel, String requestType) {
        super(requestType);
        this.notificationChannel = notificationChannel;
        this.phoneNumber = phoneNumber;
    }

    void setConfirmationCode(@NonNull String confirmationCode) {
        Validate.isEquals((Object)this.getStatus(), (Object)LoginStatus.PENDING, "Phone status");
        Validate.sdkInitialized();
        this.confirmationCode = confirmationCode;
    }

    @Override
    public PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String getConfirmationCode() {
        return this.confirmationCode;
    }

    @Override
    public long getResendTime() {
        return this.resendTime;
    }

    @Override
    @NonNull
    public NotificationChannel getNotificationChannel() {
        return this.notificationChannel;
    }

    public boolean getTestSmsWithInfobip() {
        return this.testSmsWithInfobip;
    }

    public void setTestSmsWithInfobip(boolean testSmsWithInfobip) {
        this.testSmsWithInfobip = testSmsWithInfobip;
    }

    void setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    void setResendTime(long resendTime) {
        this.resendTime = resendTime;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PhoneLoginModelImpl)) {
            return false;
        }
        PhoneLoginModelImpl o = (PhoneLoginModelImpl)other;
        return super.equals(o) && Utility.areObjectsEqual(this.confirmationCode, o.confirmationCode) && Utility.areObjectsEqual(this.phoneNumber, o.phoneNumber) && this.notificationChannel == o.notificationChannel && this.resendTime == o.resendTime;
    }

    private PhoneLoginModelImpl(Parcel parcel) {
        super(parcel);
        this.phoneNumber = (PhoneNumber)parcel.readParcelable(PhoneNumber.class.getClassLoader());
        this.confirmationCode = parcel.readString();
        this.notificationChannel = NotificationChannel.values()[parcel.readInt()];
        this.fields = new HashMap();
        int size = parcel.readInt();
        for (int i = 0; i < size; ++i) {
            String key = parcel.readString();
            String value = parcel.readString();
            this.fields.put(key, value);
        }
        this.resendTime = parcel.readLong();
        this.testSmsWithInfobip = parcel.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.phoneNumber, flags);
        dest.writeString(this.confirmationCode);
        dest.writeInt(this.notificationChannel.ordinal());
        dest.writeInt(this.fields.size());
        for (String key : this.fields.keySet()) {
            dest.writeString(key);
            dest.writeString((String)this.fields.get(key));
        }
        dest.writeLong(this.resendTime);
        dest.writeByte((byte)(this.testSmsWithInfobip ? 1 : 0));
    }
}

