/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.Signature;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.Utility;
import java.util.HashSet;
import java.util.TreeSet;

abstract class NativeAppInfo {
    private static final String TAG = NativeAppInfo.class.getSimpleName();
    private static final String FBI_HASH = "a4b7452e2ed8f5f191058ca7bbfd26b0d3214bfc";
    private static final String FBL_HASH = "5e8f16062ea3cd2c4a0d547876baa6f38cabf625";
    private static final String FBL2_HASH = "df6b721c8b4d3b6eb44c861d4415007e5a35fc95";
    private static final String FBR_HASH = "8a3c4b262d721acd49a4bf97d5213199c86fa2b9";
    private static final String FBR2_HASH = "cc2751449a350f668590264ed76692694a80308a";
    private TreeSet<Integer> availableVersions;
    private boolean appInstalled;
    private static final HashSet<String> validAppSignatureHashes = NativeAppInfo.buildAppSignatureHashes();

    NativeAppInfo() {
    }

    protected abstract String getPackage();

    protected abstract Intent getPlatformServiceIntent();

    private static HashSet<String> buildAppSignatureHashes() {
        HashSet<String> set = new HashSet<String>();
        set.add(FBR_HASH);
        set.add(FBR2_HASH);
        set.add(FBI_HASH);
        set.add(FBL_HASH);
        set.add(FBL2_HASH);
        return set;
    }

    public boolean validateSignature(Context context, String packageName) {
        String brand = Build.BRAND;
        int applicationFlags = context.getApplicationInfo().flags;
        if (brand.startsWith("generic") && (applicationFlags & 2) != 0) {
            return true;
        }
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        if (packageInfo.signatures == null || packageInfo.signatures.length <= 0) {
            return false;
        }
        for (Signature signature : packageInfo.signatures) {
            String hashedSignature = Utility.sha1hash(signature.toByteArray());
            if (validAppSignatureHashes.contains(hashedSignature)) continue;
            return false;
        }
        return true;
    }

    public boolean isAppInstalled() {
        if (this.availableVersions == null) {
            this.fetchAvailableVersions(false);
        }
        return this.appInstalled;
    }

    public TreeSet<Integer> getAvailableVersions() {
        if (this.availableVersions == null) {
            this.fetchAvailableVersions(false);
        }
        return this.availableVersions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fetchAvailableVersions(boolean force) {
        TreeSet<Integer> allAvailableVersions;
        block11: {
            if (this.availableVersions != null && !force) {
                return;
            }
            allAvailableVersions = new TreeSet<Integer>();
            Context appContext = AccountKitController.getApplicationContext();
            ContentResolver contentResolver = appContext.getContentResolver();
            String[] projection = new String[]{"version"};
            Uri uri = Uri.parse((String)("content://" + this.getPackage() + ".provider.PlatformProvider/versions"));
            Cursor c = null;
            try {
                PackageManager pm = AccountKitController.getApplicationContext().getPackageManager();
                String contentProviderName = this.getPackage() + ".provider.PlatformProvider";
                ProviderInfo pInfo = null;
                try {
                    pInfo = pm.resolveContentProvider(contentProviderName, 0);
                }
                catch (RuntimeException e) {
                    Log.e((String)TAG, (String)"Failed to query content resolver.", (Throwable)e);
                }
                if (pInfo == null) break block11;
                try {
                    c = contentResolver.query(uri, projection, null, null, null);
                }
                catch (NullPointerException | SecurityException ex) {
                    Log.e((String)TAG, (String)"Failed to query content resolver.");
                    c = null;
                }
                if (c != null) {
                    while (c.moveToNext()) {
                        int version = c.getInt(c.getColumnIndex("version"));
                        allAvailableVersions.add(version);
                    }
                }
            }
            finally {
                if (c != null) {
                    this.appInstalled = true;
                    c.close();
                }
            }
        }
        this.availableVersions = allAvailableVersions;
    }
}

