/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.facebook.accountkit.AccessToken;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.LoginModel;
import com.facebook.accountkit.internal.AccessTokenManager;
import com.facebook.accountkit.internal.AccountKitGraphRequest;
import com.facebook.accountkit.internal.AccountKitGraphResponse;
import com.facebook.accountkit.internal.HttpMethod;
import com.facebook.accountkit.internal.InternalAccountKitError;
import com.facebook.accountkit.internal.LoginManager;
import com.facebook.accountkit.internal.LoginModelImpl;
import com.facebook.accountkit.internal.LoginStatus;
import com.facebook.accountkit.internal.Utility;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

abstract class LoginController<E extends LoginModelImpl> {
    private static final String TAG = LoginController.class.getName();
    static final String GRAPH_PATH_LOGIN_START = "start_login";
    static final String GRAPH_PATH_LOGIN_REQUEST_STATUS = "poll_login";
    static final String GRAPH_PATH_LOGIN_REQUEST_CONFIRM = "confirm_login";
    static final String GRAPH_PATH_SEAMLESS_REQUEST_CONFIRM = "instant_verification_login";
    private static final String PARAMETER_CREDENTIALS_TYPE = "credentials_type";
    static final String PARAMETER_ARGUMENT_FACEBOOK = "facebook";
    static final String PARAMETER_ARGUMENT_SMS = "sms";
    static final String PARAMETER_ARGUMENT_WHATSAPP = "whatsapp";
    static final String PARAMETER_ARGUMENT_INFOBIP = "infobip";
    static final String PARAMETER_FIELDS_TYPE = "fields";
    private static final String PARAMETER_LOGGING_REF = "logging_ref";
    private static final String PARAMETER_LOGIN_REQUEST_CODE = "login_request_code";
    static final String PARAMETER_REDIRECT_URI = "redirect_uri";
    static final String PARAMETER_STATE = "state";
    static final String PARAMETER_RESPONSE_TYPE = "response_type";
    static final String PARAMETER_FB_USER_TOKEN = "fb_user_token";
    final AccessTokenManager accessTokenManager;
    private final WeakReference<LoginManager> loginManagerRef;
    protected final E loginModel;

    LoginController(@NonNull AccessTokenManager accessTokenManager, @NonNull LoginManager loginManager, @NonNull E loginModel) {
        this.accessTokenManager = accessTokenManager;
        this.loginManagerRef = new WeakReference<LoginManager>(loginManager);
        this.loginModel = loginModel;
    }

    public E getLoginModel() {
        return this.loginModel;
    }

    public abstract void logIn(String var1);

    public abstract void onCancel();

    public void onError(AccountKitError error) {
        ((LoginModelImpl)this.loginModel).setError(error);
        ((LoginModelImpl)this.loginModel).setStatus(LoginStatus.ERROR);
        LoginManager loginManager = this.getLoginManager();
        if (loginManager == null) {
            return;
        }
        loginManager.cancel((LoginModel)this.loginModel);
    }

    public abstract void onPending();

    public abstract void onAccountVerified();

    void extractAccessTokenOrCodeIntoModel(JSONObject result) throws JSONException {
        if (Utility.areObjectsEqual(((LoginModelImpl)this.loginModel).getResponseType(), "token")) {
            String accessToken = result.getString("access_token");
            String id = result.getString("id");
            String tokenRefreshIntervalString = result.getString("token_refresh_interval_sec");
            long tokenRefreshIntervalInSeconds = Long.parseLong(tokenRefreshIntervalString);
            AccessToken token = new AccessToken(accessToken, id, AccountKit.getApplicationId(), tokenRefreshIntervalInSeconds, new Date());
            this.accessTokenManager.setCurrentAccessToken(token);
            String finalAuthState = result.optString(PARAMETER_STATE);
            ((LoginModelImpl)this.loginModel).setFinalAuthState(finalAuthState);
            ((LoginModelImpl)this.loginModel).setAccessToken(token);
            ((LoginModelImpl)this.loginModel).setStatus(LoginStatus.SUCCESS);
        } else {
            String code = result.getString("code");
            ((LoginModelImpl)this.loginModel).setCode(code);
            String finalAuthState = result.optString(PARAMETER_STATE);
            ((LoginModelImpl)this.loginModel).setFinalAuthState(finalAuthState);
            ((LoginModelImpl)this.loginModel).setStatus(LoginStatus.SUCCESS);
        }
    }

    AccountKitGraphRequest buildGraphRequest(String graphPath, Bundle extraParameters) {
        Bundle parameters = new Bundle();
        Utility.putNonNullString(parameters, PARAMETER_CREDENTIALS_TYPE, this.getCredentialsType());
        Utility.putNonNullString(parameters, PARAMETER_LOGIN_REQUEST_CODE, ((LoginModelImpl)this.loginModel).getLoginRequestCode());
        Utility.putNonNullString(parameters, PARAMETER_LOGGING_REF, this.getLoginManager() != null ? this.getLoginManager().getLogger().getLoggingRef() : null);
        parameters.putAll(extraParameters);
        return new AccountKitGraphRequest(null, graphPath, parameters, this.isLoginRequestPath(graphPath), HttpMethod.POST);
    }

    protected abstract String getCredentialsType();

    protected abstract String getLoginStateChangedIntentName();

    LoginManager getLoginManager() {
        LoginManager loginManager = (LoginManager)this.loginManagerRef.get();
        if (loginManager == null) {
            return null;
        }
        if (!loginManager.isActivityAvailable()) {
            Log.w((String)TAG, (String)"Warning: Callback issues while activity not available.");
            return null;
        }
        return loginManager;
    }

    protected void onError(AccountKitError.Type errorType, InternalAccountKitError internalError) {
        this.onError(new AccountKitError(errorType, internalError));
    }

    void broadcastLoginStateChange() {
        LoginManager loginManager = this.getLoginManager();
        if (loginManager == null) {
            return;
        }
        loginManager.getLocalBroadcastManager().sendBroadcast(new Intent(this.getLoginStateChangedIntentName()).putExtra("com.facebook.accountkit.sdk.EXTRA_LOGIN_MODEL", this.loginModel).putExtra("com.facebook.accountkit.sdk.EXTRA_LOGIN_STATUS", (Serializable)((Object)((LoginModelImpl)this.loginModel).getStatus())).putExtra("com.facebook.accountkit.sdk.EXTRA_LOGIN_ERROR", (Parcelable)((LoginModelImpl)this.loginModel).getError()));
    }

    private boolean isLoginRequestPath(String requestPath) {
        return Utility.areObjectsEqual(requestPath, GRAPH_PATH_LOGIN_START) || Utility.areObjectsEqual(requestPath, GRAPH_PATH_LOGIN_REQUEST_STATUS) || Utility.areObjectsEqual(requestPath, GRAPH_PATH_LOGIN_REQUEST_CONFIRM);
    }

    class AccountVerifedCallback
    implements AccountKitGraphRequest.Callback {
        final LoginManager loginManager;

        AccountVerifedCallback(LoginManager loginManager) {
            this.loginManager = loginManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted(AccountKitGraphResponse response) {
            if (!this.loginManager.isActivityAvailable()) {
                Log.w((String)TAG, (String)"Warning: Callback issues while activity not available.");
                return;
            }
            try {
                if (response.getError() != null) {
                    Pair<AccountKitError, InternalAccountKitError> error = Utility.createErrorFromServerError(response.getError());
                    LoginController.this.onError((AccountKitError)error.first);
                    return;
                }
                JSONObject result = response.getResponseObject();
                try {
                    LoginController.this.extractAccessTokenOrCodeIntoModel(result);
                }
                catch (JSONException e) {
                    LoginController.this.onError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.INVALID_GRAPH_RESULTS_FORMAT);
                }
            }
            finally {
                LoginController.this.broadcastLoginStateChange();
                this.loginManager.onLoginComplete((LoginModelImpl)LoginController.this.loginModel);
                if (((LoginModelImpl)LoginController.this.loginModel).getStatus() == LoginStatus.SUCCESS || ((LoginModelImpl)LoginController.this.loginModel).getStatus() == LoginStatus.ERROR) {
                    this.loginManager.clearLogIn();
                }
            }
        }
    }
}

