/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.AccountKitException;
import com.facebook.accountkit.internal.AccessTokenManager;
import com.facebook.accountkit.internal.AccountKitCookieStore;
import com.facebook.accountkit.internal.InternalAccountKitError;
import com.facebook.accountkit.internal.InternalLogger;
import com.facebook.accountkit.internal.LoginManager;
import com.facebook.accountkit.internal.NativeProtocol;
import com.facebook.accountkit.internal.UpdateManager;
import com.facebook.accountkit.internal.Validate;
import java.lang.reflect.Method;
import java.net.CookieManager;
import java.util.ArrayList;
import java.util.Locale;

public final class Initializer {
    private final ArrayList<AccountKit.InitializeCallback> callbacks = new ArrayList();
    private volatile Data data = null;
    private volatile State state = State.UNINITIALIZED;

    public synchronized void initialize(@NonNull Context context, AccountKit.InitializeCallback callback) throws AccountKitException {
        if (this.isInitialized()) {
            if (callback != null) {
                callback.onInitialized();
            }
            return;
        }
        if (callback != null) {
            this.callbacks.add(callback);
        }
        Validate.checkInternetPermissionAndThrow(context);
        Context applicationContext = context.getApplicationContext();
        Initializer.fixSamsungClipboardUIManagerMemoryLeak(applicationContext);
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = applicationContext.getPackageManager().getApplicationInfo(applicationContext.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (applicationInfo == null || applicationInfo.metaData == null) {
            this.state = State.FAILED;
            return;
        }
        Bundle metaData = applicationInfo.metaData;
        String applicationId = Initializer.getRequiredString(metaData, "com.facebook.sdk.ApplicationId", InternalAccountKitError.INVALID_APP_ID);
        String clientToken = Initializer.getRequiredString(metaData, "com.facebook.accountkit.ClientToken", InternalAccountKitError.INVALID_CLIENT_TOKEN);
        String applicationName = Initializer.getRequiredString(metaData, "com.facebook.accountkit.ApplicationName", InternalAccountKitError.INVALID_APP_NAME);
        boolean facebookAppEventsEnabled = metaData.getBoolean("com.facebook.accountkit.AccountKitFacebookAppEventsEnabled", true);
        String defaultLanguage = metaData.getString("com.facebook.accountkit.DefaultLanguage", "en-us");
        this.setDefaultLocale(context, defaultLanguage);
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)applicationContext);
        InternalLogger internalLogger = new InternalLogger(context.getApplicationContext(), applicationId, facebookAppEventsEnabled);
        AccessTokenManager accessTokenManager = new AccessTokenManager(applicationContext, localBroadcastManager);
        LoginManager loginManager = new LoginManager(internalLogger, accessTokenManager, localBroadcastManager);
        UpdateManager updateManager = new UpdateManager(internalLogger, localBroadcastManager);
        this.data = new Data(applicationContext, applicationId, applicationName, clientToken, accessTokenManager, localBroadcastManager, loginManager, updateManager);
        if (CookieManager.getDefault() == null) {
            CookieManager.setDefault(new CookieManager(new AccountKitCookieStore(context), null));
        }
        this.loadAccessToken();
        this.state = State.INITIALIZED;
        NativeProtocol.updateAllAvailableProtocolVersionsAsync();
    }

    AccessTokenManager getAccessTokenManager() {
        Validate.sdkInitialized();
        return this.data.accessTokenManager;
    }

    public Context getApplicationContext() {
        Validate.sdkInitialized();
        return this.data.applicationContext;
    }

    public String getApplicationId() {
        Validate.sdkInitialized();
        return this.data.applicationId;
    }

    String getApplicationName() {
        Validate.sdkInitialized();
        return this.data.applicationName;
    }

    String getClientToken() {
        Validate.sdkInitialized();
        return this.data.clientToken;
    }

    public InternalLogger getLogger() {
        Validate.sdkInitialized();
        return this.data.loginManager.getLogger();
    }

    LoginManager getLoginManager() {
        Validate.sdkInitialized();
        return this.data.loginManager;
    }

    UpdateManager getUpdateManager() {
        Validate.sdkInitialized();
        return this.data.updateManager;
    }

    public boolean isInitialized() {
        return this.state == State.INITIALIZED;
    }

    boolean getAccountKitFacebookAppEventsEnabled() {
        return this.getLogger().getFacebookAppEventsEnabled();
    }

    private synchronized void loadAccessToken() {
        if (!this.isInitialized()) {
            this.data.accessTokenManager.loadCurrentAccessToken();
            for (AccountKit.InitializeCallback callback : this.callbacks) {
                callback.onInitialized();
            }
            this.callbacks.clear();
        }
    }

    private static String getRequiredString(Bundle bundle, String key, InternalAccountKitError invalidValueError) throws AccountKitException {
        String value = bundle.getString(key);
        if (value == null) {
            throw new AccountKitException(AccountKitError.Type.INITIALIZATION_ERROR, invalidValueError);
        }
        return value;
    }

    private boolean isValidLocale(String localeIn) {
        Locale[] validLocales;
        for (Locale locale : validLocales = Locale.getAvailableLocales()) {
            if (!localeIn.equalsIgnoreCase(locale.toString())) continue;
            return true;
        }
        return false;
    }

    private void setDefaultLocale(Context context, String localeIn) {
        if (this.isValidLocale(localeIn)) {
            Locale locale = new Locale(localeIn);
            Configuration config = context.getResources().getConfiguration();
            config.locale = locale;
            context.getResources().updateConfiguration(config, null);
        }
    }

    private static void fixSamsungClipboardUIManagerMemoryLeak(Context applicationContext) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Class<?> cls = Class.forName("android.sec.clipboard.ClipboardUIManager");
                Method m = cls.getDeclaredMethod("getInstance", Context.class);
                m.setAccessible(true);
                m.invoke(null, applicationContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static enum State {
        UNINITIALIZED,
        INITIALIZED,
        FAILED;

    }

    private static final class Data {
        final AccessTokenManager accessTokenManager;
        final Context applicationContext;
        final String applicationId;
        final String applicationName;
        final String clientToken;
        final LocalBroadcastManager localBroadcastManager;
        final LoginManager loginManager;
        final UpdateManager updateManager;

        Data(Context applicationContext, String applicationId, String applicationName, String clientToken, AccessTokenManager accessTokenManager, LocalBroadcastManager localBroadcastManager, LoginManager loginManager, UpdateManager updateManager) {
            this.applicationContext = applicationContext;
            this.applicationId = applicationId;
            this.applicationName = applicationName;
            this.clientToken = clientToken;
            this.accessTokenManager = accessTokenManager;
            this.localBroadcastManager = localBroadcastManager;
            this.loginManager = loginManager;
            this.updateManager = updateManager;
        }
    }
}

