/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.AccountKitException;
import com.facebook.accountkit.LoggingBehavior;
import com.facebook.accountkit.internal.AccountKitGraphRequest;
import com.facebook.accountkit.internal.AccountKitRequestError;
import com.facebook.accountkit.internal.ConsoleLogger;
import com.facebook.accountkit.internal.InternalAccountKitError;
import com.facebook.accountkit.internal.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

final class AccountKitGraphResponse {
    private static final String TAG = "AccountKitGraphResponse";
    private static final IntegerRange HTTP_RANGE_SUCCESS = new IntegerRange(200, 299);
    private final HttpURLConnection connection;
    private final AccountKitRequestError error;
    private final String rawResponse;
    private final AccountKitGraphRequest request;
    private final JSONArray responseArray;
    private final JSONObject responseObject;

    public AccountKitGraphResponse(AccountKitGraphRequest request, HttpURLConnection connection, AccountKitRequestError error) {
        this(request, connection, null, null, null, error);
    }

    private AccountKitGraphResponse(AccountKitGraphRequest request, HttpURLConnection connection, String rawResponse, JSONObject responseObject, JSONArray responseArray, AccountKitRequestError error) {
        this.request = request;
        this.connection = connection;
        this.rawResponse = rawResponse;
        this.responseObject = responseObject;
        this.responseArray = responseArray;
        this.error = error;
    }

    public AccountKitRequestError getError() {
        return this.error;
    }

    public JSONObject getResponseObject() {
        return this.responseObject;
    }

    public JSONArray getResponseArray() {
        return this.responseArray;
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public AccountKitGraphRequest getRequest() {
        return this.request;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static AccountKitGraphResponse fromHttpConnection(HttpURLConnection connection, AccountKitGraphRequest request) {
        AccountKitGraphResponse accountKitGraphResponse;
        InputStream stream = null;
        try {
            stream = connection.getResponseCode() >= 400 ? connection.getErrorStream() : connection.getInputStream();
            accountKitGraphResponse = AccountKitGraphResponse.createResponseFromStream(stream, connection, request);
        }
        catch (AccountKitException exception) {
            ConsoleLogger.log(LoggingBehavior.REQUESTS, TAG, "Response <ERROR>: %s", exception);
            AccountKitGraphResponse accountKitGraphResponse2 = new AccountKitGraphResponse(request, connection, new AccountKitRequestError(exception));
            Utility.closeQuietly(stream);
            return accountKitGraphResponse2;
        }
        catch (IOException | SecurityException | JSONException exception2) {
            ConsoleLogger.log(LoggingBehavior.REQUESTS, TAG, "Response <ERROR>: %s", exception2);
            AccountKitGraphResponse accountKitGraphResponse3 = new AccountKitGraphResponse(request, connection, new AccountKitRequestError(new AccountKitException(AccountKitError.Type.SERVER_ERROR, exception2)));
            {
                catch (Throwable throwable) {
                    Utility.closeQuietly(stream);
                    throw throwable;
                }
            }
            Utility.closeQuietly(stream);
            return accountKitGraphResponse3;
        }
        Utility.closeQuietly(stream);
        return accountKitGraphResponse;
    }

    private static AccountKitGraphResponse createResponseFromStream(InputStream stream, HttpURLConnection connection, AccountKitGraphRequest request) throws AccountKitException, JSONException, IOException {
        String responseString = Utility.readStreamToString(stream);
        ConsoleLogger.log(LoggingBehavior.REQUESTS, TAG, "Response:\n%s\n", responseString);
        Object resultObject = new JSONTokener(responseString).nextValue();
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("body", resultObject);
            int responseCode = connection != null ? connection.getResponseCode() : 200;
            jsonObject.put("code", responseCode);
            resultObject = jsonObject;
        }
        catch (IOException | JSONException e) {
            return new AccountKitGraphResponse(request, connection, new AccountKitRequestError(new AccountKitException(AccountKitError.Type.INTERNAL_ERROR, InternalAccountKitError.INVALID_GRAPH_RESPONSE, e)));
        }
        return AccountKitGraphResponse.createResponseFromObject(request, connection, resultObject);
    }

    private static AccountKitRequestError checkResponseAndCreateError(JSONObject errorResult) {
        try {
            if (errorResult.has("code")) {
                int responseCode = errorResult.getInt("code");
                Object body = Utility.getStringPropertyAsJSON(errorResult, "body");
                if (body != null && body instanceof JSONObject) {
                    JSONObject jsonBody = (JSONObject)body;
                    String errorType = null;
                    String errorMessage = null;
                    String userErrorMessage = null;
                    int errorCode = -1;
                    int subErrorCode = -1;
                    boolean hasError = false;
                    if (jsonBody.has("error")) {
                        JSONObject error = (JSONObject)Utility.getStringPropertyAsJSON(jsonBody, "error");
                        errorType = error.optString("type", null);
                        errorMessage = error.optString("message", null);
                        userErrorMessage = error.optString("error_user_msg");
                        errorCode = error.optInt("code", -1);
                        subErrorCode = error.optInt("error_subcode", -1);
                        hasError = true;
                    } else if (jsonBody.has("error_code") || jsonBody.has("error_msg") || jsonBody.has("error_reason")) {
                        errorType = jsonBody.optString("error_reason", null);
                        errorMessage = jsonBody.optString("error_msg", null);
                        errorCode = jsonBody.optInt("error_code", -1);
                        hasError = true;
                    }
                    if (hasError) {
                        return new AccountKitRequestError(responseCode, errorCode, subErrorCode, errorType, errorMessage, userErrorMessage, null);
                    }
                }
                if (!HTTP_RANGE_SUCCESS.contains(responseCode)) {
                    return new AccountKitRequestError(responseCode, -1, -1, null, null, null, null);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    private static AccountKitGraphResponse createResponseFromObject(AccountKitGraphRequest request, HttpURLConnection connection, Object object) {
        try {
            if (object instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)object;
                AccountKitRequestError requestError = AccountKitGraphResponse.checkResponseAndCreateError(jsonObject);
                if (requestError != null) {
                    return new AccountKitGraphResponse(request, connection, requestError);
                }
                Object body = Utility.getStringPropertyAsJSON(jsonObject, "body");
                if (body instanceof JSONObject) {
                    return new AccountKitGraphResponse(request, connection, body.toString(), (JSONObject)body, null, null);
                }
                if (body instanceof JSONArray) {
                    return new AccountKitGraphResponse(request, connection, body.toString(), null, (JSONArray)body, null);
                }
                object = JSONObject.NULL;
            }
            if (object == JSONObject.NULL) {
                return new AccountKitGraphResponse(request, connection, object.toString(), null, null, null);
            }
            throw new AccountKitException(AccountKitError.Type.INTERNAL_ERROR, InternalAccountKitError.UNEXPECTED_OBJECT_TYPE_RESPONSE, object.getClass().getSimpleName());
        }
        catch (JSONException e) {
            return new AccountKitGraphResponse(request, connection, new AccountKitRequestError(new AccountKitException(AccountKitError.Type.INTERNAL_ERROR, InternalAccountKitError.INVALID_GRAPH_RESPONSE, e)));
        }
    }

    public String toString() {
        String responseCode;
        try {
            responseCode = String.format(Locale.US, "%d", this.connection != null ? this.connection.getResponseCode() : 200);
        }
        catch (IOException e) {
            responseCode = "unknown";
        }
        return "{Response:  responseCode: " + responseCode + ", responseObject: " + this.responseObject + ", error: " + this.error + "}";
    }

    private static final class IntegerRange {
        private final int end;
        private final int start;

        private IntegerRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean contains(int value) {
            return this.start <= value && value <= this.end;
        }
    }
}

