/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.graphics.Bitmap;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.Log;
import com.facebook.accountkit.AccessToken;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.AccountKitException;
import com.facebook.accountkit.LoggingBehavior;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.AccountKitGraphRequestAsyncTask;
import com.facebook.accountkit.internal.AccountKitGraphResponse;
import com.facebook.accountkit.internal.AccountKitRequestError;
import com.facebook.accountkit.internal.ConsoleLogger;
import com.facebook.accountkit.internal.HttpMethod;
import com.facebook.accountkit.internal.InternalAccountKitError;
import com.facebook.accountkit.internal.LocaleMapper;
import com.facebook.accountkit.internal.Utility;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.json.JSONException;
import org.json.JSONObject;

final class AccountKitGraphRequest {
    public static final String TAG = AccountKitGraphRequest.class.getSimpleName();
    private static final String ACCESS_TOKEN_PREFIX = "AA";
    private static final int DEFAULT_TIMEOUT_MILLISECONDS = 10000;
    private static final String GRAPH_API_VERSION = "v1.3";
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String ISO_8601_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String MIME_BOUNDARY;
    private static final String PARAMETER_ACCESS_TOKEN = "access_token";
    private static final String USER_AGENT_BASE = "AccountKitAndroidSDK";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final Pattern versionPattern;
    private static final int SOCKET_TAG = 61453;
    private AccessToken accessToken;
    private Handler callbackHandler;
    private final String graphPath;
    private HttpMethod httpMethod;
    private final boolean isLoginRequest;
    private Bundle parameters;
    private JSONObject requestObject;
    private Object tag;
    private String version;

    public AccountKitGraphRequest(AccessToken accessToken, String graphPath, Bundle parameters, boolean isLoginRequest, HttpMethod httpMethod) {
        this(accessToken, graphPath, parameters, isLoginRequest, httpMethod, null);
    }

    public AccountKitGraphRequest(AccessToken accessToken, String graphPath, Bundle parameters, boolean isLoginRequest, HttpMethod httpMethod, String version) {
        this.accessToken = accessToken;
        this.graphPath = graphPath;
        this.isLoginRequest = isLoginRequest;
        this.setHttpMethod(httpMethod);
        this.parameters = parameters != null ? new Bundle(parameters) : new Bundle();
        this.version = version == null ? GRAPH_API_VERSION : version;
    }

    boolean isLoginRequest() {
        return this.isLoginRequest;
    }

    JSONObject getRequestObject() {
        return this.requestObject;
    }

    void setRequestObject(JSONObject requestObject) {
        this.requestObject = requestObject;
    }

    String getGraphPath() {
        return this.graphPath;
    }

    HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Bundle getParameters() {
        return this.parameters;
    }

    public void setParameters(Bundle parameters) {
        this.parameters = parameters;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod != null ? httpMethod : HttpMethod.GET;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public Object getTag() {
        return this.tag;
    }

    AccountKitGraphResponse executeAndWait() {
        HttpURLConnection connection;
        try {
            TrafficStats.setThreadStatsTag((int)61453);
            connection = AccountKitGraphRequest.toHttpConnection(this);
        }
        catch (AccountKitException ex) {
            return new AccountKitGraphResponse(this, null, new AccountKitRequestError(ex));
        }
        catch (Exception ex) {
            return new AccountKitGraphResponse(this, null, new AccountKitRequestError(new AccountKitException(AccountKitError.Type.INTERNAL_ERROR, (Throwable)ex)));
        }
        AccountKitGraphResponse response = AccountKitGraphRequest.executeConnectionAndWait(connection, this);
        if (response == null) {
            throw new AccountKitException(AccountKitError.Type.INTERNAL_ERROR, InternalAccountKitError.INVALID_GRAPH_RESPONSE);
        }
        return response;
    }

    static AccountKitGraphResponse executeConnectionAndWait(HttpURLConnection connection, AccountKitGraphRequest request) {
        AccountKitGraphResponse response = AccountKitGraphResponse.fromHttpConnection(connection, request);
        Utility.disconnectQuietly(connection);
        return response;
    }

    public String toString() {
        return "{Request:  accessToken: " + (this.accessToken == null ? "null" : this.accessToken) + ", graphPath: " + this.graphPath + ", requestObject: " + this.requestObject + ", httpMethod: " + (Object)((Object)this.httpMethod) + ", parameters: " + this.parameters + "}";
    }

    private static HttpURLConnection createConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty(USER_AGENT_HEADER, LazyUserAgentHolder.userAgent);
        connection.setChunkedStreamingMode(0);
        return connection;
    }

    private void addCommonParameters() {
        Utility.putNonNullString(this.parameters, "locale", LocaleMapper.getSystemLocale());
        Utility.putNonNullString(this.parameters, "sdk", "android");
        this.parameters.putBoolean("fb_app_events_enabled", AccountKit.getAccountKitFacebookAppEventsEnabled());
        if (this.accessToken != null) {
            if (!this.parameters.containsKey(PARAMETER_ACCESS_TOKEN)) {
                String token = this.accessToken.getToken();
                this.parameters.putString(PARAMETER_ACCESS_TOKEN, token);
            }
        } else if (!this.parameters.containsKey(PARAMETER_ACCESS_TOKEN)) {
            String appID = AccountKit.getApplicationId();
            String clientToken = AccountKit.getClientToken();
            if (!Utility.isNullOrEmpty(appID) && !Utility.isNullOrEmpty(clientToken)) {
                String appAccessToken = "AA|" + appID + "|" + clientToken;
                this.parameters.putString(PARAMETER_ACCESS_TOKEN, appAccessToken);
            } else {
                Log.d((String)TAG, (String)"Warning: Request without access token missing application ID or client token.");
            }
        }
    }

    private String getUrlForSingleRequest() {
        Uri.Builder builder = new Uri.Builder().scheme("https").authority(AccountKitController.getBaseGraphHost());
        Matcher matcher = versionPattern.matcher(this.graphPath);
        if (!matcher.matches()) {
            builder.appendPath(this.version);
        }
        builder.appendPath(this.graphPath);
        this.addCommonParameters();
        if (this.httpMethod != HttpMethod.POST) {
            this.appendQueryParametersToUri(builder);
        }
        return builder.toString();
    }

    private void appendQueryParametersToUri(Uri.Builder uriBuilder) {
        ArrayList keys = new ArrayList(this.parameters.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Object value = this.parameters.get(key);
            if (value == null) {
                value = "";
            }
            uriBuilder.appendQueryParameter(key, AccountKitGraphRequest.parameterToString(value));
        }
    }

    private static void setConnectionContentType(HttpURLConnection connection, boolean isMultipart) {
        if (isMultipart) {
            connection.setRequestProperty(HEADER_CONTENT_TYPE, AccountKitGraphRequest.getMimeContentType());
        } else {
            connection.setRequestProperty(HEADER_CONTENT_TYPE, "application/x-www-form-urlencoded");
            connection.setRequestProperty(HEADER_CONTENT_ENCODING, "gzip");
        }
    }

    private static void serializeParameters(Bundle bundle, Serializer serializer) throws IOException {
        Set keys = bundle.keySet();
        for (String key : keys) {
            Object value = bundle.get(key);
            serializer.writeObject(key, value);
        }
    }

    private static String getMimeContentType() {
        return String.format("multipart/form-data; boundary=%s", MIME_BOUNDARY);
    }

    private static boolean isSupportedParameterType(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Number || value instanceof Date;
    }

    private static String parameterToString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean || value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Date) {
            SimpleDateFormat iso8601DateFormat = new SimpleDateFormat(ISO_8601_FORMAT_STRING, Locale.US);
            return iso8601DateFormat.format(value);
        }
        throw new IllegalArgumentException("Unsupported parameter type.");
    }

    static HttpURLConnection toHttpConnection(AccountKitGraphRequest request) {
        HttpURLConnection connection;
        URL url;
        try {
            String s = request.getUrlForSingleRequest();
            url = new URL(s);
        }
        catch (MalformedURLException e) {
            throw new AccountKitException(AccountKitError.Type.INTERNAL_ERROR, InternalAccountKitError.CANNOT_CONSTRUCT_URL, e);
        }
        try {
            connection = AccountKitGraphRequest.createConnection(url);
            AccountKitGraphRequest.serializeToUrlConnection(request, connection);
        }
        catch (UnknownHostException e) {
            throw new AccountKitException(AccountKitError.Type.NETWORK_CONNECTION_ERROR, InternalAccountKitError.NO_NETWORK_CONNECTION);
        }
        catch (IOException | JSONException e) {
            throw new AccountKitException(AccountKitError.Type.INTERNAL_ERROR, InternalAccountKitError.CANNOT_CONSTRUCT_MESSAGE_BODY, e);
        }
        return connection;
    }

    static AccountKitGraphRequestAsyncTask executeAsync(@NonNull AccountKitGraphRequest request, Callback callback) {
        AccountKitGraphRequestAsyncTask asyncTask = new AccountKitGraphRequestAsyncTask(request, callback);
        asyncTask.executeOnExecutor(Utility.getThreadPoolExecutor(), new Void[0]);
        return asyncTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializeToUrlConnection(AccountKitGraphRequest request, HttpURLConnection connection) throws IOException, JSONException {
        ConsoleLogger consoleLogger = new ConsoleLogger(LoggingBehavior.REQUESTS, "Request");
        HttpMethod connectionHttpMethod = request.httpMethod;
        connection.setRequestMethod(connectionHttpMethod.name());
        boolean isMultipart = AccountKitGraphRequest.isMultiPart(request.parameters);
        AccountKitGraphRequest.setConnectionContentType(connection, isMultipart);
        URL url = connection.getURL();
        consoleLogger.appendLine("Request:");
        consoleLogger.appendKeyValue("AccessToken", request.getAccessToken());
        consoleLogger.appendKeyValue("URL", url);
        consoleLogger.appendKeyValue("Method", connection.getRequestMethod());
        consoleLogger.appendKeyValue(USER_AGENT_HEADER, connection.getRequestProperty(USER_AGENT_HEADER));
        consoleLogger.appendKeyValue(HEADER_CONTENT_TYPE, connection.getRequestProperty(HEADER_CONTENT_TYPE));
        consoleLogger.log();
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        if (connectionHttpMethod != HttpMethod.POST) {
            return;
        }
        connection.setDoOutput(true);
        try (OutputStream outputStream = null;){
            outputStream = connection.getOutputStream();
            outputStream = new BufferedOutputStream(outputStream);
            if (!isMultipart) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            AccountKitGraphRequest.processRequest(request, outputStream, isMultipart);
        }
    }

    private static boolean isMultiPart(Bundle parameters) {
        for (String key : parameters.keySet()) {
            Object value = parameters.get(key);
            if (!AccountKitGraphRequest.isMultipartType(value)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMultipartType(Object value) {
        return value instanceof Bitmap || value instanceof byte[] || value instanceof Uri || value instanceof ParcelFileDescriptor || value instanceof ParcelableResourceWithMimeType;
    }

    private static void processRequest(AccountKitGraphRequest request, OutputStream outputStream, boolean isMultipart) throws IOException {
        Serializer serializer = new Serializer(outputStream, !isMultipart);
        AccountKitGraphRequest.serializeParameters(request.parameters, serializer);
        if (request.requestObject != null) {
            AccountKitGraphRequest.processRequestObject(request.requestObject, serializer);
        }
    }

    Handler getCallbackHandler() {
        return this.callbackHandler;
    }

    void setCallbackHandler(Handler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    private static void processRequestObject(JSONObject requestObject, KeyValueSerializer serializer) throws IOException {
        Iterator keyIterator = requestObject.keys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Object value = requestObject.opt(key);
            AccountKitGraphRequest.processRequestObjectProperty(key, value, serializer);
        }
    }

    private static void processRequestObjectProperty(String key, Object value, KeyValueSerializer serializer) throws IOException {
        Class<?> valueClass = value.getClass();
        if (String.class.isAssignableFrom(valueClass) || Number.class.isAssignableFrom(valueClass) || Boolean.class.isAssignableFrom(valueClass)) {
            serializer.writeString(key, value.toString());
        } else if (Date.class.isAssignableFrom(valueClass)) {
            Date date = (Date)value;
            SimpleDateFormat iso8601DateFormat = new SimpleDateFormat(ISO_8601_FORMAT_STRING, Locale.US);
            serializer.writeString(key, iso8601DateFormat.format(date));
        }
    }

    static {
        versionPattern = Pattern.compile("^/?v\\d+\\.\\d+/(.*)");
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        MIME_BOUNDARY = new BigInteger(1, bytes).toString(16);
    }

    private static class ParcelableResourceWithMimeType<RESOURCE extends Parcelable>
    implements Parcelable {
        private final String mimeType;
        private final RESOURCE resource;
        public static final Parcelable.Creator<ParcelableResourceWithMimeType> CREATOR = new Parcelable.Creator<ParcelableResourceWithMimeType>(){

            public ParcelableResourceWithMimeType createFromParcel(Parcel in) {
                return new ParcelableResourceWithMimeType(in);
            }

            public ParcelableResourceWithMimeType[] newArray(int size) {
                return new ParcelableResourceWithMimeType[size];
            }
        };

        String getMimeType() {
            return this.mimeType;
        }

        public RESOURCE getResource() {
            return this.resource;
        }

        public int describeContents() {
            return 1;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.mimeType);
            out.writeParcelable(this.resource, flags);
        }

        private ParcelableResourceWithMimeType(Parcel in) {
            this.mimeType = in.readString();
            this.resource = in.readParcelable(AccountKitController.getApplicationContext().getClassLoader());
        }
    }

    public static interface Callback {
        public void onCompleted(AccountKitGraphResponse var1);
    }

    private static class Serializer
    implements KeyValueSerializer {
        private boolean firstWrite = true;
        private final OutputStream outputStream;
        private boolean useUrlEncode = false;

        Serializer(OutputStream outputStream, boolean useUrlEncode) {
            this.outputStream = outputStream;
            this.useUrlEncode = useUrlEncode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void writeObject(String key, Object value) throws IOException {
            if (AccountKitGraphRequest.isSupportedParameterType(value)) {
                this.writeString(key, AccountKitGraphRequest.parameterToString(value));
                return;
            } else if (value instanceof Bitmap) {
                this.writeBitmap(key, (Bitmap)value);
                return;
            } else if (value instanceof byte[]) {
                this.writeBytes(key, (byte[])value);
                return;
            } else if (value instanceof Uri) {
                this.writeContentUri(key, (Uri)value, null);
                return;
            } else if (value instanceof ParcelFileDescriptor) {
                this.writeFile(key, (ParcelFileDescriptor)value, null);
                return;
            } else {
                if (!(value instanceof ParcelableResourceWithMimeType)) throw this.getInvalidTypeError();
                ParcelableResourceWithMimeType resourceWithMimeType = (ParcelableResourceWithMimeType)value;
                Object resource = resourceWithMimeType.getResource();
                String mimeType = resourceWithMimeType.getMimeType();
                if (resource instanceof ParcelFileDescriptor) {
                    this.writeFile(key, (ParcelFileDescriptor)resource, mimeType);
                    return;
                } else {
                    if (!(resource instanceof Uri)) throw this.getInvalidTypeError();
                    this.writeContentUri(key, (Uri)resource, mimeType);
                }
            }
        }

        private RuntimeException getInvalidTypeError() {
            return new IllegalArgumentException("value is not a supported type.");
        }

        @Override
        public void writeString(String key, String value) throws IOException {
            this.writeContentDisposition(key, null, null);
            this.writeLine("%s", value);
            this.writeRecordBoundary();
        }

        void writeBitmap(String key, Bitmap bitmap) throws IOException {
            this.writeContentDisposition(key, key, "image/png");
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, this.outputStream);
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
        }

        void writeBytes(String key, byte[] bytes) throws IOException {
            this.writeContentDisposition(key, key, "content/unknown");
            this.outputStream.write(bytes);
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
        }

        void writeContentUri(String key, Uri contentUri, String mimeType) throws IOException {
            if (mimeType == null) {
                mimeType = "content/unknown";
            }
            this.writeContentDisposition(key, key, mimeType);
            InputStream inputStream = AccountKitController.getApplicationContext().getContentResolver().openInputStream(contentUri);
            Utility.copyAndCloseInputStream(inputStream, this.outputStream);
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
        }

        void writeFile(String key, ParcelFileDescriptor descriptor, String mimeType) throws IOException {
            if (mimeType == null) {
                mimeType = "content/unknown";
            }
            this.writeContentDisposition(key, key, mimeType);
            ParcelFileDescriptor.AutoCloseInputStream inputStream = new ParcelFileDescriptor.AutoCloseInputStream(descriptor);
            Utility.copyAndCloseInputStream((InputStream)inputStream, this.outputStream);
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
        }

        void writeRecordBoundary() throws IOException {
            if (!this.useUrlEncode) {
                this.writeLine("--%s", MIME_BOUNDARY);
            } else {
                this.outputStream.write("&".getBytes());
            }
        }

        void writeContentDisposition(String name, String filename, String contentType) throws IOException {
            if (!this.useUrlEncode) {
                this.write("Content-Disposition: form-data; name=\"%s\"", name);
                if (filename != null) {
                    this.write("; filename=\"%s\"", filename);
                }
                this.writeLine("", new Object[0]);
                if (contentType != null) {
                    this.writeLine("%s: %s", AccountKitGraphRequest.HEADER_CONTENT_TYPE, contentType);
                }
                this.writeLine("", new Object[0]);
            } else {
                this.outputStream.write(String.format("%s=", name).getBytes());
            }
        }

        void write(String format, Object ... args) throws IOException {
            if (!this.useUrlEncode) {
                if (this.firstWrite) {
                    this.outputStream.write("--".getBytes());
                    this.outputStream.write(MIME_BOUNDARY.getBytes());
                    this.outputStream.write("\r\n".getBytes());
                    this.firstWrite = false;
                }
                this.outputStream.write(String.format(format, args).getBytes());
            } else {
                this.outputStream.write(URLEncoder.encode(String.format(Locale.US, format, args), "UTF-8").getBytes());
            }
        }

        void writeLine(String format, Object ... args) throws IOException {
            this.write(format, args);
            if (!this.useUrlEncode) {
                this.write("\r\n", new Object[0]);
            }
        }
    }

    private static interface KeyValueSerializer {
        public void writeString(String var1, String var2) throws IOException;
    }

    private static class LazyUserAgentHolder {
        static final String userAgent = LazyUserAgentHolder.buildUserAgent();

        private LazyUserAgentHolder() {
        }

        private static String buildUserAgent() {
            String systemUserAgent = System.getProperty("http.agent");
            if (systemUserAgent == null) {
                systemUserAgent = "";
            }
            return systemUserAgent + " " + AccountKitGraphRequest.USER_AGENT_BASE + "/" + "5.4.0";
        }
    }
}

