/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.facebook.accountkit.AccessToken;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.AccountKitException;
import com.facebook.accountkit.internal.InternalAccountKitError;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

final class AccessTokenCache {
    private static final String ACCESS_TOKEN_ACCOUNT_ID_KEY = "account_id";
    private static final String ACCESS_TOKEN_APPLICATION_ID_KEY = "application_id";
    private static final String ACCESS_TOKEN_LAST_REFRESH_KEY = "last_refresh";
    private static final String ACCESS_TOKEN_REFRESH_INTERVAL_KEY = "tokenRefreshIntervalInSeconds";
    private static final String ACCESS_TOKEN_TOKEN_KEY = "token";
    private static final String ACCESS_TOKEN_VERSION_KEY = "version";
    private static final int ACCESS_TOKEN_VERSION_VALUE = 1;
    static final String CACHED_ACCESS_TOKEN_KEY = "com.facebook.accountkit.AccessTokenManager.CachedAccessToken";
    private final SharedPreferences sharedPreferences;

    @VisibleForTesting
    AccessTokenCache(SharedPreferences sharedPreferences) {
        this.sharedPreferences = sharedPreferences;
    }

    AccessTokenCache(Context applicationContext) {
        this(applicationContext.getSharedPreferences("com.facebook.accountkit.AccessTokenManager.SharedPreferences", 0));
    }

    public void clear() {
        this.sharedPreferences.edit().remove(CACHED_ACCESS_TOKEN_KEY).apply();
    }

    public AccessToken load() {
        String jsonString = this.sharedPreferences.getString(CACHED_ACCESS_TOKEN_KEY, null);
        if (jsonString != null) {
            try {
                return AccessTokenCache.deserializeAccessToken(new JSONObject(jsonString));
            }
            catch (JSONException e) {
                return null;
            }
        }
        return null;
    }

    public void save(@NonNull AccessToken accessToken) {
        try {
            JSONObject jsonObject = AccessTokenCache.serializeAccessToken(accessToken);
            this.sharedPreferences.edit().putString(CACHED_ACCESS_TOKEN_KEY, jsonObject.toString()).apply();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    static AccessToken deserializeAccessToken(JSONObject jsonObject) throws JSONException {
        if (jsonObject.getInt(ACCESS_TOKEN_VERSION_KEY) > 1) {
            throw new AccountKitException(AccountKitError.Type.INTERNAL_ERROR, InternalAccountKitError.INVALID_ACCESS_TOKEN_FORMAT);
        }
        return new AccessToken(jsonObject.getString(ACCESS_TOKEN_TOKEN_KEY), jsonObject.getString(ACCESS_TOKEN_ACCOUNT_ID_KEY), jsonObject.getString(ACCESS_TOKEN_APPLICATION_ID_KEY), jsonObject.getLong(ACCESS_TOKEN_REFRESH_INTERVAL_KEY), new Date(jsonObject.getLong(ACCESS_TOKEN_LAST_REFRESH_KEY)));
    }

    @VisibleForTesting
    static JSONObject serializeAccessToken(AccessToken accessToken) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(ACCESS_TOKEN_VERSION_KEY, 1);
        jsonObject.put(ACCESS_TOKEN_ACCOUNT_ID_KEY, (Object)accessToken.getAccountId());
        jsonObject.put(ACCESS_TOKEN_APPLICATION_ID_KEY, (Object)accessToken.getApplicationId());
        jsonObject.put(ACCESS_TOKEN_REFRESH_INTERVAL_KEY, accessToken.getTokenRefreshIntervalSeconds());
        jsonObject.put(ACCESS_TOKEN_LAST_REFRESH_KEY, accessToken.getLastRefresh().getTime());
        jsonObject.put(ACCESS_TOKEN_TOKEN_KEY, (Object)accessToken.getToken());
        return jsonObject;
    }
}

