/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.facebook.accountkit.internal.Utility;

public final class PhoneNumber
implements Parcelable {
    private final String phoneNumber;
    private final String countryCode;
    private final String countryCodeIso;
    public static final Parcelable.Creator<PhoneNumber> CREATOR = new Parcelable.Creator<PhoneNumber>(){

        public PhoneNumber createFromParcel(Parcel source) {
            return new PhoneNumber(source);
        }

        public PhoneNumber[] newArray(int size) {
            return new PhoneNumber[size];
        }
    };

    public PhoneNumber(@NonNull String countryCode, @NonNull String phoneNumber, @Nullable String countryCodeIso) {
        this.phoneNumber = Utility.cleanPhoneNumberString(phoneNumber);
        this.countryCode = Utility.cleanPhoneNumberString(countryCode);
        this.countryCodeIso = countryCodeIso;
    }

    @Deprecated
    public PhoneNumber(String countryCode, String phoneNumber) {
        this(countryCode, phoneNumber, null);
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCountryCodeIso() {
        return this.countryCodeIso;
    }

    public String getRawPhoneNumber() {
        return this.countryCode + this.phoneNumber;
    }

    public String toString() {
        return "+" + this.countryCode + this.phoneNumber;
    }

    public String toRtlSafeString() {
        return "\u202a+" + this.countryCode + this.phoneNumber + "\u202c";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof PhoneNumber && this.hashCode() == other.hashCode();
    }

    private PhoneNumber(Parcel parcel) {
        this.countryCode = parcel.readString();
        this.phoneNumber = parcel.readString();
        this.countryCodeIso = parcel.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.countryCode);
        dest.writeString(this.phoneNumber);
        dest.writeString(this.countryCodeIso);
    }
}

