/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.RoasCohortsPerCohortIntervalUnit;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoasCohortsData
extends APINode {
    @SerializedName(value="cohorts_end")
    private String mCohortsEnd = null;
    @SerializedName(value="cohorts_start")
    private String mCohortsStart = null;
    @SerializedName(value="installs")
    private Long mInstalls = null;
    @SerializedName(value="revenue_cohorts")
    private List<RoasCohortsPerCohortIntervalUnit> mRevenueCohorts = null;
    @SerializedName(value="spend")
    private Double mSpend = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static RoasCohortsData loadJSON(String json, APIContext context) {
        RoasCohortsData roasCohortsData = (RoasCohortsData)RoasCohortsData.getGson().fromJson(json, RoasCohortsData.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(roasCohortsData.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        roasCohortsData.context = context;
        roasCohortsData.rawValue = json;
        return roasCohortsData;
    }

    public static APINodeList<RoasCohortsData> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<RoasCohortsData> roasCohortsDatas = new APINodeList<RoasCohortsData>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        roasCohortsDatas.add(RoasCohortsData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return roasCohortsDatas;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        roasCohortsDatas.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            roasCohortsDatas.add(RoasCohortsData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                roasCohortsDatas.add(RoasCohortsData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            roasCohortsDatas.add(RoasCohortsData.loadJSON(obj.toString(), context));
                        }
                    }
                    return roasCohortsDatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        roasCohortsDatas.add(RoasCohortsData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return roasCohortsDatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        roasCohortsDatas.add(RoasCohortsData.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return roasCohortsDatas;
                }
                roasCohortsDatas.clear();
                roasCohortsDatas.add(RoasCohortsData.loadJSON(json, context));
                return roasCohortsDatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return RoasCohortsData.getGson().toJson((Object)this);
    }

    public String getFieldCohortsEnd() {
        return this.mCohortsEnd;
    }

    public RoasCohortsData setFieldCohortsEnd(String value) {
        this.mCohortsEnd = value;
        return this;
    }

    public String getFieldCohortsStart() {
        return this.mCohortsStart;
    }

    public RoasCohortsData setFieldCohortsStart(String value) {
        this.mCohortsStart = value;
        return this;
    }

    public Long getFieldInstalls() {
        return this.mInstalls;
    }

    public RoasCohortsData setFieldInstalls(Long value) {
        this.mInstalls = value;
        return this;
    }

    public List<RoasCohortsPerCohortIntervalUnit> getFieldRevenueCohorts() {
        return this.mRevenueCohorts;
    }

    public RoasCohortsData setFieldRevenueCohorts(List<RoasCohortsPerCohortIntervalUnit> value) {
        this.mRevenueCohorts = value;
        return this;
    }

    public RoasCohortsData setFieldRevenueCohorts(String value) {
        Type type = new TypeToken<List<RoasCohortsPerCohortIntervalUnit>>(){}.getType();
        this.mRevenueCohorts = (List)RoasCohortsPerCohortIntervalUnit.getGson().fromJson(value, type);
        return this;
    }

    public Double getFieldSpend() {
        return this.mSpend;
    }

    public RoasCohortsData setFieldSpend(Double value) {
        this.mSpend = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public RoasCohortsData copyFrom(RoasCohortsData instance) {
        this.mCohortsEnd = instance.mCohortsEnd;
        this.mCohortsStart = instance.mCohortsStart;
        this.mInstalls = instance.mInstalls;
        this.mRevenueCohorts = instance.mRevenueCohorts;
        this.mSpend = instance.mSpend;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<RoasCohortsData> getParser() {
        return new APIRequest.ResponseParser<RoasCohortsData>(){

            @Override
            public APINodeList<RoasCohortsData> parseResponse(String response, APIContext context, APIRequest<RoasCohortsData> request) throws APIException.MalformedResponseException {
                return RoasCohortsData.parseResponse(response, context, request);
            }
        };
    }
}

