/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgencyClientDeclaration
extends APINode {
    @SerializedName(value="agency_representing_client")
    private Long mAgencyRepresentingClient = null;
    @SerializedName(value="client_based_in_france")
    private Long mClientBasedInFrance = null;
    @SerializedName(value="client_city")
    private String mClientCity = null;
    @SerializedName(value="client_country_code")
    private String mClientCountryCode = null;
    @SerializedName(value="client_email_address")
    private String mClientEmailAddress = null;
    @SerializedName(value="client_name")
    private String mClientName = null;
    @SerializedName(value="client_postal_code")
    private String mClientPostalCode = null;
    @SerializedName(value="client_province")
    private String mClientProvince = null;
    @SerializedName(value="client_street")
    private String mClientStreet = null;
    @SerializedName(value="client_street2")
    private String mClientStreet2 = null;
    @SerializedName(value="has_written_mandate_from_advertiser")
    private Long mHasWrittenMandateFromAdvertiser = null;
    @SerializedName(value="is_client_paying_invoices")
    private Long mIsClientPayingInvoices = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AgencyClientDeclaration loadJSON(String json, APIContext context) {
        AgencyClientDeclaration agencyClientDeclaration = (AgencyClientDeclaration)AgencyClientDeclaration.getGson().fromJson(json, AgencyClientDeclaration.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(agencyClientDeclaration.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        agencyClientDeclaration.context = context;
        agencyClientDeclaration.rawValue = json;
        return agencyClientDeclaration;
    }

    public static APINodeList<AgencyClientDeclaration> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<AgencyClientDeclaration> agencyClientDeclarations = new APINodeList<AgencyClientDeclaration>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return agencyClientDeclarations;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        agencyClientDeclarations.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(obj.toString(), context));
                        }
                    }
                    return agencyClientDeclarations;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return agencyClientDeclarations;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return agencyClientDeclarations;
                }
                agencyClientDeclarations.clear();
                agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(json, context));
                return agencyClientDeclarations;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AgencyClientDeclaration.getGson().toJson((Object)this);
    }

    public Long getFieldAgencyRepresentingClient() {
        return this.mAgencyRepresentingClient;
    }

    public AgencyClientDeclaration setFieldAgencyRepresentingClient(Long value) {
        this.mAgencyRepresentingClient = value;
        return this;
    }

    public Long getFieldClientBasedInFrance() {
        return this.mClientBasedInFrance;
    }

    public AgencyClientDeclaration setFieldClientBasedInFrance(Long value) {
        this.mClientBasedInFrance = value;
        return this;
    }

    public String getFieldClientCity() {
        return this.mClientCity;
    }

    public AgencyClientDeclaration setFieldClientCity(String value) {
        this.mClientCity = value;
        return this;
    }

    public String getFieldClientCountryCode() {
        return this.mClientCountryCode;
    }

    public AgencyClientDeclaration setFieldClientCountryCode(String value) {
        this.mClientCountryCode = value;
        return this;
    }

    public String getFieldClientEmailAddress() {
        return this.mClientEmailAddress;
    }

    public AgencyClientDeclaration setFieldClientEmailAddress(String value) {
        this.mClientEmailAddress = value;
        return this;
    }

    public String getFieldClientName() {
        return this.mClientName;
    }

    public AgencyClientDeclaration setFieldClientName(String value) {
        this.mClientName = value;
        return this;
    }

    public String getFieldClientPostalCode() {
        return this.mClientPostalCode;
    }

    public AgencyClientDeclaration setFieldClientPostalCode(String value) {
        this.mClientPostalCode = value;
        return this;
    }

    public String getFieldClientProvince() {
        return this.mClientProvince;
    }

    public AgencyClientDeclaration setFieldClientProvince(String value) {
        this.mClientProvince = value;
        return this;
    }

    public String getFieldClientStreet() {
        return this.mClientStreet;
    }

    public AgencyClientDeclaration setFieldClientStreet(String value) {
        this.mClientStreet = value;
        return this;
    }

    public String getFieldClientStreet2() {
        return this.mClientStreet2;
    }

    public AgencyClientDeclaration setFieldClientStreet2(String value) {
        this.mClientStreet2 = value;
        return this;
    }

    public Long getFieldHasWrittenMandateFromAdvertiser() {
        return this.mHasWrittenMandateFromAdvertiser;
    }

    public AgencyClientDeclaration setFieldHasWrittenMandateFromAdvertiser(Long value) {
        this.mHasWrittenMandateFromAdvertiser = value;
        return this;
    }

    public Long getFieldIsClientPayingInvoices() {
        return this.mIsClientPayingInvoices;
    }

    public AgencyClientDeclaration setFieldIsClientPayingInvoices(Long value) {
        this.mIsClientPayingInvoices = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AgencyClientDeclaration copyFrom(AgencyClientDeclaration instance) {
        this.mAgencyRepresentingClient = instance.mAgencyRepresentingClient;
        this.mClientBasedInFrance = instance.mClientBasedInFrance;
        this.mClientCity = instance.mClientCity;
        this.mClientCountryCode = instance.mClientCountryCode;
        this.mClientEmailAddress = instance.mClientEmailAddress;
        this.mClientName = instance.mClientName;
        this.mClientPostalCode = instance.mClientPostalCode;
        this.mClientProvince = instance.mClientProvince;
        this.mClientStreet = instance.mClientStreet;
        this.mClientStreet2 = instance.mClientStreet2;
        this.mHasWrittenMandateFromAdvertiser = instance.mHasWrittenMandateFromAdvertiser;
        this.mIsClientPayingInvoices = instance.mIsClientPayingInvoices;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AgencyClientDeclaration> getParser() {
        return new APIRequest.ResponseParser<AgencyClientDeclaration>(){

            @Override
            public APINodeList<AgencyClientDeclaration> parseResponse(String response, APIContext context, APIRequest<AgencyClientDeclaration> request) throws APIException.MalformedResponseException {
                return AgencyClientDeclaration.parseResponse(response, context, request);
            }
        };
    }
}

