/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdStudyObjective;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.User;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdStudy
extends APINode {
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="canceled_time")
    private String mCanceledTime = null;
    @SerializedName(value="cooldown_start_time")
    private String mCooldownStartTime = null;
    @SerializedName(value="created_by")
    private User mCreatedBy = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="observation_end_time")
    private String mObservationEndTime = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="updated_by")
    private User mUpdatedBy = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    protected static Gson gson = null;

    AdStudy() {
    }

    public AdStudy(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdStudy(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdStudy fetch() throws APIException {
        AdStudy newInstance = AdStudy.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdStudy fetchById(Long id, APIContext context) throws APIException {
        return AdStudy.fetchById(id.toString(), context);
    }

    public static AdStudy fetchById(String id, APIContext context) throws APIException {
        AdStudy adStudy = new APIRequestGet(id, context).requestAllFields().execute();
        return adStudy;
    }

    public static APINodeList<AdStudy> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdStudy>(context, "", "/", "GET", AdStudy.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdStudy loadJSON(String json, APIContext context) {
        AdStudy adStudy = (AdStudy)AdStudy.getGson().fromJson(json, AdStudy.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adStudy.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adStudy.context = context;
        adStudy.rawValue = json;
        return adStudy;
    }

    public static APINodeList<AdStudy> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<AdStudy> adStudys = new APINodeList<AdStudy>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adStudys.add(AdStudy.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adStudys;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        adStudys.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adStudys.add(AdStudy.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adStudys.add(AdStudy.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adStudys.add(AdStudy.loadJSON(obj.toString(), context));
                        }
                    }
                    return adStudys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adStudys.add(AdStudy.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adStudys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adStudys.add(AdStudy.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adStudys;
                }
                adStudys.clear();
                adStudys.add(AdStudy.loadJSON(json, context));
                return adStudys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdStudy.getGson().toJson((Object)this);
    }

    public APIRequestCreateObjective createObjective() {
        return new APIRequestCreateObjective(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldCanceledTime() {
        return this.mCanceledTime;
    }

    public String getFieldCooldownStartTime() {
        return this.mCooldownStartTime;
    }

    public User getFieldCreatedBy() {
        if (this.mCreatedBy != null) {
            this.mCreatedBy.context = this.getContext();
        }
        return this.mCreatedBy;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldObservationEndTime() {
        return this.mObservationEndTime;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public String getFieldType() {
        return this.mType;
    }

    public User getFieldUpdatedBy() {
        if (this.mUpdatedBy != null) {
            this.mUpdatedBy.context = this.getContext();
        }
        return this.mUpdatedBy;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdStudy copyFrom(AdStudy instance) {
        this.mBusiness = instance.mBusiness;
        this.mCanceledTime = instance.mCanceledTime;
        this.mCooldownStartTime = instance.mCooldownStartTime;
        this.mCreatedBy = instance.mCreatedBy;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mEndTime = instance.mEndTime;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mObservationEndTime = instance.mObservationEndTime;
        this.mStartTime = instance.mStartTime;
        this.mType = instance.mType;
        this.mUpdatedBy = instance.mUpdatedBy;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdStudy> getParser() {
        return new APIRequest.ResponseParser<AdStudy>(){

            @Override
            public APINodeList<AdStudy> parseResponse(String response, APIContext context, APIRequest<AdStudy> request) throws APIException.MalformedResponseException {
                return AdStudy.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_LIFT("LIFT"),
        VALUE_SPLIT_TEST("SPLIT_TEST"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdStudy> {
        AdStudy lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "canceled_time", "cooldown_start_time", "created_by", "created_time", "description", "end_time", "id", "name", "observation_end_time", "start_time", "type", "updated_by", "updated_time"};

        @Override
        public AdStudy getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudy parseResponse(String response) throws APIException {
            return AdStudy.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdStudy execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudy execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestCanceledTimeField() {
            return this.requestCanceledTimeField(true);
        }

        public APIRequestGet requestCanceledTimeField(boolean value) {
            this.requestField("canceled_time", value);
            return this;
        }

        public APIRequestGet requestCooldownStartTimeField() {
            return this.requestCooldownStartTimeField(true);
        }

        public APIRequestGet requestCooldownStartTimeField(boolean value) {
            this.requestField("cooldown_start_time", value);
            return this;
        }

        public APIRequestGet requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGet requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestObservationEndTimeField() {
            return this.requestObservationEndTimeField(true);
        }

        public APIRequestGet requestObservationEndTimeField(boolean value) {
            this.requestField("observation_end_time", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGet requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateObjective
    extends APIRequest<AdStudyObjective> {
        AdStudyObjective lastResponse = null;
        public static final String[] PARAMS = new String[]{"adspixels", "applications", "is_primary", "name", "offlinefeeds", "offsitepixels", "type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdStudyObjective getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudyObjective parseResponse(String response) throws APIException {
            return AdStudyObjective.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdStudyObjective execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudyObjective execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestCreateObjective(String nodeId, APIContext context) {
            super(context, nodeId, "/objectives", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateObjective setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateObjective setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateObjective setAdspixels(List<Object> adspixels) {
            this.setParam("adspixels", adspixels);
            return this;
        }

        public APIRequestCreateObjective setAdspixels(String adspixels) {
            this.setParam("adspixels", adspixels);
            return this;
        }

        public APIRequestCreateObjective setApplications(List<Object> applications) {
            this.setParam("applications", applications);
            return this;
        }

        public APIRequestCreateObjective setApplications(String applications) {
            this.setParam("applications", applications);
            return this;
        }

        public APIRequestCreateObjective setIsPrimary(Boolean isPrimary) {
            this.setParam("is_primary", isPrimary);
            return this;
        }

        public APIRequestCreateObjective setIsPrimary(String isPrimary) {
            this.setParam("is_primary", isPrimary);
            return this;
        }

        public APIRequestCreateObjective setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateObjective setOfflinefeeds(List<Object> offlinefeeds) {
            this.setParam("offlinefeeds", offlinefeeds);
            return this;
        }

        public APIRequestCreateObjective setOfflinefeeds(String offlinefeeds) {
            this.setParam("offlinefeeds", offlinefeeds);
            return this;
        }

        public APIRequestCreateObjective setOffsitepixels(List<Object> offsitepixels) {
            this.setParam("offsitepixels", offsitepixels);
            return this;
        }

        public APIRequestCreateObjective setOffsitepixels(String offsitepixels) {
            this.setParam("offsitepixels", offsitepixels);
            return this;
        }

        public APIRequestCreateObjective setType(AdStudyObjective.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestCreateObjective setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestCreateObjective requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateObjective requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateObjective requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateObjective requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateObjective requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateObjective requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

