/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetingDynamicRule
extends APINode {
    @SerializedName(value="action.type")
    private String mActionType = null;
    @SerializedName(value="ad_group_id")
    private String mAdGroupId = null;
    @SerializedName(value="campaign_group_id")
    private String mCampaignGroupId = null;
    @SerializedName(value="campaign_id")
    private String mCampaignId = null;
    @SerializedName(value="impression_count")
    private String mImpressionCount = null;
    @SerializedName(value="page_id")
    private String mPageId = null;
    @SerializedName(value="post")
    private String mPost = null;
    @SerializedName(value="retention_seconds")
    private String mRetentionSeconds = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static TargetingDynamicRule loadJSON(String json, APIContext context) {
        TargetingDynamicRule targetingDynamicRule = (TargetingDynamicRule)TargetingDynamicRule.getGson().fromJson(json, TargetingDynamicRule.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(targetingDynamicRule.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        targetingDynamicRule.context = context;
        targetingDynamicRule.rawValue = json;
        return targetingDynamicRule;
    }

    public static APINodeList<TargetingDynamicRule> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<TargetingDynamicRule> targetingDynamicRules = new APINodeList<TargetingDynamicRule>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        targetingDynamicRules.add(TargetingDynamicRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return targetingDynamicRules;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        targetingDynamicRules.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            targetingDynamicRules.add(TargetingDynamicRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                targetingDynamicRules.add(TargetingDynamicRule.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            targetingDynamicRules.add(TargetingDynamicRule.loadJSON(obj.toString(), context));
                        }
                    }
                    return targetingDynamicRules;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        targetingDynamicRules.add(TargetingDynamicRule.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return targetingDynamicRules;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        targetingDynamicRules.add(TargetingDynamicRule.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return targetingDynamicRules;
                }
                targetingDynamicRules.clear();
                targetingDynamicRules.add(TargetingDynamicRule.loadJSON(json, context));
                return targetingDynamicRules;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TargetingDynamicRule.getGson().toJson((Object)this);
    }

    public String getFieldActionType() {
        return this.mActionType;
    }

    public TargetingDynamicRule setFieldActionType(String value) {
        this.mActionType = value;
        return this;
    }

    public String getFieldAdGroupId() {
        return this.mAdGroupId;
    }

    public TargetingDynamicRule setFieldAdGroupId(String value) {
        this.mAdGroupId = value;
        return this;
    }

    public String getFieldCampaignGroupId() {
        return this.mCampaignGroupId;
    }

    public TargetingDynamicRule setFieldCampaignGroupId(String value) {
        this.mCampaignGroupId = value;
        return this;
    }

    public String getFieldCampaignId() {
        return this.mCampaignId;
    }

    public TargetingDynamicRule setFieldCampaignId(String value) {
        this.mCampaignId = value;
        return this;
    }

    public String getFieldImpressionCount() {
        return this.mImpressionCount;
    }

    public TargetingDynamicRule setFieldImpressionCount(String value) {
        this.mImpressionCount = value;
        return this;
    }

    public String getFieldPageId() {
        return this.mPageId;
    }

    public TargetingDynamicRule setFieldPageId(String value) {
        this.mPageId = value;
        return this;
    }

    public String getFieldPost() {
        return this.mPost;
    }

    public TargetingDynamicRule setFieldPost(String value) {
        this.mPost = value;
        return this;
    }

    public String getFieldRetentionSeconds() {
        return this.mRetentionSeconds;
    }

    public TargetingDynamicRule setFieldRetentionSeconds(String value) {
        this.mRetentionSeconds = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TargetingDynamicRule copyFrom(TargetingDynamicRule instance) {
        this.mActionType = instance.mActionType;
        this.mAdGroupId = instance.mAdGroupId;
        this.mCampaignGroupId = instance.mCampaignGroupId;
        this.mCampaignId = instance.mCampaignId;
        this.mImpressionCount = instance.mImpressionCount;
        this.mPageId = instance.mPageId;
        this.mPost = instance.mPost;
        this.mRetentionSeconds = instance.mRetentionSeconds;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TargetingDynamicRule> getParser() {
        return new APIRequest.ResponseParser<TargetingDynamicRule>(){

            @Override
            public APINodeList<TargetingDynamicRule> parseResponse(String response, APIContext context, APIRequest<TargetingDynamicRule> request) throws APIException.MalformedResponseException {
                return TargetingDynamicRule.parseResponse(response, context, request);
            }
        };
    }
}

