/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.OutcomePredictionPoint;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliveryEstimate
extends APINode {
    @SerializedName(value="bid_estimate")
    private Object mBidEstimate = null;
    @SerializedName(value="daily_outcomes_curve")
    private List<OutcomePredictionPoint> mDailyOutcomesCurve = null;
    @SerializedName(value="estimate_dau")
    private Object mEstimateDau = null;
    @SerializedName(value="estimate_mau")
    private Object mEstimateMau = null;
    @SerializedName(value="estimate_ready")
    private Boolean mEstimateReady = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static DeliveryEstimate loadJSON(String json, APIContext context) {
        DeliveryEstimate deliveryEstimate = (DeliveryEstimate)DeliveryEstimate.getGson().fromJson(json, DeliveryEstimate.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(deliveryEstimate.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        deliveryEstimate.context = context;
        deliveryEstimate.rawValue = json;
        return deliveryEstimate;
    }

    public static APINodeList<DeliveryEstimate> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<DeliveryEstimate> deliveryEstimates = new APINodeList<DeliveryEstimate>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        deliveryEstimates.add(DeliveryEstimate.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return deliveryEstimates;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        deliveryEstimates.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            deliveryEstimates.add(DeliveryEstimate.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                deliveryEstimates.add(DeliveryEstimate.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            deliveryEstimates.add(DeliveryEstimate.loadJSON(obj.toString(), context));
                        }
                    }
                    return deliveryEstimates;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        deliveryEstimates.add(DeliveryEstimate.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return deliveryEstimates;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        deliveryEstimates.add(DeliveryEstimate.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return deliveryEstimates;
                }
                deliveryEstimates.clear();
                deliveryEstimates.add(DeliveryEstimate.loadJSON(json, context));
                return deliveryEstimates;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return DeliveryEstimate.getGson().toJson((Object)this);
    }

    public Object getFieldBidEstimate() {
        return this.mBidEstimate;
    }

    public DeliveryEstimate setFieldBidEstimate(Object value) {
        this.mBidEstimate = value;
        return this;
    }

    public List<OutcomePredictionPoint> getFieldDailyOutcomesCurve() {
        return this.mDailyOutcomesCurve;
    }

    public DeliveryEstimate setFieldDailyOutcomesCurve(List<OutcomePredictionPoint> value) {
        this.mDailyOutcomesCurve = value;
        return this;
    }

    public DeliveryEstimate setFieldDailyOutcomesCurve(String value) {
        Type type = new TypeToken<List<OutcomePredictionPoint>>(){}.getType();
        this.mDailyOutcomesCurve = (List)OutcomePredictionPoint.getGson().fromJson(value, type);
        return this;
    }

    public Object getFieldEstimateDau() {
        return this.mEstimateDau;
    }

    public DeliveryEstimate setFieldEstimateDau(Object value) {
        this.mEstimateDau = value;
        return this;
    }

    public Object getFieldEstimateMau() {
        return this.mEstimateMau;
    }

    public DeliveryEstimate setFieldEstimateMau(Object value) {
        this.mEstimateMau = value;
        return this;
    }

    public Boolean getFieldEstimateReady() {
        return this.mEstimateReady;
    }

    public DeliveryEstimate setFieldEstimateReady(Boolean value) {
        this.mEstimateReady = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public DeliveryEstimate copyFrom(DeliveryEstimate instance) {
        this.mBidEstimate = instance.mBidEstimate;
        this.mDailyOutcomesCurve = instance.mDailyOutcomesCurve;
        this.mEstimateDau = instance.mEstimateDau;
        this.mEstimateMau = instance.mEstimateMau;
        this.mEstimateReady = instance.mEstimateReady;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<DeliveryEstimate> getParser() {
        return new APIRequest.ResponseParser<DeliveryEstimate>(){

            @Override
            public APINodeList<DeliveryEstimate> parseResponse(String response, APIContext context, APIRequest<DeliveryEstimate> request) throws APIException.MalformedResponseException {
                return DeliveryEstimate.parseResponse(response, context, request);
            }
        };
    }
}

