/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.functions.datetime;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.AbstractFunction;
import com.ezylang.evalex.functions.FunctionParameter;
import com.ezylang.evalex.functions.FunctionParameters;
import com.ezylang.evalex.functions.datetime.ZoneIdConverter;
import com.ezylang.evalex.parser.Token;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

@FunctionParameters(value={@FunctionParameter(name="value"), @FunctionParameter(name="parameters", isVarArg=true)})
public class DateTimeFormatFunction
extends AbstractFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        DateTimeFormatter formatter = expression.getConfiguration().getDateTimeFormatters().get(0);
        if (parameterValues.length > 1) {
            formatter = DateTimeFormatter.ofPattern(parameterValues[1].getStringValue()).withLocale(expression.getConfiguration().getLocale());
        }
        ZoneId zoneId = expression.getConfiguration().getZoneId();
        if (parameterValues.length == 3) {
            zoneId = ZoneIdConverter.convert(functionToken, parameterValues[2].getStringValue());
        }
        return expression.convertValue(parameterValues[0].getDateTimeValue().atZone(zoneId).format(formatter));
    }

    @Override
    public void validatePreEvaluation(Token token, EvaluationValue ... parameterValues) throws EvaluationException {
        super.validatePreEvaluation(token, parameterValues);
        if (parameterValues.length > 3) {
            throw new EvaluationException(token, "Too many parameters");
        }
        if (!parameterValues[0].isDateTimeValue()) {
            throw new EvaluationException(token, String.format("Unable to format a '%s' type as a date-time", parameterValues[0].getDataType().name()));
        }
    }
}

