/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.functions.basic;

import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.FunctionParameter;
import com.ezylang.evalex.functions.FunctionParameters;
import com.ezylang.evalex.functions.basic.AbstractMinMaxFunction;
import com.ezylang.evalex.parser.Token;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;

@FunctionParameters(value={@FunctionParameter(name="firstValue"), @FunctionParameter(name="additionalValues", isVarArg=true)})
public class AverageFunction
extends AbstractMinMaxFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) {
        MathContext mathContext = expression.getConfiguration().getMathContext();
        BigDecimal sum = Arrays.stream(parameterValues).map(EvaluationValue::getNumberValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal count = BigDecimal.valueOf(parameterValues.length);
        BigDecimal average = sum.divide(count, mathContext);
        return expression.convertValue(average);
    }
}

