/*
 * Decompiled with CFR 0.152.
 */
package com.eyalbira.loadingdots;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.eyalbira.loadingdots.R;
import java.util.ArrayList;
import java.util.List;

public class LoadingDots
extends LinearLayout {
    public static final int DEFAULT_DOTS_COUNT = 3;
    public static final int DEFAULT_LOOP_DURATION = 600;
    public static final int DEFAULT_LOOP_START_DELAY = 100;
    public static final int DEFAULT_JUMP_DURATION = 400;
    private List<View> mDots;
    private ValueAnimator mAnimation;
    private boolean mIsAttachedToWindow;
    private boolean mAutoPlay;
    private int mDotsColor;
    private int mDotsCount;
    private int mDotSize;
    private int mDotSpace;
    private int mLoopDuration;
    private int mLoopStartDelay;
    private int mJumpDuration;
    private int mJumpHeight;
    private int mJumpHalfTime;
    private int[] mDotsStartTime;
    private int[] mDotsJumpUpEndTime;
    private int[] mDotsJumpDownEndTime;

    public LoadingDots(Context context) {
        super(context);
        this.init(null);
    }

    public LoadingDots(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public LoadingDots(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public LoadingDots(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        Context context = this.getContext();
        Resources resources = context.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LoadingDots);
        this.mAutoPlay = a.getBoolean(R.styleable.LoadingDots_LoadingDots_auto_play, true);
        this.mDotsColor = a.getColor(R.styleable.LoadingDots_LoadingDots_dots_color, -7829368);
        this.mDotsCount = a.getInt(R.styleable.LoadingDots_LoadingDots_dots_count, 3);
        this.mDotSize = a.getDimensionPixelSize(R.styleable.LoadingDots_LoadingDots_dots_size, resources.getDimensionPixelSize(R.dimen.LoadingDots_dots_size_default));
        this.mDotSpace = a.getDimensionPixelSize(R.styleable.LoadingDots_LoadingDots_dots_space, resources.getDimensionPixelSize(R.dimen.LoadingDots_dots_space_default));
        this.mLoopDuration = a.getInt(R.styleable.LoadingDots_LoadingDots_loop_duration, 600);
        this.mLoopStartDelay = a.getInt(R.styleable.LoadingDots_LoadingDots_loop_start_delay, 100);
        this.mJumpDuration = a.getInt(R.styleable.LoadingDots_LoadingDots_jump_duration, 400);
        this.mJumpHeight = a.getDimensionPixelSize(R.styleable.LoadingDots_LoadingDots_jump_height, resources.getDimensionPixelSize(R.dimen.LoadingDots_jump_height_default));
        a.recycle();
        this.setOrientation(0);
        this.setGravity(80);
        this.calculateCachedValues();
        this.initializeDots(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.getMeasuredWidth(), this.getMeasuredHeight() + this.mJumpHeight);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsAttachedToWindow = true;
        this.createAnimationIfAutoPlay();
        if (this.mAnimation != null && this.getVisibility() == 0) {
            this.mAnimation.start();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsAttachedToWindow = false;
        if (this.mAnimation != null) {
            this.mAnimation.end();
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        switch (visibility) {
            case 0: {
                this.createAnimationIfAutoPlay();
                this.startAnimationIfAttached();
                break;
            }
            case 4: 
            case 8: {
                if (this.mAnimation == null) break;
                this.mAnimation.end();
            }
        }
    }

    private View createDotView(Context context) {
        ImageView dot = new ImageView(context);
        dot.setImageResource(R.drawable.loading_dots_dot);
        ((GradientDrawable)dot.getDrawable()).setColor(this.mDotsColor);
        return dot;
    }

    private void startAnimationIfAttached() {
        if (this.mIsAttachedToWindow) {
            this.mAnimation.start();
        }
    }

    private void createAnimationIfAutoPlay() {
        if (this.mAutoPlay) {
            this.createAnimation();
        }
    }

    private void createAnimation() {
        if (this.mAnimation != null) {
            return;
        }
        this.mAnimation = ValueAnimator.ofInt((int[])new int[]{0, this.mLoopDuration});
        this.mAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int dotsCount = LoadingDots.this.mDots.size();
                int from = 0;
                int animationValue = (Integer)valueAnimator.getAnimatedValue();
                if (animationValue < LoadingDots.this.mLoopStartDelay) {
                    return;
                }
                for (int i = 0; i < dotsCount; ++i) {
                    View dot = (View)LoadingDots.this.mDots.get(i);
                    int dotStartTime = LoadingDots.this.mDotsStartTime[i];
                    float animationFactor = animationValue < dotStartTime ? 0.0f : (animationValue < LoadingDots.this.mDotsJumpUpEndTime[i] ? (float)(animationValue - dotStartTime) / (float)LoadingDots.this.mJumpHalfTime : (animationValue < LoadingDots.this.mDotsJumpDownEndTime[i] ? 1.0f - (float)(animationValue - dotStartTime - LoadingDots.this.mJumpHalfTime) / (float)LoadingDots.this.mJumpHalfTime : 0.0f));
                    float translationY = (float)(-LoadingDots.this.mJumpHeight - from) * animationFactor;
                    dot.setTranslationY(translationY);
                }
            }
        });
        this.mAnimation.setDuration((long)this.mLoopDuration);
        this.mAnimation.setRepeatCount(-1);
    }

    public final void startAnimation() {
        if (this.mAnimation != null && this.mAnimation.isRunning()) {
            return;
        }
        this.createAnimation();
        this.startAnimationIfAttached();
    }

    public final void stopAnimation() {
        if (this.mAnimation != null) {
            this.mAnimation.cancel();
            this.mAnimation = null;
        }
    }

    private void calculateCachedValues() {
        int startOffset = (this.mLoopDuration - (this.mJumpDuration + this.mLoopStartDelay)) / (this.mDotsCount - 1);
        this.mJumpHalfTime = this.mJumpDuration / 2;
        this.mDotsStartTime = new int[this.mDotsCount];
        this.mDotsJumpUpEndTime = new int[this.mDotsCount];
        this.mDotsJumpDownEndTime = new int[this.mDotsCount];
        for (int i = 0; i < this.mDotsCount; ++i) {
            int startTime;
            this.mDotsStartTime[i] = startTime = this.mLoopStartDelay + startOffset * i;
            this.mDotsJumpUpEndTime[i] = startTime + this.mJumpHalfTime;
            this.mDotsJumpDownEndTime[i] = startTime + this.mJumpDuration;
        }
    }

    private void initializeDots(Context context) {
        this.mDots = new ArrayList<View>(this.mDotsCount);
        LinearLayout.LayoutParams dotParams = new LinearLayout.LayoutParams(this.mDotSize, this.mDotSize);
        LinearLayout.LayoutParams spaceParams = new LinearLayout.LayoutParams(this.mDotSpace, this.mDotSize);
        for (int i = 0; i < this.mDotsCount; ++i) {
            View dotView = this.createDotView(context);
            this.addView(dotView, (ViewGroup.LayoutParams)dotParams);
            this.mDots.add(dotView);
            if (i >= this.mDotsCount - 1) continue;
            this.addView(new View(context), (ViewGroup.LayoutParams)spaceParams);
        }
    }
}

