/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.core;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.enhydra.jdbc.util.JdbcUtil;

public abstract class CoreConnection
extends JdbcUtil
implements Connection {
    public Connection con;

    public CoreConnection(Connection con) {
        this.con = con;
    }

    public CoreConnection() {
    }

    public boolean isClosed() throws SQLException {
        return this.con.isClosed();
    }

    public void clearWarnings() throws SQLException {
        this.preInvoke();
        try {
            this.con.clearWarnings();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void close() throws SQLException {
        this.preInvoke();
        try {
            this.con.close();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void commit() throws SQLException {
        this.preInvoke();
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public Statement createStatement() throws SQLException {
        this.preInvoke();
        try {
            return this.con.createStatement();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.preInvoke();
        try {
            return this.con.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getAutoCommit();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    public String getCatalog() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getCatalog();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getMetaData();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getTransactionIsolation();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    public Map getTypeMap() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getTypeMap();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getWarnings();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.preInvoke();
        try {
            return this.con.isReadOnly();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        this.preInvoke();
        try {
            return this.con.nativeSQL(sql);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareCall(sql);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(sql);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public void rollback() throws SQLException {
        this.preInvoke();
        try {
            this.con.rollback();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        boolean con_autocommit = this.con.getAutoCommit();
        this.log.debug("CoreConnection:Setautocommit autoCommit was = " + con_autocommit);
        this.log.debug("CoreConnection:Setautocommit = " + autoCommit);
        this.preInvoke();
        try {
            if (autoCommit != con_autocommit) {
                this.con.setAutoCommit(autoCommit);
            } else {
                this.log.debug("CoreConnection:Setautocommit = SKIPPED ");
            }
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        this.preInvoke();
        try {
            this.con.setCatalog(catalog);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.preInvoke();
        try {
            this.con.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.preInvoke();
        try {
            this.con.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.preInvoke();
        try {
            this.con.setTypeMap(map);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.preInvoke();
        try {
            return this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public int getHoldability() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getHoldability();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.preInvoke();
        try {
            return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.preInvoke();
        try {
            this.con.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.preInvoke();
        try {
            this.con.rollback(savepoint);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        this.preInvoke();
        try {
            this.con.setHoldability(holdability);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        this.preInvoke();
        try {
            return this.con.setSavepoint();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.preInvoke();
        try {
            return this.con.setSavepoint(name);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public abstract void preInvoke() throws SQLException;

    public abstract void catchInvoke(SQLException var1) throws SQLException;
}

