/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.server.spring;

import com.expediagroup.graphql.dataloader.KotlinDataLoader;
import com.expediagroup.graphql.dataloader.KotlinDataLoaderRegistryFactory;
import com.expediagroup.graphql.generator.execution.KotlinDataFetcherFactoryProvider;
import com.expediagroup.graphql.server.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.server.spring.execution.SpringKotlinDataFetcherFactoryProvider;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={GraphQLConfigurationProperties.class})
@Import(value={JacksonAutoConfiguration.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J$\u0010\u0007\u001a\u00020\b2\u001a\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\u000b0\nH\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017\u00a8\u0006\u000f"}, d2={"Lcom/expediagroup/graphql/server/spring/GraphQLExecutionConfiguration;", "", "()V", "dataFetcherFactoryProvider", "Lcom/expediagroup/graphql/generator/execution/KotlinDataFetcherFactoryProvider;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "dataLoaderRegistryFactory", "Lcom/expediagroup/graphql/dataloader/KotlinDataLoaderRegistryFactory;", "dataLoaders", "Ljava/util/Optional;", "", "Lcom/expediagroup/graphql/dataloader/KotlinDataLoader;", "exceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "graphql-kotlin-spring-server"})
public class GraphQLExecutionConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public KotlinDataFetcherFactoryProvider dataFetcherFactoryProvider(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        return (KotlinDataFetcherFactoryProvider)new SpringKotlinDataFetcherFactoryProvider(applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataFetcherExceptionHandler exceptionHandler() {
        return (DataFetcherExceptionHandler)new SimpleDataFetcherExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public KotlinDataLoaderRegistryFactory dataLoaderRegistryFactory(@NotNull Optional<List<KotlinDataLoader<?, ?>>> dataLoaders) {
        Intrinsics.checkNotNullParameter(dataLoaders, (String)"dataLoaders");
        List list = dataLoaders.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"dataLoaders.orElse(emptyList())");
        return new KotlinDataLoaderRegistryFactory(list);
    }
}

