/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.server.spring;

import com.expediagroup.graphql.dataloader.KotlinDataLoaderRegistryFactory;
import com.expediagroup.graphql.generator.hooks.FlowSubscriptionSchemaGeneratorHooks;
import com.expediagroup.graphql.generator.hooks.SchemaGeneratorHooks;
import com.expediagroup.graphql.server.operations.Subscription;
import com.expediagroup.graphql.server.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.server.spring.GraphQLSchemaConfiguration;
import com.expediagroup.graphql.server.spring.subscriptions.ApolloSubscriptionHooks;
import com.expediagroup.graphql.server.spring.subscriptions.ApolloSubscriptionProtocolHandler;
import com.expediagroup.graphql.server.spring.subscriptions.DefaultSpringSubscriptionGraphQLContextFactory;
import com.expediagroup.graphql.server.spring.subscriptions.SimpleSubscriptionHooks;
import com.expediagroup.graphql.server.spring.subscriptions.SpringGraphQLSubscriptionHandler;
import com.expediagroup.graphql.server.spring.subscriptions.SpringSubscriptionGraphQLContextFactory;
import com.expediagroup.graphql.server.spring.subscriptions.SubscriptionWebSocketHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.GraphQL;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;

@Configuration
@ConditionalOnBean(value={Subscription.class})
@Import(value={GraphQLSchemaConfiguration.class})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004H\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\nH\u0017J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u001b\u001a\u00020\u001cH\u0017\u00a8\u0006\u001d"}, d2={"Lcom/expediagroup/graphql/server/spring/SubscriptionAutoConfiguration;", "", "()V", "apolloSubscriptionHooks", "Lcom/expediagroup/graphql/server/spring/subscriptions/ApolloSubscriptionHooks;", "apolloSubscriptionProtocolHandler", "Lcom/expediagroup/graphql/server/spring/subscriptions/ApolloSubscriptionProtocolHandler;", "config", "Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;", "subscriptionContextFactory", "Lcom/expediagroup/graphql/server/spring/subscriptions/SpringSubscriptionGraphQLContextFactory;", "handler", "Lcom/expediagroup/graphql/server/spring/subscriptions/SpringGraphQLSubscriptionHandler;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "flowSubscriptionSchemaGeneratorHooks", "Lcom/expediagroup/graphql/generator/hooks/SchemaGeneratorHooks;", "springSubscriptionGraphQLContextFactory", "subscriptionHandler", "graphQL", "Lgraphql/GraphQL;", "dataLoaderRegistryFactory", "Lcom/expediagroup/graphql/dataloader/KotlinDataLoaderRegistryFactory;", "subscriptionHandlerMapping", "Lorg/springframework/web/reactive/HandlerMapping;", "subscriptionWebSocketHandler", "Lcom/expediagroup/graphql/server/spring/subscriptions/SubscriptionWebSocketHandler;", "websocketHandlerAdapter", "Lorg/springframework/web/reactive/socket/server/support/WebSocketHandlerAdapter;", "graphql-kotlin-spring-server"})
public class SubscriptionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SchemaGeneratorHooks flowSubscriptionSchemaGeneratorHooks() {
        return (SchemaGeneratorHooks)new FlowSubscriptionSchemaGeneratorHooks();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SpringGraphQLSubscriptionHandler subscriptionHandler(@NotNull GraphQL graphQL2, @NotNull KotlinDataLoaderRegistryFactory dataLoaderRegistryFactory) {
        Intrinsics.checkNotNullParameter((Object)graphQL2, (String)"graphQL");
        Intrinsics.checkNotNullParameter((Object)dataLoaderRegistryFactory, (String)"dataLoaderRegistryFactory");
        return new SpringGraphQLSubscriptionHandler(graphQL2, dataLoaderRegistryFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public WebSocketHandlerAdapter websocketHandlerAdapter() {
        return new WebSocketHandlerAdapter();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ApolloSubscriptionHooks apolloSubscriptionHooks() {
        return new SimpleSubscriptionHooks();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SpringSubscriptionGraphQLContextFactory springSubscriptionGraphQLContextFactory() {
        return new DefaultSpringSubscriptionGraphQLContextFactory();
    }

    @Bean
    @NotNull
    public ApolloSubscriptionProtocolHandler apolloSubscriptionProtocolHandler(@NotNull GraphQLConfigurationProperties config, @NotNull SpringSubscriptionGraphQLContextFactory subscriptionContextFactory, @NotNull SpringGraphQLSubscriptionHandler handler, @NotNull ObjectMapper objectMapper, @NotNull ApolloSubscriptionHooks apolloSubscriptionHooks) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)subscriptionContextFactory, (String)"subscriptionContextFactory");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)apolloSubscriptionHooks, (String)"apolloSubscriptionHooks");
        return new ApolloSubscriptionProtocolHandler(config, subscriptionContextFactory, handler, objectMapper, apolloSubscriptionHooks);
    }

    @Bean
    @NotNull
    public SubscriptionWebSocketHandler subscriptionWebSocketHandler(@NotNull ApolloSubscriptionProtocolHandler handler, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return new SubscriptionWebSocketHandler(handler, objectMapper);
    }

    @Bean
    @NotNull
    public HandlerMapping subscriptionHandlerMapping(@NotNull GraphQLConfigurationProperties config, @NotNull SubscriptionWebSocketHandler subscriptionWebSocketHandler) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)subscriptionWebSocketHandler, (String)"subscriptionWebSocketHandler");
        return (HandlerMapping)new SimpleUrlHandlerMapping(MapsKt.mapOf((Pair)TuplesKt.to((Object)config.getSubscriptions().getEndpoint(), (Object)subscriptionWebSocketHandler)), 0);
    }
}

