/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.server.spring;

import com.expediagroup.graphql.generator.execution.KotlinDataFetcherFactoryProvider;
import com.expediagroup.graphql.server.execution.DataLoaderRegistryFactory;
import com.expediagroup.graphql.server.execution.DefaultDataLoaderRegistryFactory;
import com.expediagroup.graphql.server.execution.KotlinDataLoader;
import com.expediagroup.graphql.server.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.server.spring.execution.SpringKotlinDataFetcherFactoryProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={GraphQLConfigurationProperties.class})
@Import(value={JacksonAutoConfiguration.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J$\u0010\t\u001a\u00020\n2\u001a\u0010\u000b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e0\r0\fH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017\u00a8\u0006\u0011"}, d2={"Lcom/expediagroup/graphql/server/spring/GraphQLExecutionConfiguration;", "", "()V", "dataFetcherFactoryProvider", "Lcom/expediagroup/graphql/generator/execution/KotlinDataFetcherFactoryProvider;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "dataLoaderRegistryFactory", "Lcom/expediagroup/graphql/server/execution/DataLoaderRegistryFactory;", "dataLoaders", "Ljava/util/Optional;", "", "Lcom/expediagroup/graphql/server/execution/KotlinDataLoader;", "exceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "graphql-kotlin-spring-server"})
public class GraphQLExecutionConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public KotlinDataFetcherFactoryProvider dataFetcherFactoryProvider(@NotNull ObjectMapper objectMapper, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        return (KotlinDataFetcherFactoryProvider)new SpringKotlinDataFetcherFactoryProvider(objectMapper, applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataFetcherExceptionHandler exceptionHandler() {
        return (DataFetcherExceptionHandler)new SimpleDataFetcherExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataLoaderRegistryFactory dataLoaderRegistryFactory(@NotNull Optional<List<KotlinDataLoader<?, ?>>> dataLoaders) {
        Intrinsics.checkNotNullParameter(dataLoaders, (String)"dataLoaders");
        List list = dataLoaders.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"dataLoaders.orElse(emptyList())");
        return (DataLoaderRegistryFactory)new DefaultDataLoaderRegistryFactory(list);
    }
}

