/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.spring;

import com.expediagroup.graphql.execution.KotlinDataFetcherFactoryProvider;
import com.expediagroup.graphql.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.spring.exception.KotlinDataFetcherExceptionHandler;
import com.expediagroup.graphql.spring.execution.ContextWebFilter;
import com.expediagroup.graphql.spring.execution.DataLoaderRegistryFactory;
import com.expediagroup.graphql.spring.execution.DefaultContextFactory;
import com.expediagroup.graphql.spring.execution.EmptyDataLoaderRegistryFactory;
import com.expediagroup.graphql.spring.execution.GraphQLContextFactory;
import com.expediagroup.graphql.spring.execution.SpringKotlinDataFetcherFactoryProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.execution.DataFetcherExceptionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={GraphQLConfigurationProperties.class})
@Import(value={JacksonAutoConfiguration.class})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0017J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\f\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0017\u00a8\u0006\u0013"}, d2={"Lcom/expediagroup/graphql/spring/GraphQLExecutionConfiguration;", "", "()V", "contextWebFilter", "Lcom/expediagroup/graphql/spring/execution/ContextWebFilter;", "config", "Lcom/expediagroup/graphql/spring/GraphQLConfigurationProperties;", "graphQLContextFactory", "Lcom/expediagroup/graphql/spring/execution/GraphQLContextFactory;", "dataFetcherFactoryProvider", "Lcom/expediagroup/graphql/execution/KotlinDataFetcherFactoryProvider;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "dataLoaderRegistryFactory", "Lcom/expediagroup/graphql/spring/execution/DataLoaderRegistryFactory;", "exceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "graphql-kotlin-spring-server"})
public class GraphQLExecutionConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public KotlinDataFetcherFactoryProvider dataFetcherFactoryProvider(@NotNull ObjectMapper objectMapper, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
        return (KotlinDataFetcherFactoryProvider)new SpringKotlinDataFetcherFactoryProvider(objectMapper, applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataFetcherExceptionHandler exceptionHandler() {
        return new KotlinDataFetcherExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataLoaderRegistryFactory dataLoaderRegistryFactory() {
        return new EmptyDataLoaderRegistryFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQLContextFactory<?> graphQLContextFactory() {
        return DefaultContextFactory.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ContextWebFilter<?> contextWebFilter(@NotNull GraphQLConfigurationProperties config, @NotNull GraphQLContextFactory<?> graphQLContextFactory) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(graphQLContextFactory, (String)"graphQLContextFactory");
        return new ContextWebFilter(config, graphQLContextFactory);
    }
}

