/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.spring;

import com.apollographql.federation.graphqljava.tracing.FederatedTracingInstrumentation;
import com.expediagroup.graphql.TopLevelNames;
import com.expediagroup.graphql.TopLevelObject;
import com.expediagroup.graphql.execution.KotlinDataFetcherFactoryProvider;
import com.expediagroup.graphql.extensions.GraphQLSchemaExtensionsKt;
import com.expediagroup.graphql.federation.FederatedSchemaGeneratorConfig;
import com.expediagroup.graphql.federation.FederatedSchemaGeneratorHooks;
import com.expediagroup.graphql.federation.ToFederatedSchemaKt;
import com.expediagroup.graphql.federation.execution.FederatedTypeRegistry;
import com.expediagroup.graphql.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.spring.execution.DefaultFederatedContextFactory;
import com.expediagroup.graphql.spring.execution.FederatedGraphQLContextFactory;
import com.expediagroup.graphql.spring.extensions.GeneratorExtensionsKt;
import com.expediagroup.graphql.spring.operations.Mutation;
import com.expediagroup.graphql.spring.operations.Query;
import com.expediagroup.graphql.spring.operations.Subscription;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(havingValue="true", value={"graphql.federation.enabled"})
@Configuration
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017J\b\u0010\u0016\u001a\u00020\u0013H\u0017J\f\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0017JL\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\r2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001c0\r2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u001c0\r2\u0006\u0010\"\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/expediagroup/graphql/spring/FederatedSchemaAutoConfiguration;", "", "config", "Lcom/expediagroup/graphql/spring/GraphQLConfigurationProperties;", "(Lcom/expediagroup/graphql/spring/GraphQLConfigurationProperties;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "federatedSchemaConfig", "Lcom/expediagroup/graphql/federation/FederatedSchemaGeneratorConfig;", "hooks", "Lcom/expediagroup/graphql/federation/FederatedSchemaGeneratorHooks;", "topLevelNames", "Ljava/util/Optional;", "Lcom/expediagroup/graphql/TopLevelNames;", "dataFetcherFactoryProvider", "Lcom/expediagroup/graphql/execution/KotlinDataFetcherFactoryProvider;", "federatedSchemaGeneratorHooks", "registry", "Lcom/expediagroup/graphql/federation/execution/FederatedTypeRegistry;", "federatedTracing", "Lcom/apollographql/federation/graphqljava/tracing/FederatedTracingInstrumentation;", "federatedTypeRegistry", "graphQLContextFactory", "Lcom/expediagroup/graphql/spring/execution/FederatedGraphQLContextFactory;", "schema", "Lgraphql/schema/GraphQLSchema;", "queries", "", "Lcom/expediagroup/graphql/spring/operations/Query;", "mutations", "Lcom/expediagroup/graphql/spring/operations/Mutation;", "subscriptions", "Lcom/expediagroup/graphql/spring/operations/Subscription;", "schemaConfig", "graphql-kotlin-spring-server"})
public class FederatedSchemaAutoConfiguration {
    private final Logger logger;
    private final GraphQLConfigurationProperties config;

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public FederatedTypeRegistry federatedTypeRegistry() {
        return new FederatedTypeRegistry(MapsKt.emptyMap());
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public FederatedSchemaGeneratorHooks federatedSchemaGeneratorHooks(@NotNull FederatedTypeRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        return new FederatedSchemaGeneratorHooks(registry);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public FederatedSchemaGeneratorConfig federatedSchemaConfig(@NotNull FederatedSchemaGeneratorHooks hooks, @NotNull Optional<TopLevelNames> topLevelNames, @NotNull KotlinDataFetcherFactoryProvider dataFetcherFactoryProvider2) {
        Intrinsics.checkParameterIsNotNull((Object)hooks, (String)"hooks");
        Intrinsics.checkParameterIsNotNull(topLevelNames, (String)"topLevelNames");
        Intrinsics.checkParameterIsNotNull((Object)dataFetcherFactoryProvider2, (String)"dataFetcherFactoryProvider");
        List<String> list = this.config.getPackages();
        TopLevelNames topLevelNames2 = topLevelNames.orElse(new TopLevelNames(null, null, null, 7, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)topLevelNames2, (String)"topLevelNames.orElse(TopLevelNames())");
        return new FederatedSchemaGeneratorConfig(list, topLevelNames2, hooks, dataFetcherFactoryProvider2, this.config.getIntrospection().getEnabled());
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQLSchema schema(@NotNull Optional<List<Query>> queries, @NotNull Optional<List<Mutation>> mutations, @NotNull Optional<List<Subscription>> subscriptions, @NotNull FederatedSchemaGeneratorConfig schemaConfig) {
        Intrinsics.checkParameterIsNotNull(queries, (String)"queries");
        Intrinsics.checkParameterIsNotNull(mutations, (String)"mutations");
        Intrinsics.checkParameterIsNotNull(subscriptions, (String)"subscriptions");
        Intrinsics.checkParameterIsNotNull((Object)schemaConfig, (String)"schemaConfig");
        List<Query> list = queries.orElse(CollectionsKt.emptyList());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"queries.orElse(emptyList())");
        List<TopLevelObject> list2 = GeneratorExtensionsKt.toTopLevelObjects(list);
        List<Mutation> list3 = mutations.orElse(CollectionsKt.emptyList());
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"mutations.orElse(emptyList())");
        List<TopLevelObject> list4 = GeneratorExtensionsKt.toTopLevelObjects(list3);
        List<Subscription> list5 = subscriptions.orElse(CollectionsKt.emptyList());
        Intrinsics.checkExpressionValueIsNotNull(list5, (String)"subscriptions.orElse(emptyList())");
        GraphQLSchema schema = ToFederatedSchemaKt.toFederatedSchema((FederatedSchemaGeneratorConfig)schemaConfig, list2, list4, GeneratorExtensionsKt.toTopLevelObjects(list5));
        this.logger.info('\n' + GraphQLSchemaExtensionsKt.print$default((GraphQLSchema)schema, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (int)63, null));
        return schema;
    }

    @Bean
    @ConditionalOnProperty(havingValue="true", matchIfMissing=true, value={"graphql.federation.tracing.enabled"})
    @NotNull
    public FederatedTracingInstrumentation federatedTracing() {
        return new FederatedTracingInstrumentation(new FederatedTracingInstrumentation.Options(this.config.getFederation().getTracing().getDebug()));
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public FederatedGraphQLContextFactory<?> graphQLContextFactory() {
        return DefaultFederatedContextFactory.INSTANCE;
    }

    public FederatedSchemaAutoConfiguration(@NotNull GraphQLConfigurationProperties config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.logger = LoggerFactory.getLogger(FederatedSchemaAutoConfiguration.class);
    }
}

