/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.generator.internal.types;

import com.expediagroup.graphql.generator.SchemaGenerator;
import com.expediagroup.graphql.generator.annotations.GraphQLValidObjectLocations;
import com.expediagroup.graphql.generator.exceptions.CouldNotCastGraphQLSchemaElement;
import com.expediagroup.graphql.generator.hooks.SchemaGeneratorHooks;
import com.expediagroup.graphql.generator.internal.extensions.AnnotationExtensionsKt;
import com.expediagroup.graphql.generator.internal.extensions.KClassExtensionsKt;
import com.expediagroup.graphql.generator.internal.types.GenerateDirectiveKt;
import com.expediagroup.graphql.generator.internal.types.GenerateInputPropertyKt;
import com.expediagroup.graphql.generator.internal.types.utils.ValidateNameKt;
import com.expediagroup.graphql.generator.internal.types.utils.ValidateObjectLocationKt;
import com.expediagroup.graphql.generator.internal.types.utils.ValidatePrimaryConstructorExistsKt;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLSchemaElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0000\u00a8\u0006\u0006"}, d2={"generateInputObject", "Lgraphql/schema/GraphQLInputObjectType;", "generator", "Lcom/expediagroup/graphql/generator/SchemaGenerator;", "kClass", "Lkotlin/reflect/KClass;", "graphql-kotlin-schema-generator"})
@SourceDebugExtension(value={"SMAP\ngenerateInputObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 generateInputObject.kt\ncom/expediagroup/graphql/generator/internal/types/GenerateInputObjectKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 graphQLExtensions.kt\ncom/expediagroup/graphql/generator/internal/extensions/GraphQLExtensionsKt\n*L\n1#1,54:1\n1855#2,2:55\n1855#2,2:57\n40#3,2:59\n*S KotlinDebug\n*F\n+ 1 generateInputObject.kt\ncom/expediagroup/graphql/generator/internal/types/GenerateInputObjectKt\n*L\n43#1:55,2\n48#1:57,2\n52#1:59,2\n*E\n"})
public final class GenerateInputObjectKt {
    @NotNull
    public static final GraphQLInputObjectType generateInputObject(@NotNull SchemaGenerator generator, @NotNull KClass<?> kClass) {
        GraphQLAppliedDirective it;
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        ValidateObjectLocationKt.validateObjectLocation(kClass, GraphQLValidObjectLocations.Locations.INPUT_OBJECT);
        ValidatePrimaryConstructorExistsKt.validatePrimaryConstructorExists(kClass);
        String name = KClassExtensionsKt.getSimpleName(kClass, true);
        ValidateNameKt.validateGraphQLName(name, kClass);
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.name(name);
        builder.description(AnnotationExtensionsKt.getGraphQLDescription((KAnnotatedElement)kClass));
        Iterable $this$forEach$iv = GenerateDirectiveKt.generateDirectives$default(generator, (KAnnotatedElement)kClass, Introspection.DirectiveLocation.INPUT_OBJECT, null, 8, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GraphQLAppliedDirective)element$iv;
            boolean bl = false;
            builder.withAppliedDirective(it);
        }
        $this$forEach$iv = KClassExtensionsKt.getValidProperties(kClass, generator.getConfig$graphql_kotlin_schema_generator().getHooks());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (KProperty)element$iv;
            boolean bl = false;
            builder.field(GenerateInputPropertyKt.generateInputProperty(generator, it, kClass));
        }
        SchemaGeneratorHooks schemaGeneratorHooks = generator.getConfig$graphql_kotlin_schema_generator().getHooks();
        GraphQLInputObjectType graphQLInputObjectType = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLInputObjectType, (String)"build(...)");
        GraphQLSchemaElement $this$safeCast$iv = schemaGeneratorHooks.onRewireGraphQLType((GraphQLSchemaElement)graphQLInputObjectType, null, generator.getCodeRegistry$graphql_kotlin_schema_generator());
        boolean $i$f$safeCast = false;
        if (!($this$safeCast$iv instanceof GraphQLInputObjectType)) {
            throw new CouldNotCastGraphQLSchemaElement($this$safeCast$iv, Reflection.getOrCreateKotlinClass(GraphQLInputObjectType.class));
        }
        return (GraphQLInputObjectType)$this$safeCast$iv;
    }
}

