/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.generator.internal.types;

import com.expediagroup.graphql.generator.SchemaGenerator;
import com.expediagroup.graphql.generator.TopLevelObject;
import com.expediagroup.graphql.generator.exceptions.ConflictingFieldsException;
import com.expediagroup.graphql.generator.exceptions.InvalidQueryTypeException;
import com.expediagroup.graphql.generator.hooks.SchemaGeneratorHooks;
import com.expediagroup.graphql.generator.internal.extensions.KClassExtensionsKt;
import com.expediagroup.graphql.generator.internal.types.GenerateDirectiveKt;
import com.expediagroup.graphql.generator.internal.types.GenerateFunctionKt;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u00a8\u0006\u0007"}, d2={"generateQueries", "Lgraphql/schema/GraphQLObjectType;", "generator", "Lcom/expediagroup/graphql/generator/SchemaGenerator;", "queries", "", "Lcom/expediagroup/graphql/generator/TopLevelObject;", "graphql-kotlin-schema-generator"})
@SourceDebugExtension(value={"SMAP\ngenerateQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 generateQuery.kt\ncom/expediagroup/graphql/generator/internal/types/GenerateQueryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1855#2,2:55\n1855#2,2:57\n*S KotlinDebug\n*F\n+ 1 generateQuery.kt\ncom/expediagroup/graphql/generator/internal/types/GenerateQueryKt\n*L\n37#1:55,2\n42#1:57,2\n*E\n"})
public final class GenerateQueryKt {
    @NotNull
    public static final GraphQLObjectType generateQueries(@NotNull SchemaGenerator generator, @NotNull List<TopLevelObject> queries) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        GraphQLObjectType.Builder queryBuilder = new GraphQLObjectType.Builder();
        queryBuilder.name(generator.getConfig$graphql_kotlin_schema_generator().getTopLevelNames().getQuery());
        for (TopLevelObject query : queries) {
            GraphQLAppliedDirective it;
            if (KClassExtensionsKt.isNotPublic(query.getKClass())) {
                throw new InvalidQueryTypeException(query.getKClass());
            }
            Iterable $this$forEach$iv = GenerateDirectiveKt.generateDirectives$default(generator, (KAnnotatedElement)query.getKClass(), Introspection.DirectiveLocation.OBJECT, null, 8, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (GraphQLAppliedDirective)element$iv;
                boolean bl = false;
                queryBuilder.withAppliedDirective(it);
            }
            $this$forEach$iv = KClassExtensionsKt.getValidFunctions(query.getKClass(), generator.getConfig$graphql_kotlin_schema_generator().getHooks());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KFunction)element$iv;
                boolean bl = false;
                GraphQLFieldDefinition function = GenerateFunctionKt.generateFunction$default(generator, query.getKClass(), (KFunction)it, generator.getConfig$graphql_kotlin_schema_generator().getTopLevelNames().getQuery(), query.getObj(), false, 32, null);
                GraphQLFieldDefinition functionFromHook = generator.getConfig$graphql_kotlin_schema_generator().getHooks().didGenerateQueryField(query.getKClass(), (KFunction<?>)it, function);
                if (queryBuilder.hasField(functionFromHook.getName())) {
                    throw new ConflictingFieldsException("Query(class: " + query.getKClass() + ")", it.getName());
                }
                queryBuilder.field(functionFromHook);
            }
        }
        SchemaGeneratorHooks schemaGeneratorHooks = generator.getConfig$graphql_kotlin_schema_generator().getHooks();
        GraphQLObjectType graphQLObjectType = queryBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLObjectType, (String)"build(...)");
        return schemaGeneratorHooks.didGenerateQueryObject(graphQLObjectType);
    }
}

