/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.generator.internal.types;

import com.expediagroup.graphql.generator.SchemaGenerator;
import com.expediagroup.graphql.generator.directives.DeprecatedDirectiveExtensionsKt;
import com.expediagroup.graphql.generator.exceptions.CouldNotCastGraphQLSchemaElement;
import com.expediagroup.graphql.generator.hooks.SchemaGeneratorHooks;
import com.expediagroup.graphql.generator.internal.extensions.AnnotationExtensionsKt;
import com.expediagroup.graphql.generator.internal.extensions.FieldExtenstionsKt;
import com.expediagroup.graphql.generator.internal.extensions.KClassExtensionsKt;
import com.expediagroup.graphql.generator.internal.types.GenerateDirectiveKt;
import com.expediagroup.graphql.generator.internal.types.utils.ValidateNameKt;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLSchemaElement;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u0000\u001a0\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00062\u0012\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u0002\u00a8\u0006\n"}, d2={"generateEnum", "Lgraphql/schema/GraphQLEnumType;", "generator", "Lcom/expediagroup/graphql/generator/SchemaGenerator;", "kClass", "Lkotlin/reflect/KClass;", "", "getEnumValueDefinition", "Lgraphql/schema/GraphQLEnumValueDefinition;", "enum", "graphql-kotlin-schema-generator"})
public final class GenerateEnumKt {
    @NotNull
    public static final GraphQLEnumType generateEnum(@NotNull SchemaGenerator generator, @NotNull KClass<? extends Enum<?>> kClass) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        String name = KClassExtensionsKt.getSimpleName$default(kClass, false, 1, null);
        ValidateNameKt.validateGraphQLName(name, kClass);
        GraphQLEnumType.Builder enumBuilder = GraphQLEnumType.newEnum();
        enumBuilder.name(name);
        enumBuilder.description(AnnotationExtensionsKt.getGraphQLDescription((KAnnotatedElement)kClass));
        T[] $this$forEach$iv = (T[])GenerateDirectiveKt.generateDirectives$default(generator, (KAnnotatedElement)kClass, Introspection.DirectiveLocation.ENUM, null, 8, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GraphQLAppliedDirective it = (GraphQLAppliedDirective)element$iv;
            boolean bl = false;
            enumBuilder.withAppliedDirective(it);
        }
        T[] TArray = JvmClassMappingKt.getJavaClass(kClass).getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"kClass.java.enumConstants");
        $this$forEach$iv = TArray;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Enum it = (Enum)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            enumBuilder.value(GenerateEnumKt.getEnumValueDefinition(generator, it, kClass));
        }
        SchemaGeneratorHooks schemaGeneratorHooks = generator.getConfig$graphql_kotlin_schema_generator().getHooks();
        GraphQLEnumType graphQLEnumType = enumBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLEnumType, (String)"enumBuilder.build()");
        GraphQLSchemaElement graphQLSchemaElement = (GraphQLSchemaElement)graphQLEnumType;
        GraphQLCodeRegistry.Builder builder = generator.getCodeRegistry$graphql_kotlin_schema_generator();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"generator.codeRegistry");
        GraphQLSchemaElement $this$safeCast$iv = schemaGeneratorHooks.onRewireGraphQLType(graphQLSchemaElement, null, builder);
        boolean $i$f$safeCast = false;
        if (!($this$safeCast$iv instanceof GraphQLEnumType)) {
            throw new CouldNotCastGraphQLSchemaElement($this$safeCast$iv, Reflection.getOrCreateKotlinClass(GraphQLEnumType.class));
        }
        return (GraphQLEnumType)$this$safeCast$iv;
    }

    private static final GraphQLEnumValueDefinition getEnumValueDefinition(SchemaGenerator generator, Enum<?> enum_, KClass<? extends Enum<?>> kClass) {
        GraphQLEnumValueDefinition.Builder valueBuilder = GraphQLEnumValueDefinition.newEnumValueDefinition();
        Field valueField = JvmClassMappingKt.getJavaClass(kClass).getField(enum_.name());
        Intrinsics.checkNotNullExpressionValue((Object)valueField, (String)"valueField");
        String name = FieldExtenstionsKt.getGraphQLName(valueField);
        ValidateNameKt.validateGraphQLEnumValue(name, kClass);
        valueBuilder.name(name);
        valueBuilder.value((Object)name);
        Iterable $this$forEach$iv = GenerateDirectiveKt.generateEnumValueDirectives(generator, valueField, KClassExtensionsKt.getSimpleName$default(kClass, false, 1, null));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GraphQLAppliedDirective it = (GraphQLAppliedDirective)element$iv;
            boolean bl = false;
            valueBuilder.withAppliedDirective(it);
        }
        valueBuilder.description(FieldExtenstionsKt.getGraphQLDescription(valueField));
        String string = FieldExtenstionsKt.getDeprecationReason(valueField);
        if (string != null) {
            String it = string;
            boolean bl = false;
            valueBuilder.deprecationReason(it);
            GraphQLEnumValueDefinition.Builder cfr_ignored_0 = (GraphQLEnumValueDefinition.Builder)valueBuilder.withAppliedDirective(DeprecatedDirectiveExtensionsKt.deprecatedDirectiveWithReason(it));
        }
        SchemaGeneratorHooks schemaGeneratorHooks = generator.getConfig$graphql_kotlin_schema_generator().getHooks();
        GraphQLEnumValueDefinition graphQLEnumValueDefinition = valueBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLEnumValueDefinition, (String)"valueBuilder.build()");
        GraphQLSchemaElement graphQLSchemaElement = (GraphQLSchemaElement)graphQLEnumValueDefinition;
        GraphQLCodeRegistry.Builder builder = generator.getCodeRegistry$graphql_kotlin_schema_generator();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"generator.codeRegistry");
        GraphQLSchemaElement $this$safeCast$iv = schemaGeneratorHooks.onRewireGraphQLType(graphQLSchemaElement, null, builder);
        boolean $i$f$safeCast = false;
        if (!($this$safeCast$iv instanceof GraphQLEnumValueDefinition)) {
            throw new CouldNotCastGraphQLSchemaElement($this$safeCast$iv, Reflection.getOrCreateKotlinClass(GraphQLEnumValueDefinition.class));
        }
        return (GraphQLEnumValueDefinition)$this$safeCast$iv;
    }
}

