/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.generator.internal.types.utils;

import com.expediagroup.graphql.generator.exceptions.InvalidGraphQLEnumValueException;
import com.expediagroup.graphql.generator.exceptions.InvalidGraphQLNameException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0000\u001a\u001c\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\tH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\r"}, d2={"validGraphQLNameRegex", "Lkotlin/text/Regex;", "getValidGraphQLNameRegex", "()Lkotlin/text/Regex;", "validateGraphQLEnumValue", "", "enumValue", "", "enumKClass", "Lkotlin/reflect/KClass;", "validateGraphQLName", "name", "kClass", "graphql-kotlin-schema-generator"})
public final class ValidateNameKt {
    @NotNull
    private static final Regex validGraphQLNameRegex = new Regex("[_A-Za-z][_0-9A-Za-z]*");

    @NotNull
    public static final Regex getValidGraphQLNameRegex() {
        return validGraphQLNameRegex;
    }

    public static final void validateGraphQLName(@NotNull String name, @NotNull KClass<?> kClass) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        CharSequence charSequence = name;
        Regex regex = validGraphQLNameRegex;
        boolean bl = false;
        if (!regex.matches(charSequence)) {
            throw new InvalidGraphQLNameException(kClass, name);
        }
    }

    public static final void validateGraphQLEnumValue(@NotNull String enumValue, @NotNull KClass<?> enumKClass) {
        Intrinsics.checkNotNullParameter((Object)enumValue, (String)"enumValue");
        Intrinsics.checkNotNullParameter(enumKClass, (String)"enumKClass");
        CharSequence charSequence = enumValue;
        Regex regex = validGraphQLNameRegex;
        boolean bl = false;
        if (!regex.matches(charSequence)) {
            throw new InvalidGraphQLEnumValueException(enumKClass, enumValue);
        }
    }
}

