/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.generator.internal.types;

import com.expediagroup.graphql.generator.SchemaGenerator;
import com.expediagroup.graphql.generator.exceptions.CouldNotCastGraphQLSchemaElement;
import com.expediagroup.graphql.generator.exceptions.InvalidInputFieldTypeException;
import com.expediagroup.graphql.generator.hooks.SchemaGeneratorHooks;
import com.expediagroup.graphql.generator.internal.extensions.AnnotationExtensionsKt;
import com.expediagroup.graphql.generator.internal.extensions.KClassExtensionsKt;
import com.expediagroup.graphql.generator.internal.extensions.KParameterExtensionsKt;
import com.expediagroup.graphql.generator.internal.extensions.KTypeExtensionsKt;
import com.expediagroup.graphql.generator.internal.types.GenerateDirectiveKt;
import com.expediagroup.graphql.generator.internal.types.GenerateGraphQLTypeKt;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"generateArgument", "Lgraphql/schema/GraphQLArgument;", "generator", "Lcom/expediagroup/graphql/generator/SchemaGenerator;", "parameter", "Lkotlin/reflect/KParameter;", "getUnwrappedClass", "Lkotlin/reflect/KClass;", "parameterType", "Lkotlin/reflect/KType;", "graphql-kotlin-schema-generator"})
public final class GenerateArgumentKt {
    @NotNull
    public static final GraphQLArgument generateArgument(@NotNull SchemaGenerator generator, @NotNull KParameter parameter) throws InvalidInputFieldTypeException {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        KType inputTypeFromHooks = generator.getConfig$graphql_kotlin_schema_generator().getHooks().willResolveInputMonad(parameter.getType());
        KType unwrappedType = KTypeExtensionsKt.unwrapOptionalInputType(inputTypeFromHooks);
        KClass<?> unwrappedClass = GenerateArgumentKt.getUnwrappedClass(unwrappedType);
        if (KClassExtensionsKt.isUnion(unwrappedClass) || KClassExtensionsKt.isInterface(unwrappedClass)) {
            throw (Throwable)new InvalidInputFieldTypeException(parameter);
        }
        GraphQLType graphQLType = GenerateGraphQLTypeKt.generateGraphQLType(generator, unwrappedType, true);
        GraphQLSchemaElement $this$safeCast$iv = (GraphQLSchemaElement)graphQLType;
        boolean $i$f$safeCast = false;
        if (!($this$safeCast$iv instanceof GraphQLInputType)) {
            throw (Throwable)new CouldNotCastGraphQLSchemaElement($this$safeCast$iv, Reflection.getOrCreateKotlinClass(GraphQLInputType.class));
        }
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument().name(KParameterExtensionsKt.getName(parameter)).description(AnnotationExtensionsKt.getGraphQLDescription((KAnnotatedElement)parameter)).type((GraphQLInputType)$this$safeCast$iv);
        Iterable $this$forEach$iv = GenerateDirectiveKt.generateDirectives$default(generator, (KAnnotatedElement)parameter, Introspection.DirectiveLocation.ARGUMENT_DEFINITION, null, 8, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GraphQLDirective it = (GraphQLDirective)element$iv;
            boolean bl = false;
            builder.withDirective(it);
        }
        SchemaGeneratorHooks schemaGeneratorHooks = generator.getConfig$graphql_kotlin_schema_generator().getHooks();
        GraphQLArgument graphQLArgument = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLArgument, (String)"builder.build()");
        GraphQLSchemaElement graphQLSchemaElement = (GraphQLSchemaElement)graphQLArgument;
        GraphQLCodeRegistry.Builder builder2 = generator.getCodeRegistry$graphql_kotlin_schema_generator();
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"generator.codeRegistry");
        $this$safeCast$iv = schemaGeneratorHooks.onRewireGraphQLType(graphQLSchemaElement, null, builder2);
        $i$f$safeCast = false;
        if (!($this$safeCast$iv instanceof GraphQLArgument)) {
            throw (Throwable)new CouldNotCastGraphQLSchemaElement($this$safeCast$iv, Reflection.getOrCreateKotlinClass(GraphQLArgument.class));
        }
        return (GraphQLArgument)$this$safeCast$iv;
    }

    private static final KClass<?> getUnwrappedClass(KType parameterType) {
        return KTypeExtensionsKt.isListType(parameterType) ? KTypeExtensionsKt.getKClass(KTypeExtensionsKt.getWrappedType(parameterType)) : KTypeExtensionsKt.getKClass(parameterType);
    }
}

