/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.generator.state;

import com.expediagroup.graphql.exceptions.ConflictingTypesException;
import com.expediagroup.graphql.exceptions.TypeNotSupportedException;
import com.expediagroup.graphql.generator.extensions.KClassExtensionsKt;
import com.expediagroup.graphql.generator.extensions.KTypeExtensionsKt;
import com.expediagroup.graphql.generator.state.KGraphQLType;
import com.expediagroup.graphql.generator.state.TypesCacheKey;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.full.KClassifiers;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J9\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\r0\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0015\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0002J\u001f\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b%R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/expediagroup/graphql/generator/state/TypesCache;", "Ljava/io/Closeable;", "supportedPackages", "", "", "(Ljava/util/List;)V", "cache", "", "Lcom/expediagroup/graphql/generator/state/KGraphQLType;", "typesUnderConstruction", "", "Lcom/expediagroup/graphql/generator/state/TypesCacheKey;", "buildIfNotUnderConstruction", "Lgraphql/schema/GraphQLType;", "kClass", "Lkotlin/reflect/KClass;", "inputType", "", "build", "Lkotlin/Function1;", "buildIfNotUnderConstruction$graphql_kotlin_schema_generator", "close", "", "doesNotContainGraphQLType", "graphQLType", "Lgraphql/schema/GraphQLNamedType;", "doesNotContainGraphQLType$graphql_kotlin_schema_generator", "get", "cacheKey", "get$graphql_kotlin_schema_generator", "getCacheKeyString", "isTypeNotSupported", "type", "Lkotlin/reflect/KType;", "put", "key", "kGraphQLType", "put$graphql_kotlin_schema_generator", "graphql-kotlin-schema-generator"})
public final class TypesCache
implements Closeable {
    private final Map<String, KGraphQLType> cache;
    private final Set<TypesCacheKey> typesUnderConstruction;
    private final List<String> supportedPackages;

    @Nullable
    public final GraphQLNamedType get$graphql_kotlin_schema_generator(@NotNull TypesCacheKey cacheKey) throws ConflictingTypesException {
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        String string = this.getCacheKeyString(cacheKey);
        if (string == null) {
            return null;
        }
        String cacheKeyString = string;
        KGraphQLType cachedType = this.cache.get(cacheKeyString);
        if (cachedType != null) {
            KClass<?> kClass = KTypeExtensionsKt.getKClass(cacheKey.getType());
            boolean isSameNameButNotSameClass = Intrinsics.areEqual(cachedType.getKClass(), kClass) ^ true;
            if (isSameNameButNotSameClass) {
                throw (Throwable)new ConflictingTypesException(cachedType.getKClass(), kClass);
            }
            return cachedType.getGraphQLType();
        }
        return null;
    }

    @Nullable
    public final KGraphQLType put$graphql_kotlin_schema_generator(@NotNull TypesCacheKey key, @NotNull KGraphQLType kGraphQLType) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)kGraphQLType, (String)"kGraphQLType");
        String cacheKey = this.getCacheKeyString(key);
        if (cacheKey != null) {
            this.cache.put(cacheKey, kGraphQLType);
            return kGraphQLType;
        }
        return null;
    }

    @Override
    public void close() {
        this.cache.clear();
        this.typesUnderConstruction.clear();
    }

    public final boolean doesNotContainGraphQLType$graphql_kotlin_schema_generator(@NotNull GraphQLNamedType graphQLType) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)graphQLType, (String)"graphQLType");
            Map<String, KGraphQLType> $this$none$iv = this.cache;
            boolean $i$f$none = false;
            if ($this$none$iv.isEmpty()) {
                bl = true;
            } else {
                Map<String, KGraphQLType> map2 = $this$none$iv;
                boolean bl2 = false;
                Iterator<Map.Entry<String, KGraphQLType>> iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, KGraphQLType> element$iv;
                    Map.Entry<String, KGraphQLType> $dstr$_u24__u24$v = element$iv = iterator.next();
                    boolean bl3 = false;
                    Map.Entry<String, KGraphQLType> entry = $dstr$_u24__u24$v;
                    boolean bl4 = false;
                    KGraphQLType v = entry.getValue();
                    if (!Intrinsics.areEqual((Object)v.getGraphQLType().getName(), (Object)graphQLType.getName())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final String getCacheKeyString(TypesCacheKey cacheKey) {
        String string;
        KType type = cacheKey.getType();
        KClass<?> kClass = KTypeExtensionsKt.getKClass(type);
        if (KClassExtensionsKt.isListType(kClass)) {
            string = null;
        } else if (KClasses.isSubclassOf(kClass, (KClass)Reflection.getOrCreateKotlinClass(Enum.class))) {
            string = KClassExtensionsKt.getSimpleName$default(kClass, false, 1, null);
        } else {
            if (this.isTypeNotSupported(type)) {
                throw (Throwable)new TypeNotSupportedException(type, this.supportedPackages);
            }
            string = KTypeExtensionsKt.getSimpleName(type, cacheKey.getInputType());
        }
        return string;
    }

    private final boolean isTypeNotSupported(KType type) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.supportedPackages;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)KTypeExtensionsKt.getQualifiedName(type), (String)it, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final GraphQLType buildIfNotUnderConstruction$graphql_kotlin_schema_generator(@NotNull KClass<?> kClass, boolean inputType, @NotNull Function1<? super KClass<?>, ? extends GraphQLType> build) {
        GraphQLType graphQLType;
        Intrinsics.checkParameterIsNotNull(kClass, (String)"kClass");
        Intrinsics.checkParameterIsNotNull(build, (String)"build");
        if (KClassExtensionsKt.isListType(kClass)) {
            return (GraphQLType)build.invoke(kClass);
        }
        TypesCacheKey cacheKey = new TypesCacheKey(KClassifiers.getStarProjectedType((KClassifier)((KClassifier)kClass)), inputType);
        GraphQLNamedType cachedType = this.get$graphql_kotlin_schema_generator(cacheKey);
        if (cachedType != null) {
            graphQLType = (GraphQLType)cachedType;
        } else if (this.typesUnderConstruction.contains(cacheKey)) {
            GraphQLTypeReference graphQLTypeReference = GraphQLTypeReference.typeRef((String)KClassExtensionsKt.getSimpleName(kClass, inputType));
            Intrinsics.checkExpressionValueIsNotNull((Object)graphQLTypeReference, (String)"GraphQLTypeReference.typ\u2026getSimpleName(inputType))");
            graphQLType = (GraphQLType)graphQLTypeReference;
        } else {
            this.typesUnderConstruction.add(cacheKey);
            GraphQLType newType = (GraphQLType)build.invoke(kClass);
            if (!(newType instanceof GraphQLTypeReference) && newType instanceof GraphQLNamedType) {
                this.put$graphql_kotlin_schema_generator(cacheKey, new KGraphQLType(kClass, (GraphQLNamedType)newType));
            }
            this.typesUnderConstruction.remove(cacheKey);
            graphQLType = newType;
        }
        return graphQLType;
    }

    public TypesCache(@NotNull List<String> supportedPackages) {
        Intrinsics.checkParameterIsNotNull(supportedPackages, (String)"supportedPackages");
        this.supportedPackages = supportedPackages;
        TypesCache typesCache = this;
        boolean bl = false;
        Object object = new LinkedHashMap();
        typesCache.cache = object;
        typesCache = this;
        bl = false;
        typesCache.typesUnderConstruction = object = (Set)new LinkedHashSet();
    }
}

