/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.gradle.tasks;

import com.expediagroup.graphql.plugin.gradle.actions.GenerateClientAction;
import com.expediagroup.graphql.plugin.gradle.config.GraphQLParserOptions;
import com.expediagroup.graphql.plugin.gradle.config.GraphQLScalar;
import com.expediagroup.graphql.plugin.gradle.config.GraphQLSerializer;
import com.expediagroup.graphql.plugin.gradle.parameters.GenerateClientParameters;
import com.expediagroup.graphql.plugin.gradle.tasks.AbstractGenerateClientTask;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FileTreeWalk;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010(\u001a\u00020)H\u0007J\b\u0010*\u001a\u00020+H'J\u001e\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020/0.H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0007R\u0013\u0010\u0017\u001a\u00020\u00188G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0016\u0010\u001d\u001a\u00020\u00188\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u0016\u0010\u001f\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0007R\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0007\u00a8\u00060"}, d2={"Lcom/expediagroup/graphql/plugin/gradle/tasks/AbstractGenerateClientTask;", "Lorg/gradle/api/DefaultTask;", "()V", "allowDeprecatedFields", "Lorg/gradle/api/provider/Property;", "", "getAllowDeprecatedFields", "()Lorg/gradle/api/provider/Property;", "customScalars", "Lorg/gradle/api/provider/ListProperty;", "Lcom/expediagroup/graphql/plugin/gradle/config/GraphQLScalar;", "getCustomScalars", "()Lorg/gradle/api/provider/ListProperty;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "packageName", "", "getPackageName", "parserOptions", "Lcom/expediagroup/graphql/plugin/gradle/config/GraphQLParserOptions;", "getParserOptions", "pluginClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPluginClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "queryFileDirectory", "getQueryFileDirectory", "queryFiles", "getQueryFiles", "schemaFile", "Lorg/gradle/api/file/RegularFileProperty;", "getSchemaFile", "()Lorg/gradle/api/file/RegularFileProperty;", "serializer", "Lcom/expediagroup/graphql/plugin/gradle/config/GraphQLSerializer;", "getSerializer", "useOptionalInputWrapper", "getUseOptionalInputWrapper", "generateGraphQLClientAction", "", "getWorkerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "logConfiguration", "schemaPath", "", "Ljava/io/File;", "graphql-kotlin-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAbstractGenerateClientTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractGenerateClientTask.kt\ncom/expediagroup/graphql/plugin/gradle/tasks/AbstractGenerateClientTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n1855#2,2:212\n1855#2,2:214\n*S KotlinDebug\n*F\n+ 1 AbstractGenerateClientTask.kt\ncom/expediagroup/graphql/plugin/gradle/tasks/AbstractGenerateClientTask\n*L\n195#1:212,2\n202#1:214,2\n*E\n"})
public abstract class AbstractGenerateClientTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileCollection pluginClasspath;
    @InputFile
    @NotNull
    private final RegularFileProperty schemaFile;
    @Input
    @Option(option="packageName", description="target package name to use for generated classes")
    @NotNull
    private final Property<String> packageName;
    @Input
    @Optional
    @Option(option="allowDeprecatedFields", description="boolean flag indicating whether selection of deprecated fields is allowed or not")
    @NotNull
    private final Property<Boolean> allowDeprecatedFields;
    @Input
    @Optional
    @NotNull
    private final ListProperty<GraphQLScalar> customScalars;
    @InputDirectory
    @Optional
    @NotNull
    private final DirectoryProperty queryFileDirectory;
    @InputFiles
    @Optional
    @NotNull
    private final ConfigurableFileCollection queryFiles;
    @Input
    @Optional
    @Option(option="serializer", description="JSON serializer that will be used to generate the data classes.")
    @NotNull
    private final Property<GraphQLSerializer> serializer;
    @Input
    @Optional
    @Option(option="useOptionalInputWrapper", description="Opt-in flag to wrap nullable arguments in OptionalInput that supports both null and undefined.")
    @NotNull
    private final Property<Boolean> useOptionalInputWrapper;
    @Input
    @Optional
    @NotNull
    private final Property<GraphQLParserOptions> parserOptions;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty outputDirectory;

    public AbstractGenerateClientTask() {
        ConfigurableFileCollection configurableFileCollection = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"fileCollection(...)");
        this.pluginClasspath = configurableFileCollection;
        RegularFileProperty regularFileProperty = this.getProject().getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"fileProperty(...)");
        this.schemaFile = regularFileProperty;
        Property property = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(...)");
        this.packageName = property;
        Property property2 = this.getProject().getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(...)");
        this.allowDeprecatedFields = property2;
        ListProperty listProperty = this.getProject().getObjects().listProperty(GraphQLScalar.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(...)");
        this.customScalars = listProperty;
        DirectoryProperty directoryProperty = this.getProject().getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"directoryProperty(...)");
        this.queryFileDirectory = directoryProperty;
        ConfigurableFileCollection configurableFileCollection2 = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"fileCollection(...)");
        this.queryFiles = configurableFileCollection2;
        Property property3 = this.getProject().getObjects().property(GraphQLSerializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(...)");
        this.serializer = property3;
        Property property4 = this.getProject().getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(...)");
        this.useOptionalInputWrapper = property4;
        Property property5 = this.getProject().getObjects().property(GraphQLParserOptions.class);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"property(...)");
        this.parserOptions = property5;
        DirectoryProperty directoryProperty2 = this.getProject().getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty2, (String)"directoryProperty(...)");
        this.outputDirectory = directoryProperty2;
        this.setGroup("GraphQL");
        this.setDescription("Generate HTTP client from the specified GraphQL queries.");
        this.allowDeprecatedFields.convention((Object)false);
        this.customScalars.convention((Iterable)CollectionsKt.emptyList());
        this.serializer.convention((Object)GraphQLSerializer.JACKSON);
        this.useOptionalInputWrapper.convention((Object)false);
        this.parserOptions.convention((Object)new GraphQLParserOptions(null, null, null, null, null, null, null, 127, null));
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    @NotNull
    public final RegularFileProperty getSchemaFile() {
        return this.schemaFile;
    }

    @NotNull
    public final Property<String> getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final Property<Boolean> getAllowDeprecatedFields() {
        return this.allowDeprecatedFields;
    }

    @NotNull
    public final ListProperty<GraphQLScalar> getCustomScalars() {
        return this.customScalars;
    }

    @NotNull
    public final DirectoryProperty getQueryFileDirectory() {
        return this.queryFileDirectory;
    }

    @NotNull
    public final ConfigurableFileCollection getQueryFiles() {
        return this.queryFiles;
    }

    @NotNull
    public final Property<GraphQLSerializer> getSerializer() {
        return this.serializer;
    }

    @NotNull
    public final Property<Boolean> getUseOptionalInputWrapper() {
        return this.useOptionalInputWrapper;
    }

    @NotNull
    public final Property<GraphQLParserOptions> getParserOptions() {
        return this.parserOptions;
    }

    @NotNull
    public final DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TaskAction
    public final void generateGraphQLClientAction() {
        List list;
        this.getLogger().debug("generating GraphQL client");
        if (!this.schemaFile.isPresent()) {
            throw new RuntimeException("schema not available");
        }
        String graphQLSchemaPath = ((RegularFile)this.schemaFile.get()).getAsFile().getPath();
        String string = (String)this.packageName.getOrNull();
        if (string == null) {
            throw new RuntimeException("package not specified");
        }
        String targetPackage = string;
        Set set = this.queryFiles.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
        if (!((Collection)set).isEmpty()) {
            Set set2 = this.queryFiles.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getFiles(...)");
            list = CollectionsKt.toList((Iterable)set2);
        } else {
            List list2;
            Sequence sequence;
            FileTreeWalk fileTreeWalk;
            if (!this.queryFileDirectory.isPresent()) throw new RuntimeException("no query files found");
            File file = (File)this.queryFileDirectory.getAsFile().getOrNull();
            if (file == null || (fileTreeWalk = FilesKt.walkBottomUp((File)file)) == null || (sequence = SequencesKt.filter((Sequence)((Sequence)fileTreeWalk), (Function1)generateGraphQLClientAction.targetQueryFiles.1.INSTANCE)) == null || (list2 = SequencesKt.toList((Sequence)sequence)) == null) throw new RuntimeException("exception while looking up the query files");
            list = list2;
        }
        List targetQueryFiles2 = list;
        if (targetQueryFiles2.isEmpty()) {
            throw new RuntimeException("no query files specified");
        }
        File file = ((Directory)this.outputDirectory.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        File targetDirectory = file;
        if (!targetDirectory.isDirectory() && !targetDirectory.mkdirs()) {
            throw new RuntimeException("failed to generate generated source directory = " + targetDirectory);
        }
        Intrinsics.checkNotNull((Object)graphQLSchemaPath);
        this.logConfiguration(graphQLSchemaPath, targetQueryFiles2);
        WorkQueue workQueue2 = this.getWorkerExecutor().classLoaderIsolation(arg_0 -> AbstractGenerateClientTask.generateGraphQLClientAction$lambda$0((Function1)new Function1<ClassLoaderWorkerSpec, Unit>(this){
            final /* synthetic */ AbstractGenerateClientTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ClassLoaderWorkerSpec workerSpec) {
                Intrinsics.checkNotNullParameter((Object)workerSpec, (String)"workerSpec");
                Object[] objectArray = new Object[]{this.this$0.getPluginClasspath()};
                workerSpec.getClasspath().from(objectArray);
                Logger logger = this.this$0.getLogger();
                Set set = workerSpec.getClasspath().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
                logger.debug("worker classpath: \n" + CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"classLoaderIsolation(...)");
        WorkQueue workQueue3 = workQueue2;
        workQueue3.submit(GenerateClientAction.class, arg_0 -> AbstractGenerateClientTask.generateGraphQLClientAction$lambda$1((Function1)new Function1<GenerateClientParameters, Unit>(targetPackage, this, graphQLSchemaPath, (List<? extends File>)targetQueryFiles2, targetDirectory){
            final /* synthetic */ String $targetPackage;
            final /* synthetic */ AbstractGenerateClientTask this$0;
            final /* synthetic */ String $graphQLSchemaPath;
            final /* synthetic */ List<File> $targetQueryFiles;
            final /* synthetic */ File $targetDirectory;
            {
                this.$targetPackage = $targetPackage;
                this.this$0 = $receiver;
                this.$graphQLSchemaPath = $graphQLSchemaPath;
                this.$targetQueryFiles = $targetQueryFiles;
                this.$targetDirectory = $targetDirectory;
                super(1);
            }

            public final void invoke(@NotNull GenerateClientParameters parameters) {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                parameters.getPackageName().set((Object)this.$targetPackage);
                parameters.getAllowDeprecated().set((Provider)this.this$0.getAllowDeprecatedFields());
                parameters.getCustomScalars().set((Provider)this.this$0.getCustomScalars());
                parameters.getSerializer().set((Provider)this.this$0.getSerializer());
                parameters.getSchemaPath().set((Object)this.$graphQLSchemaPath);
                parameters.getQueryFiles().set((Iterable)this.$targetQueryFiles);
                parameters.getTargetDirectory().set((Object)this.$targetDirectory);
                parameters.getUseOptionalInputWrapper().set((Provider)this.this$0.getUseOptionalInputWrapper());
                parameters.getParserOptions().set((Provider)this.this$0.getParserOptions());
            }
        }, arg_0));
        workQueue3.await();
        this.getLogger().debug("successfully generated GraphQL HTTP client");
    }

    private final void logConfiguration(String schemaPath, List<? extends File> queryFiles) {
        this.getLogger().debug("GraphQL Client generator configuration:");
        this.getLogger().debug("  schema file = " + schemaPath);
        this.getLogger().debug("  queries");
        Iterable $this$forEach$iv = queryFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.getLogger().debug("    - " + it.getName());
        }
        this.getLogger().debug("  packageName = " + this.packageName);
        this.getLogger().debug("  allowDeprecatedFields = " + this.allowDeprecatedFields);
        this.getLogger().debug("  parserOptions = " + this.parserOptions);
        this.getLogger().debug("  converters");
        Object object = this.customScalars.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$forEach$iv = (Iterable)object;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GraphQLScalar graphQLScalar = (GraphQLScalar)element$iv;
            boolean bl = false;
            String customScalar = graphQLScalar.component1();
            String type = graphQLScalar.component2();
            String converter = graphQLScalar.component3();
            this.getLogger().debug("    - custom scalar = " + customScalar);
            this.getLogger().debug("      |- type = " + type);
            this.getLogger().debug("      |- converter = " + converter);
        }
        this.getLogger().debug("");
        this.getLogger().debug("-- end GraphQL Client generator configuration --");
    }

    private static final void generateGraphQLClientAction$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke(p0);
    }

    private static final void generateGraphQLClientAction$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke(p0);
    }
}

