/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.gradle;

import com.expediagroup.graphql.plugin.gradle.GraphQLGradlePlugin;
import com.expediagroup.graphql.plugin.gradle.GraphQLPluginExtension;
import com.expediagroup.graphql.plugin.gradle.ProjectExtensionsKt;
import com.expediagroup.graphql.plugin.gradle.config.TimeoutConfiguration;
import com.expediagroup.graphql.plugin.gradle.tasks.GraphQLDownloadSDLTask;
import com.expediagroup.graphql.plugin.gradle.tasks.GraphQLGenerateClientTask;
import com.expediagroup.graphql.plugin.gradle.tasks.GraphQLGenerateSDLTask;
import com.expediagroup.graphql.plugin.gradle.tasks.GraphQLGenerateTestClientTask;
import com.expediagroup.graphql.plugin.gradle.tasks.GraphQLGraalVmMetadataTask;
import com.expediagroup.graphql.plugin.gradle.tasks.GraphQLIntrospectSchemaTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\"\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/expediagroup/graphql/plugin/gradle/GraphQLGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "configureDefaultProjectSourceSet", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "targetSourceSet", "", "configurePluginDependencies", "configureTasks", "processExtensionConfiguration", "extension", "Lcom/expediagroup/graphql/plugin/gradle/GraphQLPluginExtension;", "registerTasks", "graphql-kotlin-gradle-plugin"})
public final class GraphQLGradlePlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.configurePluginDependencies(project);
        this.registerTasks(project);
        Object object = project.getExtensions().create("graphql", GraphQLPluginExtension.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.creat\u2026ginExtension::class.java)");
        GraphQLPluginExtension extension = (GraphQLPluginExtension)object;
        project.afterEvaluate(arg_0 -> GraphQLGradlePlugin.apply$lambda$0((Function1)new Function1<Project, Unit>(this, project, extension){
            final /* synthetic */ GraphQLGradlePlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ GraphQLPluginExtension $extension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$extension = $extension;
                super(1);
            }

            public final void invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GraphQLGradlePlugin.access$processExtensionConfiguration(this.this$0, this.$project, this.$extension);
                GraphQLGradlePlugin.access$configureTasks(this.this$0, this.$project);
            }
        }, arg_0));
    }

    private final void configurePluginDependencies(Project project) {
        project.getConfigurations().create("graphqlClient", arg_0 -> GraphQLGradlePlugin.configurePluginDependencies$lambda$1((Function1)new Function1<Configuration, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull Configuration configuration) {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                configuration.setVisible(true);
                configuration.setTransitive(true);
                configuration.setDescription("Configuration for generating GraphQL client");
                configuration.getDependencies().add((Object)this.$project.getDependencies().create((Object)"com.expediagroup:graphql-kotlin-client-generator:7.4.0"));
            }
        }, arg_0));
        project.getConfigurations().create("graphqlSDL", arg_0 -> GraphQLGradlePlugin.configurePluginDependencies$lambda$2((Function1)new Function1<Configuration, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull Configuration configuration) {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                configuration.setVisible(true);
                configuration.setTransitive(true);
                configuration.setDescription("Configuration for generating GraphQL schema in SDL format");
                configuration.getDependencies().add((Object)this.$project.getDependencies().create((Object)"com.expediagroup:graphql-kotlin-sdl-generator:7.4.0"));
            }
        }, arg_0));
        project.getConfigurations().create("graphqlGraalVM", arg_0 -> GraphQLGradlePlugin.configurePluginDependencies$lambda$3((Function1)new Function1<Configuration, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull Configuration configuration) {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                configuration.setVisible(true);
                configuration.setTransitive(true);
                configuration.setDescription("Configuration for generating GraalVM reflect metadata");
                configuration.getDependencies().add((Object)this.$project.getDependencies().create((Object)"com.expediagroup:graphql-kotlin-graalvm-metadata-generator:7.4.0"));
            }
        }, arg_0));
    }

    private final void registerTasks(Project project) {
        project.getTasks().register("graphqlDownloadSDL", GraphQLDownloadSDLTask.class);
        project.getTasks().register("graphqlGenerateClient", GraphQLGenerateClientTask.class);
        project.getTasks().register("graphqlGenerateTestClient", GraphQLGenerateTestClientTask.class);
        project.getTasks().register("graphqlGenerateSDL", GraphQLGenerateSDLTask.class);
        project.getTasks().register("graphqlIntrospectSchema", GraphQLIntrospectSchemaTask.class);
        project.getTasks().register("graphqLGraalVmMetadata", GraphQLGraalVmMetadataTask.class);
        if (project.getPlugins().hasPlugin("org.graalvm.buildtools.native")) {
            Object object = ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).create("graphqlGraalVm");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.getBy\u2026.create(\"graphqlGraalVm\")");
            SourceSet graphQLGraalVmSource = (SourceSet)object;
            project.getTasks().withType(Jar.class).configureEach(arg_0 -> GraphQLGradlePlugin.registerTasks$lambda$4((Function1)new Function1<Jar, Unit>(graphQLGraalVmSource){
                final /* synthetic */ SourceSet $graphQLGraalVmSource;
                {
                    this.$graphQLGraalVmSource = $graphQLGraalVmSource;
                    super(1);
                }

                public final void invoke(@NotNull Jar jarTask) {
                    Intrinsics.checkNotNullParameter((Object)jarTask, (String)"jarTask");
                    Object[] objectArray = new Object[]{this.$graphQLGraalVmSource.getRuntimeClasspath()};
                    jarTask.from(objectArray);
                }
            }, arg_0));
        }
    }

    private final void processExtensionConfiguration(Project project, GraphQLPluginExtension extension) {
        block12: {
            List<String> supportedPackages;
            if (extension.isClientConfigurationAvailable$graphql_kotlin_gradle_plugin() && extension.getClientExtension$graphql_kotlin_gradle_plugin().getPackageName() != null) {
                Object object = project.getTasks().named("graphqlGenerateClient", GraphQLGenerateClientTask.class).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.tasks.named(GENE\u2026ntTask::class.java).get()");
                GraphQLGenerateClientTask generateClientTask = (GraphQLGenerateClientTask)((Object)object);
                generateClientTask.getPackageName().convention(project.provider(() -> GraphQLGradlePlugin.processExtensionConfiguration$lambda$5(extension)));
                generateClientTask.getAllowDeprecatedFields().convention(project.provider(() -> GraphQLGradlePlugin.processExtensionConfiguration$lambda$6(extension)));
                generateClientTask.getCustomScalars().convention((Iterable)extension.getClientExtension$graphql_kotlin_gradle_plugin().getCustomScalars());
                String queryFileDirectory = extension.getClientExtension$graphql_kotlin_gradle_plugin().getQueryFileDirectory();
                if (queryFileDirectory != null) {
                    generateClientTask.getQueryFileDirectory().set(new File(queryFileDirectory));
                }
                generateClientTask.getQueryFiles().setFrom((Iterable)extension.getClientExtension$graphql_kotlin_gradle_plugin().getQueryFiles());
                generateClientTask.getSerializer().convention((Object)extension.getClientExtension$graphql_kotlin_gradle_plugin().getSerializer());
                generateClientTask.getUseOptionalInputWrapper().convention((Object)extension.getClientExtension$graphql_kotlin_gradle_plugin().getUseOptionalInputWrapper());
                generateClientTask.getParserOptions().convention((Object)extension.getClientExtension$graphql_kotlin_gradle_plugin().getParserOptions$graphql_kotlin_gradle_plugin());
                if (extension.getClientExtension$graphql_kotlin_gradle_plugin().getEndpoint() != null) {
                    Object object2 = project.getTasks().named("graphqlIntrospectSchema", GraphQLIntrospectSchemaTask.class).get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.tasks.named(INTR\u2026maTask::class.java).get()");
                    GraphQLIntrospectSchemaTask introspectSchemaTask = (GraphQLIntrospectSchemaTask)((Object)object2);
                    introspectSchemaTask.getEndpoint().convention(project.provider(() -> GraphQLGradlePlugin.processExtensionConfiguration$lambda$7(extension)));
                    introspectSchemaTask.getHeaders().convention(project.provider(() -> GraphQLGradlePlugin.processExtensionConfiguration$lambda$8(extension)));
                    introspectSchemaTask.getTimeoutConfig().convention(project.provider(() -> GraphQLGradlePlugin.processExtensionConfiguration$lambda$9(extension)));
                    Object[] objectArray = new Object[]{introspectSchemaTask.getPath()};
                    generateClientTask.dependsOn(objectArray);
                    generateClientTask.getSchemaFile().convention((Provider)introspectSchemaTask.getOutputFile());
                } else if (extension.getClientExtension$graphql_kotlin_gradle_plugin().getSdlEndpoint() != null) {
                    Object object3 = project.getTasks().named("graphqlDownloadSDL", GraphQLDownloadSDLTask.class).get();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"project.tasks.named(DOWN\u2026DLTask::class.java).get()");
                    GraphQLDownloadSDLTask downloadSDLTask = (GraphQLDownloadSDLTask)((Object)object3);
                    downloadSDLTask.getEndpoint().convention(project.provider(() -> GraphQLGradlePlugin.processExtensionConfiguration$lambda$10(extension)));
                    downloadSDLTask.getHeaders().convention(project.provider(() -> GraphQLGradlePlugin.processExtensionConfiguration$lambda$11(extension)));
                    downloadSDLTask.getTimeoutConfig().convention(project.provider(() -> GraphQLGradlePlugin.processExtensionConfiguration$lambda$12(extension)));
                    Object[] objectArray = new Object[]{downloadSDLTask.getPath()};
                    generateClientTask.dependsOn(objectArray);
                    generateClientTask.getSchemaFile().convention((Provider)downloadSDLTask.getOutputFile());
                } else if (extension.getClientExtension$graphql_kotlin_gradle_plugin().getSchemaFile() != null) {
                    generateClientTask.getSchemaFile().set(extension.getClientExtension$graphql_kotlin_gradle_plugin().getSchemaFile());
                } else {
                    throw new RuntimeException("Invalid GraphQL client extension configuration - missing required endpoint/sdlEndpoint/schemaFileName property");
                }
            }
            if (extension.isSchemaConfigurationAvailable$graphql_kotlin_gradle_plugin()) {
                supportedPackages = extension.getSchemaExtension$graphql_kotlin_gradle_plugin().getPackages();
                if (supportedPackages.isEmpty()) {
                    throw new RuntimeException("Invalid GraphQL schema extension configuration - missing required supportedPackages property");
                }
                Object object = project.getTasks().named("graphqlGenerateSDL", GraphQLGenerateSDLTask.class).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.tasks.named(GENE\u2026DLTask::class.java).get()");
                GraphQLGenerateSDLTask generateSchemaTask = (GraphQLGenerateSDLTask)((Object)object);
                generateSchemaTask.getPackages().set((Iterable)supportedPackages);
            }
            if (!extension.isGraalVmConfigurationAvailable$graphql_kotlin_gradle_plugin()) break block12;
            supportedPackages = extension.getGraalVmExtension$graphql_kotlin_gradle_plugin().getPackages();
            if (supportedPackages.isEmpty()) {
                throw new RuntimeException("Invalid GraphQL graalVm extension configuration - missing required supportedPackages property");
            }
            Object object = project.getTasks().named("graphqLGraalVmMetadata", GraphQLGraalVmMetadataTask.class).get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.tasks.named(GRAA\u2026taTask::class.java).get()");
            GraphQLGraalVmMetadataTask graalVmMetadataTask = (GraphQLGraalVmMetadataTask)((Object)object);
            graalVmMetadataTask.getPackages().set((Iterable)supportedPackages);
            String string = extension.getGraalVmExtension$graphql_kotlin_gradle_plugin().getMainClassName();
            if (string != null) {
                String it = string;
                boolean bl = false;
                graalVmMetadataTask.getMainClassName().set((Object)it);
            }
        }
    }

    private final void configureTasks(Project project) {
        boolean isAndroidProject = project.getPlugins().hasPlugin("com.android.application") || project.getPlugins().hasPlugin("com.android.library");
        List clientGeneratingTaskNames = new ArrayList();
        List testClientGeneratingTaskNames = new ArrayList();
        project.getTasks().withType(GraphQLDownloadSDLTask.class).configureEach(arg_0 -> GraphQLGradlePlugin.configureTasks$lambda$14((Function1)new Function1<GraphQLDownloadSDLTask, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull GraphQLDownloadSDLTask downloadSDLTask) {
                Intrinsics.checkNotNullParameter((Object)((Object)downloadSDLTask), (String)"downloadSDLTask");
                Configuration configuration = this.$project.getConfigurations().getAt("graphqlClient");
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026ATE_CLIENT_CONFIGURATION)");
                Configuration configuration2 = configuration;
                downloadSDLTask.getPluginClasspath().setFrom((Iterable)configuration2);
            }
        }, arg_0));
        project.getTasks().withType(GraphQLGenerateClientTask.class).configureEach(arg_0 -> GraphQLGradlePlugin.configureTasks$lambda$15((Function1)new Function1<GraphQLGenerateClientTask, Unit>((List<GraphQLGenerateClientTask>)clientGeneratingTaskNames, project, isAndroidProject, this){
            final /* synthetic */ List<GraphQLGenerateClientTask> $clientGeneratingTaskNames;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $isAndroidProject;
            final /* synthetic */ GraphQLGradlePlugin this$0;
            {
                this.$clientGeneratingTaskNames = $clientGeneratingTaskNames;
                this.$project = $project;
                this.$isAndroidProject = $isAndroidProject;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull GraphQLGenerateClientTask generateClientTask) {
                Intrinsics.checkNotNullParameter((Object)((Object)generateClientTask), (String)"generateClientTask");
                this.$clientGeneratingTaskNames.add(generateClientTask);
                Configuration configuration = this.$project.getConfigurations().getAt("graphqlClient");
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026ATE_CLIENT_CONFIGURATION)");
                Configuration configuration2 = configuration;
                generateClientTask.getPluginClasspath().setFrom((Iterable)configuration2);
                if (!this.$isAndroidProject) {
                    GraphQLGradlePlugin.configureDefaultProjectSourceSet$default(this.this$0, this.$project, generateClientTask.getOutputDirectory(), null, 4, null);
                }
            }
        }, arg_0));
        project.getTasks().withType(GraphQLGenerateTestClientTask.class).configureEach(arg_0 -> GraphQLGradlePlugin.configureTasks$lambda$16((Function1)new Function1<GraphQLGenerateTestClientTask, Unit>((List<GraphQLGenerateTestClientTask>)testClientGeneratingTaskNames, project, isAndroidProject, this){
            final /* synthetic */ List<GraphQLGenerateTestClientTask> $testClientGeneratingTaskNames;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $isAndroidProject;
            final /* synthetic */ GraphQLGradlePlugin this$0;
            {
                this.$testClientGeneratingTaskNames = $testClientGeneratingTaskNames;
                this.$project = $project;
                this.$isAndroidProject = $isAndroidProject;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull GraphQLGenerateTestClientTask generateTestClientTask) {
                Intrinsics.checkNotNullParameter((Object)((Object)generateTestClientTask), (String)"generateTestClientTask");
                this.$testClientGeneratingTaskNames.add(generateTestClientTask);
                Configuration configuration = this.$project.getConfigurations().getAt("graphqlClient");
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026ATE_CLIENT_CONFIGURATION)");
                Configuration configuration2 = configuration;
                generateTestClientTask.getPluginClasspath().setFrom((Iterable)configuration2);
                if (!this.$isAndroidProject) {
                    GraphQLGradlePlugin.access$configureDefaultProjectSourceSet(this.this$0, this.$project, generateTestClientTask.getOutputDirectory(), "test");
                }
            }
        }, arg_0));
        project.getTasks().withType(GraphQLIntrospectSchemaTask.class).configureEach(arg_0 -> GraphQLGradlePlugin.configureTasks$lambda$17((Function1)new Function1<GraphQLIntrospectSchemaTask, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull GraphQLIntrospectSchemaTask introspectionTask) {
                Intrinsics.checkNotNullParameter((Object)((Object)introspectionTask), (String)"introspectionTask");
                Configuration configuration = this.$project.getConfigurations().getAt("graphqlClient");
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026ATE_CLIENT_CONFIGURATION)");
                Configuration configuration2 = configuration;
                introspectionTask.getPluginClasspath().setFrom((Iterable)configuration2);
            }
        }, arg_0));
        project.getTasks().withType(GraphQLGenerateSDLTask.class).configureEach(arg_0 -> GraphQLGradlePlugin.configureTasks$lambda$18((Function1)new Function1<GraphQLGenerateSDLTask, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull GraphQLGenerateSDLTask generateSDLTask) {
                Task compileKotlinTask;
                SourceSetContainer sourceSetContainer;
                Intrinsics.checkNotNullParameter((Object)((Object)generateSDLTask), (String)"generateSDLTask");
                Object object = this.$project.findProperty("sourceSets");
                SourceSetContainer sourceSetContainer2 = sourceSetContainer = object instanceof SourceSetContainer ? (SourceSetContainer)object : null;
                SourceSet mainSourceSet = sourceSetContainer2 != null ? (SourceSet)sourceSetContainer2.findByName("main") : null;
                Object[] objectArray = new Object[1];
                SourceSet sourceSet = mainSourceSet;
                objectArray[0] = sourceSet != null ? sourceSet.getOutput() : null;
                generateSDLTask.source(objectArray);
                objectArray = new Object[1];
                SourceSet sourceSet2 = mainSourceSet;
                objectArray[0] = sourceSet2 != null ? sourceSet2.getRuntimeClasspath() : null;
                generateSDLTask.getProjectClasspath().setFrom(objectArray);
                Configuration configuration = this.$project.getConfigurations().getAt("graphqlSDL");
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026NERATE_SDL_CONFIGURATION)");
                Configuration configuration2 = configuration;
                generateSDLTask.getPluginClasspath().setFrom((Iterable)configuration2);
                Task task = (Task)this.$project.getTasks().findByName("compileKotlin");
                if (task == null) {
                    task = (Task)this.$project.getTasks().findByName("compileKotlinJvm");
                }
                if ((compileKotlinTask = task) != null) {
                    Object[] objectArray2 = new Object[]{compileKotlinTask};
                    generateSDLTask.dependsOn(objectArray2);
                } else {
                    this.$project.getLogger().warn("compileKotlin/compileKotlinJvm tasks not found. Unable to auto-configure the generateSDLTask dependency on compile task.");
                }
            }
        }, arg_0));
        if (isAndroidProject) {
            ProjectExtensionsKt.configureAndroidCompileTasks(project, clientGeneratingTaskNames, testClientGeneratingTaskNames);
        }
        if (project.getPlugins().hasPlugin("org.graalvm.buildtools.native")) {
            project.getTasks().withType(GraphQLGraalVmMetadataTask.class).configureEach(arg_0 -> GraphQLGradlePlugin.configureTasks$lambda$19((Function1)new Function1<GraphQLGraalVmMetadataTask, Unit>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(1);
                }

                public final void invoke(@NotNull GraphQLGraalVmMetadataTask graalVmMetadataTask) {
                    Task compileKotlinTask;
                    Task task;
                    Object[] mainClass;
                    Object[] javaApplication;
                    Intrinsics.checkNotNullParameter((Object)((Object)graalVmMetadataTask), (String)"graalVmMetadataTask");
                    if (this.$project.getPlugins().hasPlugin("application")) {
                        Object[] objectArray = (Object[])this.$project.getExtensions().findByType(JavaApplication.class);
                        if (objectArray != null) {
                            javaApplication = objectArray;
                            boolean bl = false;
                            Object[] objectArray2 = (Object[])javaApplication.getMainClass().getOrNull();
                            if (objectArray2 != null) {
                                mainClass = objectArray2;
                                boolean bl2 = false;
                                graalVmMetadataTask.getMainClassName().convention((Object)mainClass);
                            }
                        }
                    }
                    if ((task = (Task)this.$project.getTasks().findByName("compileKotlin")) == null) {
                        task = (Task)this.$project.getTasks().findByName("compileKotlinJvm");
                    }
                    if ((compileKotlinTask = task) != null) {
                        Object[] objectArray = new Object[]{compileKotlinTask};
                        graalVmMetadataTask.dependsOn(objectArray);
                    } else {
                        this.$project.getLogger().warn("compileKotlin/compileKotlinJvm tasks not found. Unable to auto-configure the generateSDLTask dependency on compile task.");
                    }
                    Task task2 = (Task)this.$project.getTasks().findByName("nativeCompile");
                    if (task2 != null) {
                        javaApplication = new Object[]{graalVmMetadataTask};
                        task2.dependsOn(javaApplication);
                    }
                    Object object = this.$project.getExtensions().getByType(SourceSetContainer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.getBy\u2026SetContainer::class.java)");
                    SourceSetContainer sourceSetContainer = (SourceSetContainer)object;
                    Object object2 = sourceSetContainer.getByName("graphqlGraalVm");
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"sourceSetContainer.getByName(\"graphqlGraalVm\")");
                    SourceSet graalVmSource = (SourceSet)object2;
                    graalVmSource.resources(arg_0 -> configureTasks.6.invoke$lambda$2((Function1)new Function1<SourceDirectorySet, Unit>(graalVmMetadataTask){
                        final /* synthetic */ GraphQLGraalVmMetadataTask $graalVmMetadataTask;
                        {
                            this.$graalVmMetadataTask = $graalVmMetadataTask;
                            super(1);
                        }

                        public final void invoke(@NotNull SourceDirectorySet it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            it.setSrcDirs((Iterable)CollectionsKt.listOf((Object)this.$graalVmMetadataTask.getOutputDirectory()));
                        }
                    }, arg_0));
                    Object object3 = sourceSetContainer.getByName("main");
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"sourceSetContainer.getByName(\"main\")");
                    SourceSet mainSourceSet = (SourceSet)object3;
                    mainClass = new Object[]{mainSourceSet.getOutput()};
                    graalVmMetadataTask.source(mainClass);
                    graalVmMetadataTask.getProjectClasspath().setFrom((Iterable)mainSourceSet.getRuntimeClasspath());
                    Configuration configuration = this.$project.getConfigurations().getAt("graphqlGraalVM");
                    Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026M_METADATA_CONFIGURATION)");
                    Configuration configuration2 = configuration;
                    graalVmMetadataTask.getPluginClasspath().setFrom((Iterable)configuration2);
                }

                private static final void invoke$lambda$2(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke(p0);
                }
            }, arg_0));
        }
    }

    private final void configureDefaultProjectSourceSet(Project project, DirectoryProperty outputDirectory, String targetSourceSet) {
        block0: {
            Object object = project.findProperty("sourceSets");
            SourceSetContainer sourceSetContainer = object instanceof SourceSetContainer ? (SourceSetContainer)object : null;
            SourceSetContainer sourceSetContainer2 = sourceSetContainer;
            if (sourceSetContainer2 == null || (sourceSetContainer2 = (SourceSet)sourceSetContainer2.findByName(targetSourceSet)) == null || (sourceSetContainer2 = sourceSetContainer2.getJava()) == null) break block0;
            sourceSetContainer2.srcDir((Object)outputDirectory);
        }
    }

    static /* synthetic */ void configureDefaultProjectSourceSet$default(GraphQLGradlePlugin graphQLGradlePlugin, Project project, DirectoryProperty directoryProperty, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "main";
        }
        graphQLGradlePlugin.configureDefaultProjectSourceSet(project, directoryProperty, string);
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configurePluginDependencies$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configurePluginDependencies$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configurePluginDependencies$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void registerTasks$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final String processExtensionConfiguration$lambda$5(GraphQLPluginExtension $extension) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        return $extension.getClientExtension$graphql_kotlin_gradle_plugin().getPackageName();
    }

    private static final Boolean processExtensionConfiguration$lambda$6(GraphQLPluginExtension $extension) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        return $extension.getClientExtension$graphql_kotlin_gradle_plugin().getAllowDeprecatedFields();
    }

    private static final String processExtensionConfiguration$lambda$7(GraphQLPluginExtension $extension) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        return $extension.getClientExtension$graphql_kotlin_gradle_plugin().getEndpoint();
    }

    private static final Map processExtensionConfiguration$lambda$8(GraphQLPluginExtension $extension) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        return $extension.getClientExtension$graphql_kotlin_gradle_plugin().getHeaders();
    }

    private static final TimeoutConfiguration processExtensionConfiguration$lambda$9(GraphQLPluginExtension $extension) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        return $extension.getClientExtension$graphql_kotlin_gradle_plugin().getTimeoutConfig$graphql_kotlin_gradle_plugin();
    }

    private static final String processExtensionConfiguration$lambda$10(GraphQLPluginExtension $extension) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        return $extension.getClientExtension$graphql_kotlin_gradle_plugin().getSdlEndpoint();
    }

    private static final Map processExtensionConfiguration$lambda$11(GraphQLPluginExtension $extension) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        return $extension.getClientExtension$graphql_kotlin_gradle_plugin().getHeaders();
    }

    private static final TimeoutConfiguration processExtensionConfiguration$lambda$12(GraphQLPluginExtension $extension) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        return $extension.getClientExtension$graphql_kotlin_gradle_plugin().getTimeoutConfig$graphql_kotlin_gradle_plugin();
    }

    private static final void configureTasks$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureTasks$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureTasks$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureTasks$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureTasks$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureTasks$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$processExtensionConfiguration(GraphQLGradlePlugin $this, Project project, GraphQLPluginExtension extension) {
        $this.processExtensionConfiguration(project, extension);
    }

    public static final /* synthetic */ void access$configureTasks(GraphQLGradlePlugin $this, Project project) {
        $this.configureTasks(project);
    }

    public static final /* synthetic */ void access$configureDefaultProjectSourceSet(GraphQLGradlePlugin $this, Project project, DirectoryProperty outputDirectory, String targetSourceSet) {
        $this.configureDefaultProjectSourceSet(project, outputDirectory, targetSourceSet);
    }
}

