/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.gradle.tasks;

import com.expediagroup.graphql.plugin.gradle.actions.IntrospectSchemaAction;
import com.expediagroup.graphql.plugin.gradle.config.TimeoutConfiguration;
import com.expediagroup.graphql.plugin.gradle.parameters.IntrospectSchemaParameters;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH'J\b\u0010\u001d\u001a\u00020\u001eH\u0007R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u00020\u00128G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lcom/expediagroup/graphql/plugin/gradle/tasks/GraphQLIntrospectSchemaTask;", "Lorg/gradle/api/DefaultTask;", "()V", "endpoint", "Lorg/gradle/api/provider/Property;", "", "getEndpoint", "()Lorg/gradle/api/provider/Property;", "headers", "Lorg/gradle/api/provider/MapProperty;", "", "getHeaders", "()Lorg/gradle/api/provider/MapProperty;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "pluginClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPluginClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "streamResponse", "", "getStreamResponse", "timeoutConfig", "Lcom/expediagroup/graphql/plugin/gradle/config/TimeoutConfiguration;", "getTimeoutConfig", "getWorkerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "introspectSchemaAction", "", "graphql-kotlin-gradle-plugin"})
public abstract class GraphQLIntrospectSchemaTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileCollection pluginClasspath;
    @Input
    @Option(option="endpoint", description="target GraphQL endpoint")
    @NotNull
    private final Property<String> endpoint;
    @Input
    @NotNull
    private final MapProperty<String, Object> headers;
    @Input
    @NotNull
    private final Property<TimeoutConfiguration> timeoutConfig;
    @Input
    @NotNull
    private final Property<Boolean> streamResponse;
    @OutputFile
    @NotNull
    private final RegularFileProperty outputFile;

    public GraphQLIntrospectSchemaTask() {
        ConfigurableFileCollection configurableFileCollection = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.fileCollection()");
        this.pluginClasspath = configurableFileCollection;
        Property property = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.objects.property(String::class.java)");
        this.endpoint = property;
        MapProperty mapProperty = this.getProject().getObjects().mapProperty(String.class, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)mapProperty, (String)"project.objects.mapPrope\u2026ss.java, Any::class.java)");
        this.headers = mapProperty;
        Property property2 = this.getProject().getObjects().property(TimeoutConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"project.objects.property\u2026onfiguration::class.java)");
        this.timeoutConfig = property2;
        Property property3 = this.getProject().getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"project.objects.property(Boolean::class.java)");
        this.streamResponse = property3;
        RegularFileProperty regularFileProperty = this.getProject().getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"project.objects.fileProperty()");
        this.outputFile = regularFileProperty;
        this.setGroup("GraphQL");
        this.setDescription("Run introspection query against target GraphQL endpoint and save schema locally.");
        this.headers.convention(MapsKt.emptyMap());
        this.streamResponse.convention((Object)true);
        this.timeoutConfig.convention((Object)new TimeoutConfiguration(0L, 0L, 3, null));
        this.outputFile.convention(this.getProject().getLayout().getBuildDirectory().file("schema.graphql"));
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    @NotNull
    public final Property<String> getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public final MapProperty<String, Object> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Property<TimeoutConfiguration> getTimeoutConfig() {
        return this.timeoutConfig;
    }

    @NotNull
    public final Property<Boolean> getStreamResponse() {
        return this.streamResponse;
    }

    @NotNull
    public final RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    public final void introspectSchemaAction() {
        Object object = this.outputFile.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputFile.asFile.get()");
        File schemaFile = (File)object;
        File targetDirectory = schemaFile.getParentFile();
        if (!targetDirectory.isDirectory() && !targetDirectory.mkdirs()) {
            throw new RuntimeException("failed to generate target schema directory = " + targetDirectory);
        }
        WorkQueue workQueue2 = this.getWorkerExecutor().classLoaderIsolation(arg_0 -> GraphQLIntrospectSchemaTask.introspectSchemaAction$lambda$0((Function1)new Function1<ClassLoaderWorkerSpec, Unit>(this){
            final /* synthetic */ GraphQLIntrospectSchemaTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ClassLoaderWorkerSpec workerSpec) {
                Intrinsics.checkNotNullParameter((Object)workerSpec, (String)"workerSpec");
                Object[] objectArray = new Object[]{this.this$0.getPluginClasspath()};
                workerSpec.getClasspath().from(objectArray);
                Logger logger = this.this$0.getLogger();
                Set set = workerSpec.getClasspath().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"workerSpec.classpath.files");
                logger.debug("worker classpath: \n" + CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"@TaskAction\n    fun intr\u2026ed GraphQL schema\")\n    }");
        WorkQueue workQueue3 = workQueue2;
        this.getLogger().debug("submitting work item to introspect schema from " + this.endpoint.get() + " endpoint");
        workQueue3.submit(IntrospectSchemaAction.class, arg_0 -> GraphQLIntrospectSchemaTask.introspectSchemaAction$lambda$1((Function1)new Function1<IntrospectSchemaParameters, Unit>(this, schemaFile){
            final /* synthetic */ GraphQLIntrospectSchemaTask this$0;
            final /* synthetic */ File $schemaFile;
            {
                this.this$0 = $receiver;
                this.$schemaFile = $schemaFile;
                super(1);
            }

            public final void invoke(@NotNull IntrospectSchemaParameters parameters) {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                parameters.getEndpoint().set((Provider)this.this$0.getEndpoint());
                parameters.getHeaders().set((Provider)this.this$0.getHeaders());
                parameters.getTimeoutConfiguration().set((Provider)this.this$0.getTimeoutConfig());
                parameters.getSchemaFile().set((Object)this.$schemaFile);
                parameters.getStreamResponse().set((Provider)this.this$0.getStreamResponse());
            }
        }, arg_0));
        workQueue3.await();
        this.getLogger().debug("successfully introspected GraphQL schema");
    }

    private static final void introspectSchemaAction$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void introspectSchemaAction$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

