/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.gradle.tasks;

import com.expediagroup.graphql.plugin.gradle.actions.GenerateClientAction;
import com.expediagroup.graphql.plugin.gradle.config.GraphQLScalar;
import com.expediagroup.graphql.plugin.gradle.config.GraphQLSerializer;
import com.expediagroup.graphql.plugin.gradle.parameters.GenerateClientParameters;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010%\u001a\u00020&H\u0007J\b\u0010'\u001a\u00020(H'J\u001e\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0013\u0010\u0014\u001a\u00020\u00158G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0016\u0010\u001a\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0016\u0010\u001c\u001a\u00020\u001d8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0007R\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0007\u00a8\u0006-"}, d2={"Lcom/expediagroup/graphql/plugin/gradle/tasks/AbstractGenerateClientTask;", "Lorg/gradle/api/DefaultTask;", "()V", "allowDeprecatedFields", "Lorg/gradle/api/provider/Property;", "", "getAllowDeprecatedFields", "()Lorg/gradle/api/provider/Property;", "customScalars", "Lorg/gradle/api/provider/ListProperty;", "Lcom/expediagroup/graphql/plugin/gradle/config/GraphQLScalar;", "getCustomScalars", "()Lorg/gradle/api/provider/ListProperty;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "packageName", "", "getPackageName", "pluginClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPluginClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "queryFileDirectory", "getQueryFileDirectory", "queryFiles", "getQueryFiles", "schemaFile", "Lorg/gradle/api/file/RegularFileProperty;", "getSchemaFile", "()Lorg/gradle/api/file/RegularFileProperty;", "serializer", "Lcom/expediagroup/graphql/plugin/gradle/config/GraphQLSerializer;", "getSerializer", "useOptionalInputWrapper", "getUseOptionalInputWrapper", "generateGraphQLClientAction", "", "getWorkerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "logConfiguration", "schemaPath", "", "Ljava/io/File;", "graphql-kotlin-gradle-plugin"})
public abstract class AbstractGenerateClientTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileCollection pluginClasspath;
    @InputFile
    @NotNull
    private final RegularFileProperty schemaFile;
    @Input
    @Option(option="packageName", description="target package name to use for generated classes")
    @NotNull
    private final Property<String> packageName;
    @Input
    @Optional
    @Option(option="allowDeprecatedFields", description="boolean flag indicating whether selection of deprecated fields is allowed or not")
    @NotNull
    private final Property<Boolean> allowDeprecatedFields;
    @Input
    @Optional
    @NotNull
    private final ListProperty<GraphQLScalar> customScalars;
    @InputDirectory
    @Optional
    @NotNull
    private final DirectoryProperty queryFileDirectory;
    @InputFiles
    @Optional
    @NotNull
    private final ConfigurableFileCollection queryFiles;
    @Input
    @Optional
    @Option(option="serializer", description="JSON serializer that will be used to generate the data classes.")
    @NotNull
    private final Property<GraphQLSerializer> serializer;
    @Input
    @Optional
    @Option(option="useOptionalInputWrapper", description="Opt-in flag to wrap nullable arguments in OptionalInput that supports both null and undefined.")
    @NotNull
    private final Property<Boolean> useOptionalInputWrapper;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty outputDirectory;

    public AbstractGenerateClientTask() {
        ConfigurableFileCollection configurableFileCollection = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.fileCollection()");
        this.pluginClasspath = configurableFileCollection;
        RegularFileProperty regularFileProperty = this.getProject().getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"project.objects.fileProperty()");
        this.schemaFile = regularFileProperty;
        Property property = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.objects.property(String::class.java)");
        this.packageName = property;
        Property property2 = this.getProject().getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"project.objects.property(Boolean::class.java)");
        this.allowDeprecatedFields = property2;
        ListProperty listProperty = this.getProject().getObjects().listProperty(GraphQLScalar.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"project.objects.listProp\u2026raphQLScalar::class.java)");
        this.customScalars = listProperty;
        DirectoryProperty directoryProperty = this.getProject().getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.objects.directoryProperty()");
        this.queryFileDirectory = directoryProperty;
        ConfigurableFileCollection configurableFileCollection2 = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"project.objects.fileCollection()");
        this.queryFiles = configurableFileCollection2;
        Property property3 = this.getProject().getObjects().property(GraphQLSerializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"project.objects.property\u2026QLSerializer::class.java)");
        this.serializer = property3;
        Property property4 = this.getProject().getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"project.objects.property(Boolean::class.java)");
        this.useOptionalInputWrapper = property4;
        DirectoryProperty directoryProperty2 = this.getProject().getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty2, (String)"project.objects.directoryProperty()");
        this.outputDirectory = directoryProperty2;
        this.setGroup("GraphQL");
        this.setDescription("Generate HTTP client from the specified GraphQL queries.");
        this.allowDeprecatedFields.convention((Object)false);
        this.customScalars.convention((Iterable)CollectionsKt.emptyList());
        this.serializer.convention((Object)GraphQLSerializer.JACKSON);
        this.useOptionalInputWrapper.convention((Object)false);
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    @NotNull
    public final RegularFileProperty getSchemaFile() {
        return this.schemaFile;
    }

    @NotNull
    public final Property<String> getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final Property<Boolean> getAllowDeprecatedFields() {
        return this.allowDeprecatedFields;
    }

    @NotNull
    public final ListProperty<GraphQLScalar> getCustomScalars() {
        return this.customScalars;
    }

    @NotNull
    public final DirectoryProperty getQueryFileDirectory() {
        return this.queryFileDirectory;
    }

    @NotNull
    public final ConfigurableFileCollection getQueryFiles() {
        return this.queryFiles;
    }

    @NotNull
    public final Property<GraphQLSerializer> getSerializer() {
        return this.serializer;
    }

    @NotNull
    public final Property<Boolean> getUseOptionalInputWrapper() {
        return this.useOptionalInputWrapper;
    }

    @NotNull
    public final DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TaskAction
    public final void generateGraphQLClientAction() {
        List list;
        this.getLogger().debug("generating GraphQL client");
        if (!this.schemaFile.isPresent()) {
            throw new RuntimeException("schema not available");
        }
        String graphQLSchemaPath = ((RegularFile)this.schemaFile.get()).getAsFile().getPath();
        String string = (String)this.packageName.getOrNull();
        if (string == null) {
            throw new RuntimeException("package not specified");
        }
        String targetPackage = string;
        Set set = this.queryFiles.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"queryFiles.files");
        if (!((Collection)set).isEmpty()) {
            Set set2 = this.queryFiles.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"queryFiles.files");
            list = CollectionsKt.toList((Iterable)set2);
        } else {
            List list2;
            if (!this.queryFileDirectory.isPresent()) throw new RuntimeException("no query files found");
            Object[] objectArray = ((Directory)this.queryFileDirectory.get()).getAsFile().listFiles(AbstractGenerateClientTask::generateGraphQLClientAction$lambda-0);
            if (objectArray == null || (list2 = ArraysKt.toList((Object[])objectArray)) == null) throw new RuntimeException("exception while looking up the query files");
            list = list2;
        }
        List targetQueryFiles = list;
        if (targetQueryFiles.isEmpty()) {
            throw new RuntimeException("no query files specified");
        }
        File file = ((Directory)this.outputDirectory.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDirectory.get().asFile");
        File targetDirectory = file;
        if (!targetDirectory.isDirectory() && !targetDirectory.mkdirs()) {
            throw new RuntimeException("failed to generate generated source directory = " + targetDirectory);
        }
        Intrinsics.checkNotNullExpressionValue((Object)graphQLSchemaPath, (String)"graphQLSchemaPath");
        this.logConfiguration(graphQLSchemaPath, targetQueryFiles);
        WorkQueue workQueue = this.getWorkerExecutor().classLoaderIsolation(arg_0 -> AbstractGenerateClientTask.generateGraphQLClientAction$lambda-1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)workQueue, (String)"getWorkerExecutor().clas\u2026String(\"\\n\")}\")\n        }");
        WorkQueue workQueue2 = workQueue;
        workQueue2.submit(GenerateClientAction.class, arg_0 -> AbstractGenerateClientTask.generateGraphQLClientAction$lambda-2(targetPackage, this, graphQLSchemaPath, targetQueryFiles, targetDirectory, arg_0));
        workQueue2.await();
        this.getLogger().debug("successfully generated GraphQL HTTP client");
    }

    private final void logConfiguration(String schemaPath, List<? extends File> queryFiles) {
        this.getLogger().debug("GraphQL Client generator configuration:");
        this.getLogger().debug("  schema file = " + schemaPath);
        this.getLogger().debug("  queries");
        Iterable $this$forEach$iv = queryFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.getLogger().debug("    - " + it.getName());
        }
        this.getLogger().debug("  packageName = " + this.packageName);
        this.getLogger().debug("  allowDeprecatedFields = " + this.allowDeprecatedFields);
        this.getLogger().debug("  converters");
        Object object = this.customScalars.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"customScalars.get()");
        $this$forEach$iv = (Iterable)object;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GraphQLScalar graphQLScalar = (GraphQLScalar)element$iv;
            boolean bl = false;
            String customScalar = graphQLScalar.component1();
            String type = graphQLScalar.component2();
            String converter = graphQLScalar.component3();
            this.getLogger().debug("    - custom scalar = " + customScalar);
            this.getLogger().debug("      |- type = " + type);
            this.getLogger().debug("      |- converter = " + converter);
        }
        this.getLogger().debug("");
        this.getLogger().debug("-- end GraphQL Client generator configuration --");
    }

    private static final boolean generateGraphQLClientAction$lambda-0(File file) {
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"graphql");
    }

    private static final void generateGraphQLClientAction$lambda-1(AbstractGenerateClientTask this$0, ClassLoaderWorkerSpec workerSpec) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)workerSpec, (String)"workerSpec");
        Object[] objectArray = new Object[]{this$0.pluginClasspath};
        workerSpec.getClasspath().from(objectArray);
        Logger logger = this$0.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("worker classpath: \n");
        Set set = workerSpec.getClasspath().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"workerSpec.classpath.files");
        logger.debug(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString());
    }

    private static final void generateGraphQLClientAction$lambda-2(String $targetPackage, AbstractGenerateClientTask this$0, String $graphQLSchemaPath, List $targetQueryFiles, File $targetDirectory, GenerateClientParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)$targetPackage, (String)"$targetPackage");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$targetQueryFiles, (String)"$targetQueryFiles");
        Intrinsics.checkNotNullParameter((Object)$targetDirectory, (String)"$targetDirectory");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        parameters.getPackageName().set((Object)$targetPackage);
        parameters.getAllowDeprecated().set((Provider)this$0.allowDeprecatedFields);
        parameters.getCustomScalars().set((Provider)this$0.customScalars);
        parameters.getSerializer().set((Provider)this$0.serializer);
        parameters.getSchemaPath().set((Object)$graphQLSchemaPath);
        parameters.getQueryFiles().set((Iterable)$targetQueryFiles);
        parameters.getTargetDirectory().set((Object)$targetDirectory);
        parameters.getUseOptionalInputWrapper().set((Provider)this$0.useOptionalInputWrapper);
    }
}

