/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.gradle.tasks;

import com.expediagroup.graphql.plugin.gradle.actions.IntrospectSchemaAction;
import com.expediagroup.graphql.plugin.gradle.config.TimeoutConfiguration;
import com.expediagroup.graphql.plugin.gradle.parameters.RetrieveSchemaParameters;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H'J\b\u0010\u001a\u001a\u00020\u001bH\u0007R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u00020\u00128G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/expediagroup/graphql/plugin/gradle/tasks/GraphQLIntrospectSchemaTask;", "Lorg/gradle/api/DefaultTask;", "()V", "endpoint", "Lorg/gradle/api/provider/Property;", "", "getEndpoint", "()Lorg/gradle/api/provider/Property;", "headers", "Lorg/gradle/api/provider/MapProperty;", "", "getHeaders", "()Lorg/gradle/api/provider/MapProperty;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "pluginClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPluginClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "timeoutConfig", "Lcom/expediagroup/graphql/plugin/gradle/config/TimeoutConfiguration;", "getTimeoutConfig", "getWorkerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "introspectSchemaAction", "", "graphql-kotlin-gradle-plugin"})
public abstract class GraphQLIntrospectSchemaTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileCollection pluginClasspath;
    @Input
    @Option(option="endpoint", description="target GraphQL endpoint")
    @NotNull
    private final Property<String> endpoint;
    @Input
    @NotNull
    private final MapProperty<String, Object> headers;
    @Input
    @NotNull
    private final Property<TimeoutConfiguration> timeoutConfig;
    @OutputFile
    @NotNull
    private final RegularFileProperty outputFile;

    public GraphQLIntrospectSchemaTask() {
        ConfigurableFileCollection configurableFileCollection = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.fileCollection()");
        this.pluginClasspath = configurableFileCollection;
        configurableFileCollection = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.property(String::class.java)");
        this.endpoint = configurableFileCollection;
        configurableFileCollection = this.getProject().getObjects().mapProperty(String.class, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.mapPrope\u2026ss.java, Any::class.java)");
        this.headers = configurableFileCollection;
        configurableFileCollection = this.getProject().getObjects().property(TimeoutConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.property\u2026onfiguration::class.java)");
        this.timeoutConfig = configurableFileCollection;
        configurableFileCollection = this.getProject().getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.fileProperty()");
        this.outputFile = configurableFileCollection;
        this.setGroup("GraphQL");
        this.setDescription("Run introspection query against target GraphQL endpoint and save schema locally.");
        this.headers.convention(MapsKt.emptyMap());
        this.timeoutConfig.convention((Object)new TimeoutConfiguration(0L, 0L, 3, null));
        this.outputFile.convention(this.getProject().getLayout().getBuildDirectory().file("schema.graphql"));
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    @NotNull
    public final Property<String> getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public final MapProperty<String, Object> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Property<TimeoutConfiguration> getTimeoutConfig() {
        return this.timeoutConfig;
    }

    @NotNull
    public final RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    public final void introspectSchemaAction() {
        Object object = this.outputFile.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputFile.asFile.get()");
        File schemaFile = (File)object;
        File targetDirectory = schemaFile.getParentFile();
        if (!targetDirectory.isDirectory() && !targetDirectory.mkdirs()) {
            throw new RuntimeException(Intrinsics.stringPlus((String)"failed to generate target schema directory = ", (Object)targetDirectory));
        }
        WorkQueue workQueue = this.getWorkerExecutor().classLoaderIsolation(arg_0 -> GraphQLIntrospectSchemaTask.introspectSchemaAction$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)workQueue, (String)"getWorkerExecutor().clas\u2026String(\"\\n\")}\")\n        }");
        WorkQueue workQueue2 = workQueue;
        this.getLogger().debug("submitting work item to introspect schema from " + (String)this.endpoint.get() + " endpoint");
        workQueue2.submit(IntrospectSchemaAction.class, arg_0 -> GraphQLIntrospectSchemaTask.introspectSchemaAction$lambda-1(this, schemaFile, arg_0));
        workQueue2.await();
        this.getLogger().debug("successfully introspected GraphQL schema");
    }

    private static final void introspectSchemaAction$lambda-0(GraphQLIntrospectSchemaTask this$0, ClassLoaderWorkerSpec workerSpec) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)workerSpec, (String)"workerSpec");
        Object object = new Object[]{this$0.getPluginClasspath()};
        workerSpec.getClasspath().from(object);
        Logger logger = this$0.getLogger();
        object = workerSpec.getClasspath().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"workerSpec.classpath.files");
        logger.debug(Intrinsics.stringPlus((String)"worker classpath: \n", (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)));
    }

    private static final void introspectSchemaAction$lambda-1(GraphQLIntrospectSchemaTask this$0, File $schemaFile, RetrieveSchemaParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$schemaFile, (String)"$schemaFile");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        parameters.getEndpoint().set((Provider)this$0.getEndpoint());
        parameters.getHeaders().set((Provider)this$0.getHeaders());
        parameters.getTimeoutConfiguration().set((Provider)this$0.getTimeoutConfig());
        parameters.getSchemaFile().set((Object)$schemaFile);
    }
}

