/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.client.generator.types;

import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorContext;
import com.expediagroup.graphql.plugin.client.generator.exceptions.UnknownGraphQLTypeException;
import com.expediagroup.graphql.plugin.client.generator.extensions.DocumentExtensionsKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLCustomScalarTypeAliasKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLCustomScalarTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLEnumTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLInputObjectTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLInterfaceTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLObjectTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLUnionTypeSpecKt;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeAliasSpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import graphql.Scalars;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ListType;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.UnionTypeDefinition;
import graphql.schema.GraphQLScalarType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a0\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0002H\u0002\u001a4\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0000\u001a(\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00112\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00022\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0002*\u00020\nH\u0002\u00a8\u0006\u0019"}, d2={"calculateSelectedFields", "", "", "context", "Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGeneratorContext;", "targetType", "selectionSet", "Lgraphql/language/SelectionSet;", "path", "generateClassName", "Lcom/squareup/kotlinpoet/ClassName;", "graphQLType", "Lgraphql/language/NamedNode;", "nameOverride", "generateCustomClassName", "generateTypeName", "Lcom/squareup/kotlinpoet/TypeName;", "Lgraphql/language/Type;", "isCachedTypeApplicable", "", "graphQLTypeName", "graphQLTypeDefinition", "Lgraphql/language/TypeDefinition;", "verifySelectionSet", "simpleNameWithoutWrapper", "graphql-kotlin-client-generator"})
public final class GenerateTypeNameKt {
    @NotNull
    public static final TypeName generateTypeName(@NotNull GraphQLClientGeneratorContext context, @NotNull Type<?> graphQLType, @Nullable SelectionSet selectionSet) {
        TypeName typeName;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(graphQLType, (String)"graphQLType");
        boolean nullable = !(graphQLType instanceof NonNullType);
        Type<?> type = graphQLType;
        if (type instanceof NonNullType) {
            Type type2 = ((NonNullType)graphQLType).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"graphQLType.type");
            typeName = GenerateTypeNameKt.generateTypeName(context, type2, selectionSet);
        } else if (type instanceof NamedNode) {
            ClassName className;
            String string = ((NamedNode)graphQLType).getName();
            GraphQLScalarType graphQLScalarType = Scalars.GraphQLString;
            Intrinsics.checkNotNullExpressionValue((Object)graphQLScalarType, (String)"Scalars.GraphQLString");
            if (Intrinsics.areEqual((Object)string, (Object)graphQLScalarType.getName())) {
                className = TypeNames.STRING;
            } else {
                GraphQLScalarType graphQLScalarType2 = Scalars.GraphQLInt;
                Intrinsics.checkNotNullExpressionValue((Object)graphQLScalarType2, (String)"Scalars.GraphQLInt");
                if (Intrinsics.areEqual((Object)string, (Object)graphQLScalarType2.getName())) {
                    className = TypeNames.INT;
                } else {
                    GraphQLScalarType graphQLScalarType3 = Scalars.GraphQLFloat;
                    Intrinsics.checkNotNullExpressionValue((Object)graphQLScalarType3, (String)"Scalars.GraphQLFloat");
                    if (Intrinsics.areEqual((Object)string, (Object)graphQLScalarType3.getName())) {
                        className = TypeNames.FLOAT;
                    } else {
                        GraphQLScalarType graphQLScalarType4 = Scalars.GraphQLBoolean;
                        Intrinsics.checkNotNullExpressionValue((Object)graphQLScalarType4, (String)"Scalars.GraphQLBoolean");
                        className = Intrinsics.areEqual((Object)string, (Object)graphQLScalarType4.getName()) ? TypeNames.BOOLEAN : GenerateTypeNameKt.generateCustomClassName(context, (NamedNode)graphQLType, selectionSet);
                    }
                }
            }
            typeName = (TypeName)className;
        } else if (type instanceof ListType) {
            TypeName[] typeNameArray = new TypeName[1];
            Type type3 = ((ListType)graphQLType).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"graphQLType.type");
            typeNameArray[0] = GenerateTypeNameKt.generateTypeName(context, type3, selectionSet);
            typeName = (TypeName)ParameterizedTypeName.Companion.get(TypeNames.LIST, typeNameArray);
        } else {
            throw (Throwable)new UnknownGraphQLTypeException((Node)graphQLType);
        }
        return TypeName.copy$default((TypeName)typeName, (boolean)nullable, null, (int)2, null);
    }

    public static /* synthetic */ TypeName generateTypeName$default(GraphQLClientGeneratorContext graphQLClientGeneratorContext, Type type, SelectionSet selectionSet, int n, Object object) {
        if ((n & 4) != 0) {
            selectionSet = null;
        }
        return GenerateTypeNameKt.generateTypeName(graphQLClientGeneratorContext, type, selectionSet);
    }

    @NotNull
    public static final ClassName generateCustomClassName(@NotNull GraphQLClientGeneratorContext context, @NotNull NamedNode<?> graphQLType, @Nullable SelectionSet selectionSet) {
        ClassName className;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(graphQLType, (String)"graphQLType");
        Object t = context.getGraphQLSchema().getType(graphQLType.getName()).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"context.graphQLSchema.ge\u2026e(graphQLType.name).get()");
        TypeDefinition graphQLTypeDefinition = (TypeDefinition)t;
        String graphQLTypeName = graphQLTypeDefinition.getName();
        List<ClassName> cachedTypeNames = context.getClassNameCache().get(graphQLTypeName);
        if (cachedTypeNames == null || cachedTypeNames.isEmpty()) {
            if (graphQLTypeDefinition instanceof ScalarTypeDefinition && context.getCustomScalarMap().get(graphQLTypeName) == null) {
                TypeAliasSpec typeAlias = GenerateGraphQLCustomScalarTypeAliasKt.generateGraphQLCustomScalarTypeAlias(context, (ScalarTypeDefinition)graphQLTypeDefinition);
                ClassName className2 = new ClassName(context.getPackageName(), new String[]{typeAlias.getName()});
                Map<String, List<ClassName>> map = context.getClassNameCache();
                String string = graphQLTypeName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"graphQLTypeName");
                map.put(string, CollectionsKt.mutableListOf((Object[])new ClassName[]{className2}));
                className = className2;
            } else {
                ClassName className3 = GenerateTypeNameKt.generateClassName$default(context, (NamedNode)graphQLTypeDefinition, selectionSet, null, 8, null);
                TypeDefinition className2 = graphQLTypeDefinition;
                if (className2 instanceof ObjectTypeDefinition) {
                    GenerateGraphQLObjectTypeSpecKt.generateGraphQLObjectTypeSpec$default(context, (ObjectTypeDefinition)graphQLTypeDefinition, selectionSet, null, 8, null);
                } else if (className2 instanceof InputObjectTypeDefinition) {
                    GenerateGraphQLInputObjectTypeSpecKt.generateGraphQLInputObjectTypeSpec(context, (InputObjectTypeDefinition)graphQLTypeDefinition);
                } else if (className2 instanceof EnumTypeDefinition) {
                    GenerateGraphQLEnumTypeSpecKt.generateGraphQLEnumTypeSpec(context, (EnumTypeDefinition)graphQLTypeDefinition);
                } else if (className2 instanceof InterfaceTypeDefinition) {
                    GenerateGraphQLInterfaceTypeSpecKt.generateGraphQLInterfaceTypeSpec$default(context, (InterfaceTypeDefinition)graphQLTypeDefinition, selectionSet, null, 8, null);
                } else if (className2 instanceof UnionTypeDefinition) {
                    GenerateGraphQLUnionTypeSpecKt.generateGraphQLUnionTypeSpec$default(context, (UnionTypeDefinition)graphQLTypeDefinition, selectionSet, null, 8, null);
                } else if (className2 instanceof ScalarTypeDefinition) {
                    GenerateGraphQLCustomScalarTypeSpecKt.generateGraphQLCustomScalarTypeSpec(context, (ScalarTypeDefinition)graphQLTypeDefinition);
                } else {
                    throw (Throwable)new UnknownGraphQLTypeException((Node)graphQLType);
                }
                className = className3;
            }
        } else if (selectionSet == null) {
            className = (ClassName)CollectionsKt.first(cachedTypeNames);
        } else {
            for (ClassName cachedType : cachedTypeNames) {
                if (!GenerateTypeNameKt.isCachedTypeApplicable(context, GenerateTypeNameKt.simpleNameWithoutWrapper(cachedType), graphQLTypeDefinition, selectionSet)) continue;
                return cachedType;
            }
            String overriddenName = graphQLTypeName + (cachedTypeNames.size() + 1);
            ClassName className2 = GenerateTypeNameKt.generateClassName(context, (NamedNode)graphQLTypeDefinition, selectionSet, overriddenName);
            TypeDefinition typeDefinition = graphQLTypeDefinition;
            if (typeDefinition instanceof ObjectTypeDefinition) {
                GenerateGraphQLObjectTypeSpecKt.generateGraphQLObjectTypeSpec(context, (ObjectTypeDefinition)graphQLTypeDefinition, selectionSet, overriddenName);
            } else if (typeDefinition instanceof InterfaceTypeDefinition) {
                GenerateGraphQLInterfaceTypeSpecKt.generateGraphQLInterfaceTypeSpec(context, (InterfaceTypeDefinition)graphQLTypeDefinition, selectionSet, overriddenName);
            } else if (typeDefinition instanceof UnionTypeDefinition) {
                GenerateGraphQLUnionTypeSpecKt.generateGraphQLUnionTypeSpec(context, (UnionTypeDefinition)graphQLTypeDefinition, selectionSet, overriddenName);
            } else {
                throw (Throwable)new UnknownGraphQLTypeException((Node)graphQLType);
            }
            className = className2;
        }
        return className;
    }

    public static /* synthetic */ ClassName generateCustomClassName$default(GraphQLClientGeneratorContext graphQLClientGeneratorContext, NamedNode namedNode, SelectionSet selectionSet, int n, Object object) {
        if ((n & 4) != 0) {
            selectionSet = null;
        }
        return GenerateTypeNameKt.generateCustomClassName(graphQLClientGeneratorContext, namedNode, selectionSet);
    }

    @NotNull
    public static final ClassName generateClassName(@NotNull GraphQLClientGeneratorContext context, @NotNull NamedNode<?> graphQLType, @Nullable SelectionSet selectionSet, @Nullable String nameOverride) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(graphQLType, (String)"graphQLType");
        String string = nameOverride;
        if (string == null) {
            string = graphQLType.getName();
        }
        String typeName = string;
        ClassName className = new ClassName(context.getPackageName(), new String[]{context.getRootType() + '.' + typeName});
        Map<String, List<ClassName>> map = context.getClassNameCache();
        String string2 = graphQLType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"graphQLType.name");
        boolean bl = false;
        List<ClassName> classNames = map.getOrDefault(string2, new ArrayList());
        classNames.add(className);
        Map<String, List<ClassName>> map2 = context.getClassNameCache();
        String string3 = graphQLType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"graphQLType.name");
        map2.put(string3, classNames);
        if (selectionSet != null) {
            String string4 = typeName;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"typeName");
            Set selectedFields = GenerateTypeNameKt.calculateSelectedFields$default(context, string4, selectionSet, null, 8, null);
            context.getTypeToSelectionSetMap().put(typeName, selectedFields);
        }
        return className;
    }

    public static /* synthetic */ ClassName generateClassName$default(GraphQLClientGeneratorContext graphQLClientGeneratorContext, NamedNode namedNode, SelectionSet selectionSet, String string, int n, Object object) {
        if ((n & 4) != 0) {
            selectionSet = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        return GenerateTypeNameKt.generateClassName(graphQLClientGeneratorContext, namedNode, selectionSet, string);
    }

    private static final String simpleNameWithoutWrapper(ClassName $this$simpleNameWithoutWrapper) {
        return StringsKt.substringAfter$default((String)$this$simpleNameWithoutWrapper.getSimpleName(), (String)".", null, (int)2, null);
    }

    private static final boolean isCachedTypeApplicable(GraphQLClientGeneratorContext context, String graphQLTypeName, TypeDefinition<?> graphQLTypeDefinition, SelectionSet selectionSet) {
        TypeDefinition<?> typeDefinition = graphQLTypeDefinition;
        return typeDefinition instanceof UnionTypeDefinition ? GenerateTypeNameKt.verifySelectionSet(context, graphQLTypeName, selectionSet) : (typeDefinition instanceof InterfaceTypeDefinition ? GenerateTypeNameKt.verifySelectionSet(context, graphQLTypeName, selectionSet) : (typeDefinition instanceof ObjectTypeDefinition ? GenerateTypeNameKt.verifySelectionSet(context, graphQLTypeName, selectionSet) : true));
    }

    private static final boolean verifySelectionSet(GraphQLClientGeneratorContext context, String graphQLTypeName, SelectionSet selectionSet) {
        Set selectedFields = GenerateTypeNameKt.calculateSelectedFields$default(context, graphQLTypeName, selectionSet, null, 8, null);
        Set<String> cachedTypeFields = context.getTypeToSelectionSetMap().get(graphQLTypeName);
        return Intrinsics.areEqual((Object)selectedFields, cachedTypeFields);
    }

    private static final Set<String> calculateSelectedFields(GraphQLClientGeneratorContext context, String targetType, SelectionSet selectionSet, String path) {
        boolean bl = false;
        Set result = new LinkedHashSet();
        List list = selectionSet.getSelections();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"selectionSet.selections");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Selection selection = (Selection)element$iv;
            boolean bl2 = false;
            Selection selection2 = selection;
            if (selection2 instanceof Field) {
                result.add(path + ((Field)selection).getName());
                if (((Field)selection).getSelectionSet() == null) continue;
                SelectionSet selectionSet2 = ((Field)selection).getSelectionSet();
                Intrinsics.checkNotNullExpressionValue((Object)selectionSet2, (String)"selection.selectionSet");
                result.addAll((Collection)GenerateTypeNameKt.calculateSelectedFields(context, targetType, selectionSet2, path + ((Field)selection).getName() + '.'));
                continue;
            }
            if (selection2 instanceof InlineFragment) {
                graphql.language.TypeName typeName = ((InlineFragment)selection).getTypeCondition();
                Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"selection.typeCondition");
                String targetFragmentType = typeName.getName();
                String fragmentPathPrefix = Intrinsics.areEqual((Object)targetFragmentType, (Object)targetType) ? path : path + targetFragmentType + '.';
                SelectionSet selectionSet3 = ((InlineFragment)selection).getSelectionSet();
                Intrinsics.checkNotNullExpressionValue((Object)selectionSet3, (String)"selection.selectionSet");
                result.addAll((Collection)GenerateTypeNameKt.calculateSelectedFields(context, targetType, selectionSet3, fragmentPathPrefix));
                continue;
            }
            if (!(selection2 instanceof FragmentSpread)) continue;
            Document document = context.getQueryDocument();
            String string = ((FragmentSpread)selection).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selection.name");
            FragmentDefinition fragmentDefinition = DocumentExtensionsKt.findFragmentDefinition(document, context, string, targetType);
            graphql.language.TypeName typeName = fragmentDefinition.getTypeCondition();
            Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"fragmentDefinition.typeCondition");
            String targetFragmentType = typeName.getName();
            String fragmentPathPrefix = Intrinsics.areEqual((Object)targetFragmentType, (Object)targetType) ? path : path + targetFragmentType + '.';
            SelectionSet selectionSet4 = fragmentDefinition.getSelectionSet();
            Intrinsics.checkNotNullExpressionValue((Object)selectionSet4, (String)"fragmentDefinition.selectionSet");
            result.addAll((Collection)GenerateTypeNameKt.calculateSelectedFields(context, targetType, selectionSet4, fragmentPathPrefix));
        }
        return result;
    }

    static /* synthetic */ Set calculateSelectedFields$default(GraphQLClientGeneratorContext graphQLClientGeneratorContext, String string, SelectionSet selectionSet, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "";
        }
        return GenerateTypeNameKt.calculateSelectedFields(graphQLClientGeneratorContext, string, selectionSet, string2);
    }
}

