/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.client.generator;

import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGenerator$WhenMappings;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorConfig;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorContext;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorKt;
import com.expediagroup.graphql.plugin.client.generator.exceptions.MultipleOperationsInFileException;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLObjectTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateVariableTypeSpecKt;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.LambdaTypeName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeAliasSpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import graphql.language.Document;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.parser.Parser;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.ktor.client.request.HttpRequestBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGenerator;", "", "graphQLSchema", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "config", "Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGeneratorConfig;", "(Lgraphql/schema/idl/TypeDefinitionRegistry;Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGeneratorConfig;)V", "documentParser", "Lgraphql/parser/Parser;", "typeAliases", "", "", "Lcom/squareup/kotlinpoet/TypeAliasSpec;", "findRootType", "Lgraphql/language/ObjectTypeDefinition;", "operationDefinition", "Lgraphql/language/OperationDefinition;", "generate", "Lcom/squareup/kotlinpoet/FileSpec;", "queryFile", "Ljava/io/File;", "generate$graphql_kotlin_client_generator", "", "queries", "graphql-kotlin-client-generator"})
public final class GraphQLClientGenerator {
    private final Parser documentParser;
    private final Map<String, TypeAliasSpec> typeAliases;
    private final TypeDefinitionRegistry graphQLSchema;
    private final GraphQLClientGeneratorConfig config;

    @NotNull
    public final List<FileSpec> generate(@NotNull List<? extends File> queries) {
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        boolean bl = false;
        List result = new ArrayList();
        for (File file : queries) {
            result.add(this.generate$graphql_kotlin_client_generator(file));
        }
        Map<String, TypeAliasSpec> map = this.typeAliases;
        boolean bl2 = false;
        if (!map.isEmpty()) {
            FileSpec.Builder builder = FileSpec.Companion.builder(this.config.getPackageName(), "GraphQLTypeAliases");
            Map<String, TypeAliasSpec> $this$forEach$iv = this.typeAliases;
            boolean $i$f$forEach = false;
            Map<String, TypeAliasSpec> map2 = $this$forEach$iv;
            boolean bl3 = false;
            Iterator<Map.Entry<String, TypeAliasSpec>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, TypeAliasSpec> element$iv;
                Map.Entry<String, TypeAliasSpec> $dstr$_u24__u24$alias = element$iv = iterator.next();
                boolean bl4 = false;
                Map.Entry<String, TypeAliasSpec> entry = $dstr$_u24__u24$alias;
                boolean bl5 = false;
                TypeAliasSpec alias = entry.getValue();
                builder.addTypeAlias(alias);
            }
            result.add(builder.build());
        }
        return result;
    }

    @NotNull
    public final FileSpec generate$graphql_kotlin_client_generator(@NotNull File queryFile) {
        Document queryDocument;
        Intrinsics.checkNotNullParameter((Object)queryFile, (String)"queryFile");
        String queryConst = FilesKt.readText$default((File)queryFile, null, (int)1, null);
        Document document = queryDocument = this.documentParser.parseDocument(queryConst);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"queryDocument");
        List list = document.getDefinitions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryDocument.definitions");
        List operationDefinitions = CollectionsKt.filterIsInstance((Iterable)list, OperationDefinition.class);
        if (operationDefinitions.size() > 1) {
            throw (Throwable)MultipleOperationsInFileException.INSTANCE;
        }
        FileSpec.Builder fileSpec = FileSpec.Companion.builder(this.config.getPackageName(), StringsKt.capitalize((String)FilesKt.getNameWithoutExtension((File)queryFile)));
        Iterable $this$forEach$iv = operationDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationDefinition operationDefinition = (OperationDefinition)element$iv;
            boolean bl = false;
            String string = operationDefinition.getName();
            if (string == null || (string = StringsKt.capitalize((String)string)) == null) {
                string = StringsKt.capitalize((String)FilesKt.getNameWithoutExtension((File)queryFile));
            }
            String operationTypeName = string;
            GraphQLClientGeneratorContext context = new GraphQLClientGeneratorContext(this.config.getPackageName(), this.graphQLSchema, operationTypeName, queryDocument, this.config.getAllowDeprecated(), this.config.getCustomScalarMap());
            String queryConstName = GraphQLClientGeneratorKt.toUpperUnderscore(operationTypeName);
            PropertySpec queryConstProp = PropertySpec.Companion.builder(queryConstName, (TypeName)TypeNames.STRING, new KModifier[0]).addModifiers(new KModifier[]{KModifier.CONST}).initializer("%S", new Object[]{queryConst}).build();
            fileSpec.addProperty(queryConstProp);
            List list2 = operationDefinition.getVariableDefinitions();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"operationDefinition.variableDefinitions");
            TypeSpec variableType = GenerateVariableTypeSpecKt.generateVariableTypeSpec(context, list2);
            ObjectTypeDefinition rootType = this.findRootType(operationDefinition);
            TypeSpec graphQLResponseTypeSpec = GenerateGraphQLObjectTypeSpecKt.generateGraphQLObjectTypeSpec(context, rootType, operationDefinition.getSelectionSet(), "Result");
            ClassName kotlinResultTypeName = new ClassName(context.getPackageName(), new String[]{context.getRootType() + '.' + graphQLResponseTypeSpec.getName()});
            TypeSpec.Builder operationTypeSpec = TypeSpec.Companion.classBuilder(operationTypeName);
            operationTypeSpec.superclass((TypeName)new ClassName("com.expediagroup.graphql.client", new String[]{"GraphQLClientRequest"}));
            operationTypeSpec.addSuperclassConstructorParameter("%N", new Object[]{queryConstProp});
            if (operationDefinition.getName() != null) {
                Object[] objectArray = new Object[1];
                String string2 = operationDefinition.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"operationDefinition.name");
                objectArray[0] = string2;
                operationTypeSpec.addSuperclassConstructorParameter("%S", objectArray);
            }
            if (variableType != null) {
                operationTypeSpec.addType(variableType);
                FunSpec constructor = FunSpec.Companion.constructorBuilder().addParameter("variables", (TypeName)new ClassName(this.config.getPackageName(), new String[]{operationTypeName + ".Variables"}), new KModifier[0]).build();
                operationTypeSpec.primaryConstructor(constructor);
                operationTypeSpec.addSuperclassConstructorParameter("%L", new Object[]{"variables"});
            }
            ParameterizedTypeName parameterizedReturnType = ParameterizedTypeName.Companion.get(new ClassName("java.lang", new String[]{"Class"}), new TypeName[]{(TypeName)kotlinResultTypeName});
            operationTypeSpec.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("responseType").addModifiers(new KModifier[]{KModifier.OVERRIDE}), (TypeName)((TypeName)parameterizedReturnType), null, (int)2, null).addStatement("return %T::class.java", new Object[]{kotlinResultTypeName}).build());
            Map<String, TypeSpec> $this$forEach$iv2 = context.getTypeSpecs();
            boolean $i$f$forEach2 = false;
            Map<String, TypeSpec> map = $this$forEach$iv2;
            boolean bl2 = false;
            Iterator<Map.Entry<String, TypeSpec>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, TypeSpec> element$iv2;
                Map.Entry<String, TypeSpec> it = element$iv2 = iterator.next();
                boolean bl3 = false;
                operationTypeSpec.addType(it.getValue());
            }
            fileSpec.addType(operationTypeSpec.build());
            FunSpec.Builder clientExtensionFunction = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("execute" + operationTypeName).addParameter("request", (TypeName)new ClassName(this.config.getPackageName(), new String[]{operationTypeName}), new KModifier[0]), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(new ClassName("com.expediagroup.graphql.types", new String[]{"GraphQLResponse"}), new TypeName[]{(TypeName)kotlinResultTypeName})), null, (int)2, null).addModifiers(new KModifier[]{KModifier.SUSPEND});
            switch (GraphQLClientGenerator$WhenMappings.$EnumSwitchMapping$0[this.config.getClientType().ordinal()]) {
                case 1: {
                    ParameterSpec ktorRequestCustomizer = ParameterSpec.Companion.builder("requestCustomizer", (TypeName)LambdaTypeName.Companion.get((TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(HttpRequestBuilder.class)), CollectionsKt.emptyList(), (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Unit.class))), new KModifier[0]).defaultValue(CodeBlock.Companion.of("{}", new Object[0])).build();
                    FunSpec.Builder.receiver$default((FunSpec.Builder)clientExtensionFunction, (TypeName)((TypeName)ParameterizedTypeName.Companion.get(new ClassName("com.expediagroup.graphql.client.ktor", new String[]{"GraphQLKtorClient"}), new TypeName[]{(TypeName)TypeNames.STAR})), null, (int)2, null).addParameter(ktorRequestCustomizer).addStatement("return execute(request, requestCustomizer)", new Object[0]);
                    break;
                }
                case 2: {
                    ParameterSpec webClientRequestCustomizer = ParameterSpec.Companion.builder("requestCustomizer", (TypeName)LambdaTypeName.Companion.get((TypeName)new ClassName("org.springframework.web.reactive.function.client", new String[]{"WebClient", "RequestBodyUriSpec"}), CollectionsKt.emptyList(), (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Unit.class))), new KModifier[0]).defaultValue(CodeBlock.Companion.of("{}", new Object[0])).build();
                    FunSpec.Builder.receiver$default((FunSpec.Builder)clientExtensionFunction, (TypeName)((TypeName)new ClassName("com.expediagroup.graphql.client.spring", new String[]{"GraphQLWebClient"})), null, (int)2, null).addParameter(webClientRequestCustomizer).addStatement("return execute(request, requestCustomizer)", new Object[0]);
                    break;
                }
                default: {
                    FunSpec.Builder.receiver$default((FunSpec.Builder)clientExtensionFunction, (TypeName)((TypeName)ParameterizedTypeName.Companion.get(new ClassName("com.expediagroup.graphql.client", new String[]{"GraphQLClient"}), new TypeName[]{(TypeName)TypeNames.STAR})), null, (int)2, null).addStatement("return execute(request)", new Object[0]);
                }
            }
            fileSpec.addFunction(clientExtensionFunction.build());
            this.typeAliases.putAll(context.getTypeAliases());
        }
        return fileSpec.build();
    }

    /*
     * WARNING - void declaration
     */
    private final ObjectTypeDefinition findRootType(OperationDefinition operationDefinition) {
        Map map;
        Optional optional = this.graphQLSchema.schemaDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"graphQLSchema.schemaDefinition()");
        if (optional.isPresent()) {
            void $this$associateByTo$iv$iv;
            Object t = this.graphQLSchema.schemaDefinition().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"graphQLSchema.schemaDefinition().get()");
            List list = ((SchemaDefinition)t).getOperationTypeDefinitions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"graphQLSchema.schemaDefi\u2026.operationTypeDefinitions");
            Iterable $this$associateBy$iv = list;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                String string;
                OperationTypeDefinition it;
                OperationTypeDefinition operationTypeDefinition = (OperationTypeDefinition)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                void v3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                Intrinsics.checkNotNullExpressionValue((Object)v3.getName(), (String)"it.name");
                boolean bl2 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
                String string4 = string3;
                it = (OperationTypeDefinition)element$iv$iv;
                boolean bl3 = false;
                OperationTypeDefinition operationTypeDefinition2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)operationTypeDefinition2, (String)"it");
                graphql.language.TypeName typeName = operationTypeDefinition2.getTypeName();
                Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"it.typeName");
                String string5 = typeName.getName();
                map2.put(string4, string5);
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)OperationDefinition.Operation.QUERY.name(), (Object)"Query"), TuplesKt.to((Object)OperationDefinition.Operation.MUTATION.name(), (Object)"Mutation"), TuplesKt.to((Object)OperationDefinition.Operation.SUBSCRIPTION.name(), (Object)"Subscription")});
        }
        Map operationNames = map;
        String rootType = (String)operationNames.get(operationDefinition.getOperation().name());
        Object t = this.graphQLSchema.getType(rootType).get();
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type graphql.language.ObjectTypeDefinition");
        }
        return (ObjectTypeDefinition)t;
    }

    public GraphQLClientGenerator(@NotNull TypeDefinitionRegistry graphQLSchema, @NotNull GraphQLClientGeneratorConfig config) {
        Intrinsics.checkNotNullParameter((Object)graphQLSchema, (String)"graphQLSchema");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.graphQLSchema = graphQLSchema;
        this.config = config;
        this.documentParser = new Parser();
        boolean bl = false;
        this.typeAliases = new LinkedHashMap();
    }
}

