/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.tesla.compiler.plugins;

import com.expedia.tesla.compiler.Util;
import com.expedia.tesla.compiler.plugins.JavaTypeMapper;
import com.expedia.tesla.schema.Enum;
import com.expedia.tesla.schema.Field;
import com.expedia.tesla.schema.Primitive;
import com.expedia.tesla.schema.TeslaSchemaException;
import org.apache.commons.lang.StringEscapeUtils;

public class JavaUtils
extends Util {
    JavaTypeMapper typeMapper = new JavaTypeMapper();

    public String getJavaTypeName(Field field) throws TeslaSchemaException {
        return this.typeMapper.getTypeDescriptor(field.getType()).getInterfaceName();
    }

    public String getWriteMethod(Field field) {
        String method = "writeObject";
        if (field.getType() instanceof Primitive) {
            method = "write" + JavaUtils.firstCharUpperCase(((Primitive)field.getType()).getName());
        } else if (field.getType() instanceof Enum) {
            method = "writeEnum";
        }
        if (field.getRank() > 0) {
            method = method + "Array";
        }
        return method;
    }

    public String getReadMethod(Field field) {
        String method = "readObject";
        if (field.getType() instanceof Primitive) {
            method = "read" + JavaUtils.firstCharUpperCase(((Primitive)field.getType()).getName());
        } else if (field.getType() instanceof Enum) {
            method = "readEnum";
        }
        if (field.getRank() > 0) {
            method = method + "Array";
        }
        return method;
    }

    public String escapeStringLiteral(String str) {
        return '\"' + StringEscapeUtils.escapeJava((String)str) + '\"';
    }

    public String escapeMultiLineStringLiteral(String str) {
        String[] lines;
        StringBuilder sb = new StringBuilder();
        for (String line : lines = str.split("\\r?\\n")) {
            if (sb.length() > 0) {
                sb.append(" +\n");
            }
            sb.append(this.escapeStringLiteral(line));
        }
        return sb.toString();
    }
}

