/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.tesla.compiler.plugins;

import com.expedia.tesla.compiler.Util;
import com.expedia.tesla.schema.Class;
import com.expedia.tesla.schema.Enum;
import com.expedia.tesla.schema.Field;
import com.expedia.tesla.schema.Primitive;
import com.expedia.tesla.schema.Type;

public class CppUtils
extends Util {
    public String getTeslaTypeTag(Field field) {
        StringBuilder tagBuilder = new StringBuilder("TeslaType_");
        Type type = field.getType();
        if (type instanceof Primitive) {
            tagBuilder.append(((Primitive)type).getName());
        } else if (type instanceof Class) {
            tagBuilder.append("Object");
        } else if (type instanceof Enum) {
            tagBuilder.append("Enum");
        }
        if (field.getIsReference()) {
            tagBuilder.append("Reference");
        }
        if (field.getIsArray()) {
            tagBuilder.append("Array");
            if (field.getRank() > 1) {
                tagBuilder.append(field.getRank());
                tagBuilder.append("D");
            }
        }
        if (field.getIsOptional()) {
            tagBuilder.append("Nullable");
        }
        return tagBuilder.toString();
    }
}

