/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.tesla.compiler.plugins;

import com.expedia.tesla.compiler.Util;
import com.expedia.tesla.compiler.plugins.CppTypeDescriptor;
import com.expedia.tesla.schema.Array;
import com.expedia.tesla.schema.Nullable;
import com.expedia.tesla.schema.Poly;
import com.expedia.tesla.schema.Primitive;
import com.expedia.tesla.schema.Reference;
import com.expedia.tesla.schema.TeslaSchemaException;
import com.expedia.tesla.schema.Type;
import com.expedia.tesla.schema.UserType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CppTypeMapper {
    private static final Map<Primitive, CppTypeDescriptor> PRIM_DESCRIPTORS = new HashMap<Primitive, CppTypeDescriptor>();

    public CppTypeDescriptor getDescriptor(Type t) throws TeslaSchemaException {
        if (t.isPrimitive()) {
            CppTypeDescriptor td = PRIM_DESCRIPTORS.get(t);
            assert (td != null) : "BUG! missing a primitive type mapping '" + t.getTypeId() + "'";
            return td;
        }
        if (t.isNullable()) {
            Nullable nt = (Nullable)t;
            Type e = nt.getElementType();
            CppTypeDescriptor etd = this.getDescriptor(e);
            return new CppTypeDescriptor(t, this.symbol(t), String.format("boost::shared_ptr<%s >", etd.getCppTypeName()));
        }
        if (t.isReference()) {
            Reference nt = (Reference)t;
            Type e = nt.getElementType();
            CppTypeDescriptor etd = this.getDescriptor(e);
            return new CppTypeDescriptor(t, this.symbol(t), String.format("boost::shared_ptr<%s >", etd.getCppTypeName()));
        }
        if (t.isArray()) {
            Array a = (Array)t;
            Type e = a.getElementType();
            CppTypeDescriptor etd = this.getDescriptor(e);
            String typeName = String.format("std::vector<%s >", etd.getCppTypeName());
            return new CppTypeDescriptor(t, this.symbol(t), typeName);
        }
        if (t.isMap()) {
            com.expedia.tesla.schema.Map m = (com.expedia.tesla.schema.Map)t;
            Type keyType = m.getKeyType();
            Type valueType = m.getValueType();
            CppTypeDescriptor ktd = this.getDescriptor(keyType);
            CppTypeDescriptor vtd = this.getDescriptor(valueType);
            String cppTypeName = String.format("std::map<%s, %s >", ktd.getCppTypeName(), vtd.getCppTypeName());
            return new CppTypeDescriptor(t, this.symbol(t), cppTypeName);
        }
        if (t.isUserType()) {
            String name = ((UserType)t).getShortName();
            return new CppTypeDescriptor(t, this.symbol(t), name);
        }
        if (t.isPoly()) {
            Poly pt = (Poly)t;
            ArrayList<String> elementCppTypeNames = new ArrayList<String>();
            for (Type elementType : pt.getElementTypes()) {
                elementCppTypeNames.add(this.getDescriptor(elementType).getCppTypeName());
            }
            return new CppTypeDescriptor(t, this.symbol(t), String.format("boost::variant<%s >", Util.commaSeparate(elementCppTypeNames)));
        }
        throw new AssertionError((Object)String.format("unknown type '%s'", t));
    }

    public String symbol(Type t) {
        return "_" + t.getTypeId().replaceAll("\\.|<|>|,|\\[|\\]", "_");
    }

    static {
        PRIM_DESCRIPTORS.put(Primitive.BYTE, new CppTypeDescriptor((Type)Primitive.BYTE, "Byte", "unsigned char"));
        PRIM_DESCRIPTORS.put(Primitive.UINT16, new CppTypeDescriptor((Type)Primitive.UINT16, "UInt16", "unsigned short"));
        PRIM_DESCRIPTORS.put(Primitive.UINT32, new CppTypeDescriptor((Type)Primitive.UINT32, "UInt32", "unsigned int"));
        PRIM_DESCRIPTORS.put(Primitive.UINT64, new CppTypeDescriptor((Type)Primitive.UINT64, "UInt64", "unsigned long long"));
        PRIM_DESCRIPTORS.put(Primitive.INT16, new CppTypeDescriptor((Type)Primitive.INT16, "Int16", "short"));
        PRIM_DESCRIPTORS.put(Primitive.INT32, new CppTypeDescriptor((Type)Primitive.INT32, "Int32", "int"));
        PRIM_DESCRIPTORS.put(Primitive.INT64, new CppTypeDescriptor((Type)Primitive.INT64, "Int64", "long long"));
        PRIM_DESCRIPTORS.put(Primitive.BOOLEAN, new CppTypeDescriptor((Type)Primitive.BOOLEAN, "Boolean", "bool"));
        PRIM_DESCRIPTORS.put(Primitive.FLOAT, new CppTypeDescriptor((Type)Primitive.FLOAT, "Float", "float"));
        PRIM_DESCRIPTORS.put(Primitive.DOUBLE, new CppTypeDescriptor((Type)Primitive.DOUBLE, "Double", "double"));
        PRIM_DESCRIPTORS.put(Primitive.STRING, new CppTypeDescriptor((Type)Primitive.STRING, "String", "std::string"));
        PRIM_DESCRIPTORS.put(Primitive.BINARY, new CppTypeDescriptor((Type)Primitive.BINARY, "Binary", "std::vector<char>"));
    }
}

