/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.tesla.compiler;

import com.expedia.tesla.schema.Schema;
import com.expedia.tesla.schema.UserType;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;

public class Util {
    public static <T> String commaSeparate(Collection<T> list) {
        return Util.delimiterSeparate(list, ", ");
    }

    public static <T> String delimiterSeparate(Collection<T> list, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (T e : list) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(e.toString());
        }
        return sb.toString();
    }

    public static String firstCharLowerCase(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static String firstCharUpperCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String toShortName(String fullName) {
        return UserType.toShortName((String)fullName);
    }

    public static String toNameSpace(String fullName) {
        return UserType.toNameSpace((String)fullName);
    }

    public static String getNewLine() {
        return "\n";
    }

    public static Collection<UserType> getAllUserTypes(Collection<Schema> schemas) {
        TreeMap<String, UserType> all = new TreeMap<String, UserType>();
        for (Schema schema : schemas) {
            for (UserType t : schema.getUserTypes()) {
                all.put(t.getName(), t);
            }
        }
        return all.values();
    }

    public static Collection<String> expandWildcard(Collection<String> pathOrPatterns) throws IOException {
        final ArrayList<String> files = new ArrayList<String>();
        final ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>();
        for (String pattern : pathOrPatterns) {
            if (pattern.contains("*") || pattern.contains("?")) {
                PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
                matchers.add(matcher);
                continue;
            }
            files.add(pattern);
        }
        if (!matchers.isEmpty()) {
            Files.walkFileTree(new File(System.getProperty("user.dir")).toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
                    for (PathMatcher matcher : matchers) {
                        if (!matcher.matches(file)) continue;
                        files.add(file.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return files;
    }

    public static URL[] parseClassPath(String classpath) throws IOException {
        String splitPattern = Character.toString(File.pathSeparatorChar);
        String wildcardPattern = ".+\\*";
        String[] paths = classpath.split(splitPattern);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            if ((path = path.trim()).matches(".+\\*")) {
                File[] files;
                File folder = new File(path.replace("\\*", ""));
                if (!folder.exists()) continue;
                for (File f : files = folder.listFiles()) {
                    urls.add(f.toURI().toURL());
                }
                continue;
            }
            urls.add(new File(path).toURI().toURL());
        }
        URL[] result = new URL[urls.size()];
        return urls.toArray(result);
    }

    public static Class<?> loadClass(String name, String classpath) throws ClassNotFoundException, IOException {
        return Util.loadClass(name, classpath == null || classpath.isEmpty() ? null : Util.parseClassPath(classpath));
    }

    public static Class<?> loadClass(String name, URL[] urls) throws ClassNotFoundException, IOException {
        Class<?> clzz = null;
        if (urls != null && urls.length > 0) {
            URLClassLoader cl = URLClassLoader.newInstance(urls, Thread.currentThread().getContextClassLoader());
            clzz = cl.loadClass(name);
        }
        if (clzz == null) {
            clzz = Class.forName(name);
        }
        return clzz;
    }

    public static void forceMkdirParent(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent == null) {
            return;
        }
        FileUtils.forceMkdir((File)parent);
    }
}

