/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.tesla.compiler;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.expedia.tesla.compiler.MergedClass;
import com.expedia.tesla.compiler.MergedEnum;
import com.expedia.tesla.compiler.MergedSchema;
import com.expedia.tesla.compiler.TemplateEngine;
import com.expedia.tesla.compiler.Util;
import com.expedia.tesla.compiler.plugins.CSharpUtils;
import com.expedia.tesla.compiler.plugins.CppUtils;
import com.expedia.tesla.compiler.plugins.JavaTypeMapper;
import com.expedia.tesla.compiler.plugins.JavaUtils;
import com.expedia.tesla.schema.Schema;
import com.expedia.tesla.schema.TeslaSchemaException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class Compiler {
    @Parameter(names={"-l", "--language"}, description="The output code language (Java, C# or C++).")
    private String language = "java";
    @Parameter(names={"-s", "--serializer"}, description="The full name the generated serializer class name (e.g. com.expedia.sample.AppSchema). Or C++ header file name without extension name.")
    private String appSchemaClassName = null;
    @Parameter(names={"-o", "--output-dir"}, description="The output directory. Output to current directory by default.")
    private String outputDir = System.getProperty("user.dir");
    @Parameter(names={"-c", "--class-template"}, description="User class source code template.")
    private String classTemplatePath;
    @Parameter(names={"-m", "--enum-template"}, description="User enum source code template.")
    private String enumTemplatePath;
    @Parameter(names={"-v", "--serializer-template"}, description="User serializer source code template.")
    private String appSchemaTemplatePath;
    @Parameter(names={"-nu", "--not-generate-user-types"}, description="Not generate source code for user types.")
    private boolean notGenerateUserTypes;
    @Parameter(names={"-E", "--plugin"}, description="Create a plugin object of type <class_name> with <variable_name>. The plugin object will be available in template enginees, and can be refered by variable $variable_name.")
    private Map<String, String> extension = new HashMap<String, String>();
    @Parameter(description="Tesla schema files (TMLs).", required=true)
    private List<String> schemaFiles = new ArrayList<String>();
    @Parameter(names={"-cp", "-classpath"}, description="Java classpath that compiler will search for user classes.")
    private String classpath;
    @Parameter(names={"-h", "--help"}, description="Show this help message.", help=true)
    private boolean help;

    public String getLanguage() {
        return this.language;
    }

    public String getAppSchemaClassName() {
        return this.appSchemaClassName;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public String getClassTemplatePath() {
        return this.classTemplatePath;
    }

    public String getEnumTemplatePath() {
        return this.enumTemplatePath;
    }

    public String getAppSchemaTemplatePath() {
        return this.appSchemaTemplatePath;
    }

    public boolean isNotGenerateUserTypes() {
        return this.notGenerateUserTypes;
    }

    public Map<String, String> getExtension() {
        return this.extension;
    }

    public List<String> getSchemaFiles() {
        return this.schemaFiles;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setAppSchemaClassName(String appSchemaClassName) {
        this.appSchemaClassName = appSchemaClassName;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setClassTemplatePath(String classTemplatePath) {
        this.classTemplatePath = classTemplatePath;
    }

    public void setEnumTemplatePath(String enumTemplatePath) {
        this.enumTemplatePath = enumTemplatePath;
    }

    public void setAppSchemaTemplatePath(String appSchemaTemplatePath) {
        this.appSchemaTemplatePath = appSchemaTemplatePath;
    }

    public void setNotGenerateUserTypes(boolean notGenerateUserTypes) {
        this.notGenerateUserTypes = notGenerateUserTypes;
    }

    public void setExtension(Map<String, String> extension) {
        this.extension = extension;
    }

    public void setSchemaFiles(List<String> schemaFiles) {
        this.schemaFiles = schemaFiles;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void compile() throws Exception {
        MergedSchema ms = this.mergeSchemas(this.schemaFiles);
        if (!this.notGenerateUserTypes) {
            this.writeClasses(ms.getClasses());
            this.writeEnums(ms.getEnumes());
        }
        this.writeAppSchema(ms.getSchemas());
        System.out.println("Tesla compiled schema(s) successfully.");
    }

    private Map<String, Object> loadExtension() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.extension != null) {
            for (String varName : this.extension.keySet()) {
                String varClassName = this.extension.get(varName);
                Class<?> clazz = Class.forName(varClassName);
                variables.put(varName, clazz.newInstance());
            }
        }
        return variables;
    }

    private void writeEnums(List<MergedEnum> enums) throws Exception {
        TemplateEngine te = new TemplateEngine(this.language, this.enumTemplatePath, "enum.vm");
        for (MergedEnum me : enums) {
            TreeMap<String, Object> variables = new TreeMap<String, Object>();
            variables.put("enum", (Object)me);
            variables.put("util", this.createUtilObject());
            variables.putAll(this.loadExtension());
            String path = this.getOutputPath(me.getName());
            FileWriter writer = new FileWriter(path);
            Throwable throwable = null;
            try {
                System.out.println("Writing source file " + path);
                te.merge(variables, writer);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                ((Writer)writer).close();
            }
        }
    }

    private String getOutputPath(String fullName) throws IOException {
        String[] tmp;
        String path = null;
        if (this.language.equals("java")) {
            path = FilenameUtils.concat((String)this.outputDir, (String)fullName.replace('.', File.separatorChar)) + ".java";
        } else if (this.language.equals("csharp")) {
            tmp = fullName.split("\\.");
            path = FilenameUtils.concat((String)this.outputDir, (String)(tmp[tmp.length - 1] + ".cs"));
        } else if (this.language.equals("cpp")) {
            tmp = fullName.split("\\.");
            path = FilenameUtils.concat((String)this.outputDir, (String)(tmp[tmp.length - 1] + ".h"));
        }
        File file = new File(path);
        Util.forceMkdirParent(file);
        return file.getAbsolutePath();
    }

    private void writeClasses(List<MergedClass> classes) throws Exception {
        TemplateEngine te = new TemplateEngine(this.language, this.classTemplatePath, "class.vm");
        for (MergedClass mc : classes) {
            TreeMap<String, Object> variables = new TreeMap<String, Object>();
            variables.put("class", (Object)mc);
            variables.put("util", this.createUtilObject());
            variables.put("serializerName", this.appSchemaClassName);
            variables.putAll(this.loadExtension());
            String path = this.getOutputPath(mc.getName());
            FileWriter writer = new FileWriter(path);
            Throwable throwable = null;
            try {
                System.out.println("Writing source file " + path);
                te.merge(variables, writer);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                ((Writer)writer).close();
            }
        }
    }

    private Object createUtilObject() {
        if (this.language.equals("java")) {
            return new JavaUtils();
        }
        if (this.language.equals("cpp")) {
            return new CppUtils();
        }
        if (this.language.equals("csharp")) {
            return new CSharpUtils();
        }
        return null;
    }

    private void writeAppSchema(Collection<Schema> collection) throws IOException {
        if (this.appSchemaClassName == null || this.appSchemaClassName.isEmpty()) {
            return;
        }
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        String appSchemaClassShortName = this.appSchemaClassName;
        String appSchemaClassNamespace = null;
        if (this.appSchemaClassName.matches(".+\\..+")) {
            int pos = this.appSchemaClassName.lastIndexOf(46);
            appSchemaClassShortName = this.appSchemaClassName.substring(pos + 1);
            appSchemaClassNamespace = this.appSchemaClassName.substring(0, pos);
        }
        String defaultTemplate = this.language.equals("java") ? "serializer.vm" : "application_schema.vm";
        TemplateEngine te = new TemplateEngine(this.language, this.appSchemaTemplatePath, defaultTemplate);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("schemas", collection);
        variables.put("className", appSchemaClassShortName);
        variables.put("namespace", appSchemaClassNamespace);
        variables.put("util", this.createUtilObject());
        variables.put("mapper", new JavaTypeMapper());
        String path = this.getOutputPath(this.appSchemaClassName);
        try (FileWriter writer = new FileWriter(path);){
            System.out.println("Writing source file " + path);
            te.merge(variables, writer);
            ((Writer)writer).flush();
        }
    }

    private MergedSchema mergeSchemas(List<String> values) throws TeslaSchemaException, IOException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (String path : Util.expandWildcard(values)) {
            schemas.add(Schema.build((String)path));
        }
        return new MergedSchema(schemas);
    }

    public static void main(String[] args) throws Exception {
        JCommander jc = null;
        try {
            Compiler compiler = new Compiler();
            jc = new JCommander((Object)compiler);
            jc.parse(args);
            if (compiler.help) {
                jc.usage();
            } else {
                compiler.compile();
            }
        }
        catch (ParameterException e) {
            System.err.printf("Error: %s\nUse -h or --help option to show usage help.\n", e.getMessage());
            System.exit(1);
        }
    }
}

