/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.graphql.schema.generator;

import com.expedia.graphql.exceptions.ConflictingTypesException;
import com.expedia.graphql.exceptions.CouldNotGetNameOfEnumException;
import com.expedia.graphql.exceptions.TypeNotSupportedException;
import com.expedia.graphql.schema.extensions.KClassExtensionsKt;
import com.expedia.graphql.schema.extensions.KTypeExtensionsKt;
import com.expedia.graphql.schema.generator.TypesCacheKey;
import com.expedia.graphql.schema.generator.models.KGraphQLType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J*\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0016\u0010\u000f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\r0\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\rJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u00020\u00042\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00042\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u0018\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\bJ\u0014\u0010#\u001a\u00020\u00122\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0012\u0010$\u001a\u00020\u00122\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/expedia/graphql/schema/generator/TypesCache;", "", "supportedPackages", "", "", "(Ljava/util/List;)V", "cache", "", "Lcom/expedia/graphql/schema/generator/models/KGraphQLType;", "typeUnderConstruction", "", "Lkotlin/reflect/KClass;", "buildIfNotUnderConstruction", "Lgraphql/schema/GraphQLType;", "kClass", "build", "Lkotlin/Function1;", "doesNotContain", "", "doesNotContainGraphQLType", "graphQLType", "get", "cacheKey", "Lcom/expedia/graphql/schema/generator/TypesCacheKey;", "getArrayTypeName", "kType", "Lkotlin/reflect/KType;", "getArrayTypeNameFromKClass", "getCacheKeyString", "getCacheTypeName", "getJvmErasureNameFromList", "type", "put", "key", "kGraphQLType", "putTypeUnderConstruction", "removeTypeUnderConstruction", "throwIfTypeIsNotSupported", "", "graphql-kotlin"})
public final class TypesCache {
    private final Map<String, KGraphQLType> cache;
    private final Set<KClass<?>> typeUnderConstruction;
    private final List<String> supportedPackages;

    @Nullable
    public final GraphQLType get(@NotNull TypesCacheKey cacheKey) throws ConflictingTypesException {
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        String cacheKeyString = this.getCacheKeyString(cacheKey);
        KGraphQLType cachedType = this.cache.get(cacheKeyString);
        if (cachedType != null) {
            KClass<?> kClass = KTypeExtensionsKt.getKClass(cacheKey.getType());
            boolean isSameNameButNotSameClass = Intrinsics.areEqual(cachedType.getKClass(), kClass) ^ true;
            if (isSameNameButNotSameClass) {
                throw (Throwable)new ConflictingTypesException(cachedType.getKClass(), kClass);
            }
            return cachedType.getGraphQLType();
        }
        return null;
    }

    @Nullable
    public final KGraphQLType put(@NotNull TypesCacheKey key, @NotNull KGraphQLType kGraphQLType) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)kGraphQLType, (String)"kGraphQLType");
        this.typeUnderConstruction.remove(kGraphQLType.getKClass());
        return this.cache.put(this.getCacheKeyString(key), kGraphQLType);
    }

    public final boolean doesNotContainGraphQLType(@NotNull GraphQLType graphQLType) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)graphQLType, (String)"graphQLType");
            Map<String, KGraphQLType> $receiver$iv = this.cache;
            if ($receiver$iv.isEmpty()) {
                bl = true;
            } else {
                Map<String, KGraphQLType> map = $receiver$iv;
                for (Map.Entry<String, KGraphQLType> element$iv : map.entrySet()) {
                    Map.Entry<String, KGraphQLType> $$_$_v = element$iv;
                    Map.Entry<String, KGraphQLType> entry = $$_$_v;
                    KGraphQLType v = entry.getValue();
                    if (!Intrinsics.areEqual((Object)v.getGraphQLType().getName(), (Object)graphQLType.getName())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean doesNotContain(@NotNull KClass<?> kClass) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(kClass, (String)"kClass");
            Map<String, KGraphQLType> $receiver$iv = this.cache;
            if ($receiver$iv.isEmpty()) {
                bl = true;
            } else {
                Map<String, KGraphQLType> map = $receiver$iv;
                for (Map.Entry<String, KGraphQLType> element$iv : map.entrySet()) {
                    Map.Entry<String, KGraphQLType> $$_$_ktype = element$iv;
                    Map.Entry<String, KGraphQLType> entry = $$_$_ktype;
                    KGraphQLType ktype = entry.getValue();
                    if (!Intrinsics.areEqual(ktype.getKClass(), kClass)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final String getCacheKeyString(TypesCacheKey cacheKey) throws CouldNotGetNameOfEnumException {
        KClass<?> kClass = KTypeExtensionsKt.getKClass(cacheKey.getType());
        if (KClasses.isSubclassOf(kClass, (KClass)Reflection.getOrCreateKotlinClass(Enum.class))) {
            String string = kClass.getSimpleName();
            if (string == null) {
                throw (Throwable)new CouldNotGetNameOfEnumException(kClass);
            }
            return string;
        }
        String cacheKeyFromTypeName = KClassExtensionsKt.isList(kClass) ? "List<" + this.getJvmErasureNameFromList(cacheKey.getType()) + '>' : (KClassExtensionsKt.isArray(kClass) ? this.getArrayTypeName(kClass, cacheKey.getType()) : this.getCacheTypeName(cacheKey.getType()));
        return cacheKeyFromTypeName + ':' + cacheKey.getInputType();
    }

    private final String getArrayTypeName(KClass<?> kClass, KType kType) {
        String kClassName = this.getArrayTypeNameFromKClass(kClass);
        return kClassName != null ? kClassName : "Array<" + this.getJvmErasureNameFromList(kType) + '>';
    }

    private final String getArrayTypeNameFromKClass(KClass<?> kClass) {
        return KClasses.isSubclassOf(kClass, (KClass)Reflection.getOrCreateKotlinClass(int[].class)) ? Reflection.getOrCreateKotlinClass(int[].class).getSimpleName() : (KClasses.isSubclassOf(kClass, (KClass)Reflection.getOrCreateKotlinClass(long[].class)) ? Reflection.getOrCreateKotlinClass(long[].class).getSimpleName() : (KClasses.isSubclassOf(kClass, (KClass)Reflection.getOrCreateKotlinClass(short[].class)) ? Reflection.getOrCreateKotlinClass(short[].class).getSimpleName() : (KClasses.isSubclassOf(kClass, (KClass)Reflection.getOrCreateKotlinClass(float[].class)) ? Reflection.getOrCreateKotlinClass(float[].class).getSimpleName() : (KClasses.isSubclassOf(kClass, (KClass)Reflection.getOrCreateKotlinClass(double[].class)) ? Reflection.getOrCreateKotlinClass(double[].class).getSimpleName() : (KClasses.isSubclassOf(kClass, (KClass)Reflection.getOrCreateKotlinClass(char[].class)) ? Reflection.getOrCreateKotlinClass(char[].class).getSimpleName() : (KClasses.isSubclassOf(kClass, (KClass)Reflection.getOrCreateKotlinClass(boolean[].class)) ? Reflection.getOrCreateKotlinClass(boolean[].class).getSimpleName() : null))))));
    }

    private final String getCacheTypeName(KType kType) {
        this.throwIfTypeIsNotSupported(kType);
        return KTypeExtensionsKt.getJvmErasureName(kType);
    }

    private final String getJvmErasureNameFromList(KType type) {
        return KTypeExtensionsKt.getJvmErasureName(KTypeExtensionsKt.getTypeOfFirstArgument(type));
    }

    private final void throwIfTypeIsNotSupported(KType type) throws TypeNotSupportedException {
        boolean comesFromSupportedPackageName;
        String qualifiedName;
        block5: {
            boolean bl;
            String string = KTypesJvm.getJvmErasure((KType)type).getQualifiedName();
            if (string == null) {
                string = "";
            }
            qualifiedName = string;
            Iterable $receiver$iv = this.supportedPackages;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    if (!StringsKt.startsWith$default((String)qualifiedName, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block5;
                }
                bl = comesFromSupportedPackageName = false;
            }
        }
        if (!comesFromSupportedPackageName) {
            throw (Throwable)new TypeNotSupportedException(qualifiedName, this.supportedPackages);
        }
    }

    private final boolean putTypeUnderConstruction(KClass<?> kClass) {
        return this.typeUnderConstruction.add(kClass);
    }

    public final boolean removeTypeUnderConstruction(@NotNull KClass<?> kClass) {
        Intrinsics.checkParameterIsNotNull(kClass, (String)"kClass");
        return this.typeUnderConstruction.remove(kClass);
    }

    @NotNull
    public final GraphQLType buildIfNotUnderConstruction(@NotNull KClass<?> kClass, @NotNull Function1<? super KClass<?>, ? extends GraphQLType> build) {
        GraphQLType graphQLType;
        Intrinsics.checkParameterIsNotNull(kClass, (String)"kClass");
        Intrinsics.checkParameterIsNotNull(build, (String)"build");
        if (this.typeUnderConstruction.contains(kClass)) {
            GraphQLTypeReference graphQLTypeReference = GraphQLTypeReference.typeRef((String)kClass.getSimpleName());
            Intrinsics.checkExpressionValueIsNotNull((Object)graphQLTypeReference, (String)"GraphQLTypeReference.typeRef(kClass.simpleName)");
            graphQLType = (GraphQLType)graphQLTypeReference;
        } else {
            this.putTypeUnderConstruction(kClass);
            graphQLType = (GraphQLType)build.invoke(kClass);
        }
        return graphQLType;
    }

    public TypesCache(@NotNull List<String> supportedPackages) {
        Intrinsics.checkParameterIsNotNull(supportedPackages, (String)"supportedPackages");
        this.supportedPackages = supportedPackages;
        TypesCache typesCache = this;
        Object object = new LinkedHashMap();
        typesCache.cache = object;
        typesCache = this;
        typesCache.typeUnderConstruction = object = (Set)new LinkedHashSet();
    }
}

