/*
 * Decompiled with CFR 0.152.
 */
package com.exblr.dropdownmenu;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.exblr.dropdownmenu.DropdownListItem;
import com.exblr.dropdownmenu.R;
import java.util.List;

public class DropdownListAdapter
extends BaseAdapter {
    private Context mContext;
    private String mDefaultTitle;
    private List<DropdownListItem> mList;
    private int mNormalTextColor = -10066330;
    private int mSelectedTextColor = -13012548;

    public DropdownListAdapter(Context context, String defaultTitle, List<DropdownListItem> list) {
        this.mContext = context;
        this.mDefaultTitle = defaultTitle;
        this.mList = list;
    }

    public int getCount() {
        return this.mList.size();
    }

    public DropdownListItem getItem(int position) {
        return this.mList.get(position);
    }

    public long getItemId(int position) {
        return this.mList.get(position).getValue();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView != null) {
            viewHolder = (ViewHolder)convertView.getTag();
        } else {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.dopdown_list_item, null);
            viewHolder = new ViewHolder(convertView);
            convertView.setTag((Object)viewHolder);
        }
        viewHolder.bind(this.getItem(position));
        return convertView;
    }

    public String getSelectedItemString() {
        for (DropdownListItem item : this.mList) {
            if (!item.isSelected() || item.isEmptyItem()) continue;
            return item.getText();
        }
        return this.mDefaultTitle;
    }

    public void setSelectedItem(int position) {
        for (int i = 0; i < this.mList.size(); ++i) {
            this.mList.get(i).setSelected(position == i);
        }
        this.notifyDataSetChanged();
    }

    private class ViewHolder {
        TextView mTextView;

        ViewHolder(View view) {
            this.mTextView = (TextView)view.findViewById(R.id.dropdown_list_item_text_view);
        }

        public void bind(DropdownListItem item) {
            this.mTextView.setText((CharSequence)item.getText());
            if (item.isSelected()) {
                this.mTextView.setTextColor(DropdownListAdapter.this.mSelectedTextColor);
                this.mTextView.setCompoundDrawablesWithIntrinsicBounds(null, null, DropdownListAdapter.this.mContext.getResources().getDrawable(R.drawable.ic_list_item_checked), null);
            } else {
                this.mTextView.setTextColor(DropdownListAdapter.this.mNormalTextColor);
                this.mTextView.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
            }
        }
    }
}

