/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.errorreporting;

import com.exasol.errorreporting.Quoting;

public class Placeholder {
    private final String reference;
    private final int startIndex;
    private final int endIndex;
    private final Quoting quoting;

    public static Builder parse(String placeholderString) {
        int separatorIndex = placeholderString.indexOf(124);
        if (separatorIndex >= 0) {
            String reference = placeholderString.substring(0, separatorIndex);
            Builder builder = new Builder(reference);
            String switches = placeholderString.substring(separatorIndex + 1);
            if (switches.contains("u")) {
                builder.quoting(Quoting.UNQUOTED);
            } else if (switches.contains("q")) {
                builder.quoting(Quoting.SINGLE_QUOTES);
            } else if (switches.contains("d")) {
                builder.quoting(Quoting.DOUBLE_QUOTES);
            } else {
                builder.quoting(Quoting.AUTOMATIC);
            }
            return builder;
        }
        return new Builder(placeholderString).quoting(Quoting.AUTOMATIC);
    }

    private Placeholder(Builder builder) {
        this.reference = builder.reference;
        this.startIndex = builder.startIndex;
        this.endIndex = builder.endIndex;
        this.quoting = builder.quoting;
    }

    public String getReference() {
        return this.reference;
    }

    public Quoting getQuoting() {
        return this.quoting;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public String toString() {
        return "Placeholder [reference=" + this.reference + ", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", quoting=" + this.quoting + "]";
    }

    public static final class Builder {
        private final String reference;
        private int startIndex;
        private int endIndex;
        private Quoting quoting;

        public Builder(String reference) {
            this.reference = reference;
        }

        public Placeholder build() {
            return new Placeholder(this);
        }

        public Builder startIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder endIndex(int endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        public Builder quoting(Quoting quoting) {
            this.quoting = quoting;
            return this;
        }
    }
}

